//[mokkery-runtime](../../../../index.md)/[dev.mokkery.matcher](../../index.md)/[ArgMatcher](../index.md)/[Composite](index.md)

# Composite

@DelicateMokkeryApi

interface [Composite](index.md)&lt;[T](index.md)&gt; : [ArgMatcher](../index.md)&lt;[T](index.md)&gt; , [Capture](../../../dev.mokkery.matcher.capture/-capture/index.md)&lt;[T](index.md)&gt; 

Arg matcher that must be composed with other matchers. Every composite matcher has to implement [Capture](../../../dev.mokkery.matcher.capture/-capture/index.md) to propagate it to its children. Use [dev.mokkery.matcher.capture.propagateCapture](../../../dev.mokkery.matcher.capture/propagate-capture.md) for convenience.

Check existing implementations to learn how to implement it correctly

#### Inheritors

| |
|---|
| [CaptureMatcher](../../../dev.mokkery.matcher.capture/-capture-matcher/index.md) |
| [And](../../../dev.mokkery.matcher.logical/-logical-matchers/-and/index.md) |
| [Or](../../../dev.mokkery.matcher.logical/-logical-matchers/-or/index.md) |
| [Not](../../../dev.mokkery.matcher.logical/-logical-matchers/-not/index.md) |
| [NotNullMatcher](../../../dev.mokkery.matcher.nullable/-not-null-matcher/index.md) |

## Functions

| Name | Summary |
|---|---|
| [assertFilled](assert-filled.md) | [common]<br>abstract fun [assertFilled](assert-filled.md)()<br>Checks if is it is properly filled and throws exception if it is not. It is called when composite is considered &quot;final&quot;. It is often used to verify missing matchers. |
| [capture](capture.md) | [common]<br>abstract override fun [capture](capture.md)(value: [T](index.md))<br>Propagates [value](capture.md) to children matchers. |
| [compose](compose.md) | [common]<br>abstract fun [compose](compose.md)(matcher: [ArgMatcher](../index.md)&lt;[T](index.md)&gt;): [ArgMatcher.Composite](index.md)&lt;[T](index.md)&gt;<br>Returns new [Composite](index.md) with [matcher](compose.md) merged. This method gets matchers in reversed order. |
| [isFilled](is-filled.md) | [common]<br>abstract fun [isFilled](is-filled.md)(): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>Returns true if it is merged with all required matchers and must not be merged anymore. |
| [matches](../matches.md) | [common]<br>abstract fun [matches](../matches.md)(arg: [T](index.md)): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [propagateCapture](../../../dev.mokkery.matcher.capture/propagate-capture.md) | [common]<br>fun &lt;[T](../../../dev.mokkery.matcher.capture/propagate-capture.md)&gt; [ArgMatcher](../index.md)&lt;[T](../../../dev.mokkery.matcher.capture/propagate-capture.md)&gt;.[propagateCapture](../../../dev.mokkery.matcher.capture/propagate-capture.md)(value: [T](../../../dev.mokkery.matcher.capture/propagate-capture.md))<br>Helper function to propagate capture for [dev.mokkery.matcher.ArgMatcher.Composite](index.md). |
