//[mokkery-runtime](../../index.md)/[dev.mokkery.matcher](index.md)

# Package-level declarations

## Types

| Name | Summary |
|---|---|
| [ArgMatcher](-arg-matcher/index.md) | [common]<br>fun interface [ArgMatcher](-arg-matcher/index.md)&lt;in [T](-arg-matcher/index.md)&gt;<br>Checks if given argument satisfies provided conditions. |
| [ArgMatchersScope](-arg-matchers-scope/index.md) | [common]<br>interface [ArgMatchersScope](-arg-matchers-scope/index.md)<br>Scope for registering argument matchers. |

## Functions

| Name | Summary |
|---|---|
| [any](any.md) | [common]<br>inline fun &lt;[T](any.md)&gt; [ArgMatchersScope](-arg-matchers-scope/index.md).[any](any.md)(): [T](any.md)<br>Matches any argument. |
| [eq](eq.md) | [common]<br>inline fun &lt;[T](eq.md)&gt; [ArgMatchersScope](-arg-matchers-scope/index.md).[eq](eq.md)(value: [T](eq.md)): [T](eq.md)<br>Matches an argument that is equal to [value](eq.md). It can be replaced with [value](eq.md) literal. |
| [eqRef](eq-ref.md) | [common]<br>inline fun &lt;[T](eq-ref.md)&gt; [ArgMatchersScope](-arg-matchers-scope/index.md).[eqRef](eq-ref.md)(value: [T](eq-ref.md)): [T](eq-ref.md)<br>Matches an argument whose reference is equal to [value](eq-ref.md)'s reference. |
| [gt](gt.md) | [common]<br>inline fun &lt;[T](gt.md) : [Comparable](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-comparable/index.html)&lt;[T](gt.md)&gt;&gt; [ArgMatchersScope](-arg-matchers-scope/index.md).[gt](gt.md)(value: [T](gt.md)): [T](gt.md)<br>Matches argument that is greater than [value](gt.md). |
| [gte](gte.md) | [common]<br>inline fun &lt;[T](gte.md) : [Comparable](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-comparable/index.html)&lt;[T](gte.md)&gt;&gt; [ArgMatchersScope](-arg-matchers-scope/index.md).[gte](gte.md)(value: [T](gte.md)): [T](gte.md)<br>Matches an argument that is greater than or equal to [value](gte.md). |
| [lt](lt.md) | [common]<br>inline fun &lt;[T](lt.md) : [Comparable](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-comparable/index.html)&lt;[T](lt.md)&gt;&gt; [ArgMatchersScope](-arg-matchers-scope/index.md).[lt](lt.md)(value: [T](lt.md)): [T](lt.md)<br>Matches argument that is less than [value](lt.md). |
| [lte](lte.md) | [common]<br>inline fun &lt;[T](lte.md) : [Comparable](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-comparable/index.html)&lt;[T](lte.md)&gt;&gt; [ArgMatchersScope](-arg-matchers-scope/index.md).[lte](lte.md)(value: [T](lte.md)): [T](lte.md)<br>Matches an argument that is less than or equal to [value](lte.md). |
| [matches](matches.md) | [common]<br>@DelicateMokkeryApi<br>inline fun &lt;[T](matches.md)&gt; [ArgMatchersScope](-arg-matchers-scope/index.md).[matches](matches.md)(matcher: [ArgMatcher](-arg-matcher/index.md)&lt;[T](matches.md)&gt;): [T](matches.md)<br>Registers [matcher](matches.md) with [T](matches.md)::class as argument type. |
| [matching](matching.md) | [common]<br>inline fun &lt;[T](matching.md)&gt; [ArgMatchersScope](-arg-matchers-scope/index.md).[matching](matching.md)(noinline toString: () -&gt; [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) = { &quot;matching(...)&quot; }, noinline predicate: ([T](matching.md)) -&gt; [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)): [T](matching.md)<br>Matches an argument according to the [predicate](matching.md). Registered matcher [Any.toString](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/to-string.html) calls [toString](matching.md). |
| [matchingBy](matching-by.md) | [common]<br>inline fun &lt;[T](matching-by.md)&gt; [ArgMatchersScope](-arg-matchers-scope/index.md).[matchingBy](matching-by.md)(function: ([T](matching-by.md)) -&gt; [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)): [T](matching-by.md)<br>Matches an argument by calling given [function](matching-by.md). Also, it returns function name on [Any.toString](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/to-string.html). |
| [neq](neq.md) | [common]<br>inline fun &lt;[T](neq.md)&gt; [ArgMatchersScope](-arg-matchers-scope/index.md).[neq](neq.md)(value: [T](neq.md)): [T](neq.md)<br>Matches an argument that is not equal to [value](neq.md). |
| [neqRef](neq-ref.md) | [common]<br>inline fun &lt;[T](neq-ref.md)&gt; [ArgMatchersScope](-arg-matchers-scope/index.md).[neqRef](neq-ref.md)(value: [T](neq-ref.md)): [T](neq-ref.md)<br>Matches an argument whose reference is not equal to [value](neq-ref.md)'s reference. |
| [ofType](of-type.md) | [common]<br>inline fun &lt;[T](of-type.md)&gt; [ArgMatchersScope](-arg-matchers-scope/index.md).[ofType](of-type.md)(): [T](of-type.md)<br>Matches an argument that is an instance of type [T](of-type.md). |
