//[mokkery-runtime](../../../index.md)/[dev.mokkery.answering.autofill](../index.md)/[AutofillProvider](index.md)

# AutofillProvider

fun interface [AutofillProvider](index.md)&lt;out [T](index.md)&gt;

Provides a value whenever there is a need to return a *placeholder* of certain type.

The most important [AutofillProvider](index.md) objects are:

- 
   [forInternals](-companion/for-internals.md) - used in internal machinery.
- 
   [forMockMode](-companion/for-mock-mode.md) - used in mock mode. Initially it only fallbacks to [forInternals](-companion/for-internals.md)

Both allows registering custom providers.

#### Inheritors

| |
|---|
| [CompositeAutofillProvider](../-composite-autofill-provider/index.md) |
| [DelegateAutofillProvider](../-delegate-autofill-provider/index.md) |
| [TypeRegistryAutofillProvider](../-type-registry-autofill-provider/index.md) |

## Types

| Name | Summary |
|---|---|
| [Companion](-companion/index.md) | [common]<br>object [Companion](-companion/index.md) |
| [Value](-value/index.md) | [common]<br>sealed interface [Value](-value/index.md)&lt;out [T](-value/index.md)&gt;<br>Result of [AutofillProvider.provide](provide.md) call. |

## Functions

| Name | Summary |
|---|---|
| [provide](provide.md) | [common]<br>abstract fun [provide](provide.md)(type: [KClass](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)&lt;*&gt;): [AutofillProvider.Value](-value/index.md)&lt;[T](index.md)&gt;<br>Returns an instance of [Value.Provided](-value/-provided/index.md), whenever value of [type](provide.md) can be provided. Otherwise, it returns [Value.Absent](-value/-absent/index.md) |
| [provideValue](../provide-value.md) | [common]<br>inline fun &lt;[T](../provide-value.md)&gt; [AutofillProvider](index.md)&lt;[T](../provide-value.md)&gt;.[provideValue](../provide-value.md)(type: [KClass](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.reflect/-k-class/index.html)&lt;*&gt;): [T](../provide-value.md)?<br>Calls [AutofillProvider.provide](provide.md) and returns [AutofillProvider.Value.Provided.value](-value/-provided/value.md) if present. |
