//[mokkery-runtime](../../../index.md)/[dev.mokkery.answering](../index.md)/[CallArgs](index.md)

# CallArgs

[common]\
class [CallArgs](index.md)(val args: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?&gt;)

Contains arguments passed to mocked method. If method has extension receiver it is passed at the start of this list.

It is possible to apply destructuring declaration with convenient cast using generic [component1](component1.md), [component2](component2.md) etc.

```kotlin
ever { dependency.foo(1) } calls { (i: Int) ->  }
```

## Constructors

| | |
|---|---|
| [CallArgs](-call-args.md) | [common]<br>constructor(args: [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?&gt;) |

## Properties

| Name | Summary |
|---|---|
| [args](args.md) | [common]<br>val [args](args.md): [List](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin.collections/-list/index.html)&lt;[Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)?&gt; |

## Functions

| Name | Summary |
|---|---|
| [arg](arg.md) | [common]<br>inline fun &lt;[T](arg.md)&gt; [arg](arg.md)(index: [Int](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-int/index.html)): [T](arg.md)<br>Returns argument with [index](arg.md) from [args](args.md) and expects that it is an instance of type [T](arg.md). |
| [component1](component1.md) | [common]<br>inline operator fun &lt;[T](component1.md)&gt; [component1](component1.md)(): [T](component1.md) |
| [component2](component2.md) | [common]<br>inline operator fun &lt;[T](component2.md)&gt; [component2](component2.md)(): [T](component2.md) |
| [component3](component3.md) | [common]<br>inline operator fun &lt;[T](component3.md)&gt; [component3](component3.md)(): [T](component3.md) |
| [component4](component4.md) | [common]<br>inline operator fun &lt;[T](component4.md)&gt; [component4](component4.md)(): [T](component4.md) |
| [component5](component5.md) | [common]<br>inline operator fun &lt;[T](component5.md)&gt; [component5](component5.md)(): [T](component5.md) |
| [component6](component6.md) | [common]<br>inline operator fun &lt;[T](component6.md)&gt; [component6](component6.md)(): [T](component6.md) |
| [component7](component7.md) | [common]<br>inline operator fun &lt;[T](component7.md)&gt; [component7](component7.md)(): [T](component7.md) |
