//[mokkery-runtime](../../../index.md)/[dev.mokkery.matcher.nullable](../index.md)/[NotNullMatcher](index.md)

# NotNullMatcher

[common]\
@DelicateMokkeryApi

class [NotNullMatcher](index.md)&lt;[T](index.md)&gt;(val matcher: [ArgMatcher](../../dev.mokkery.matcher/-arg-matcher/index.md)&lt;[T](index.md) &amp; [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)&gt;? = null) : [ArgMatcher.Composite](../../dev.mokkery.matcher/-arg-matcher/-composite/index.md)&lt;[T](index.md)&gt; 

Matches an argument that is not null and matches [matcher](matcher.md).

## Constructors

| | |
|---|---|
| [NotNullMatcher](-not-null-matcher.md) | [common]<br>constructor(matcher: [ArgMatcher](../../dev.mokkery.matcher/-arg-matcher/index.md)&lt;[T](index.md) &amp; [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)&gt;? = null) |

## Properties

| Name | Summary |
|---|---|
| [matcher](matcher.md) | [common]<br>val [matcher](matcher.md): [ArgMatcher](../../dev.mokkery.matcher/-arg-matcher/index.md)&lt;[T](index.md) &amp; [Any](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-any/index.html)&gt;? = null |

## Functions

| Name | Summary |
|---|---|
| [assertFilled](assert-filled.md) | [common]<br>open override fun [assertFilled](assert-filled.md)()<br>Checks if is it is properly filled and throws exception if it is not. It is called when composite is considered &quot;final&quot;. It is often used to verify missing matchers. |
| [capture](capture.md) | [common]<br>open override fun [capture](capture.md)(value: [T](index.md))<br>Propagates [value](capture.md) to children matchers. |
| [compose](compose.md) | [common]<br>open override fun [compose](compose.md)(matcher: [ArgMatcher](../../dev.mokkery.matcher/-arg-matcher/index.md)&lt;[T](index.md)&gt;): [ArgMatcher.Composite](../../dev.mokkery.matcher/-arg-matcher/-composite/index.md)&lt;[T](index.md)&gt;<br>Returns new Composite with [matcher](compose.md) merged. This method gets matchers in reversed order. |
| [isFilled](is-filled.md) | [common]<br>open override fun [isFilled](is-filled.md)(): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html)<br>Returns true if it is merged with all required matchers and must not be merged anymore. |
| [matches](matches.md) | [common]<br>open override fun [matches](matches.md)(arg: [T](index.md)): [Boolean](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-boolean/index.html) |
| [propagateCapture](../../dev.mokkery.matcher.capture/propagate-capture.md) | [common]<br>fun &lt;[T](../../dev.mokkery.matcher.capture/propagate-capture.md)&gt; [ArgMatcher](../../dev.mokkery.matcher/-arg-matcher/index.md)&lt;[T](../../dev.mokkery.matcher.capture/propagate-capture.md)&gt;.[propagateCapture](../../dev.mokkery.matcher.capture/propagate-capture.md)(value: [T](../../dev.mokkery.matcher.capture/propagate-capture.md))<br>Helper function to propagate capture for [dev.mokkery.matcher.ArgMatcher.Composite](../../dev.mokkery.matcher/-arg-matcher/-composite/index.md). |
| [toString](to-string.md) | [common]<br>open override fun [toString](to-string.md)(): [String](https://kotlinlang.org/api/latest/jvm/stdlib/kotlin/-string/index.html) |
