/*
 * Decompiled with CFR 0.152.
 */
package dev.mongocamp.server.auth;

import dev.mongocamp.server.auth.AuthHolder;
import dev.mongocamp.server.auth.MongoAuthHolder;
import dev.mongocamp.server.auth.StaticAuthHolder;
import dev.mongocamp.server.auth.TokenCache$;
import dev.mongocamp.server.config.DefaultConfigurations$;
import dev.mongocamp.server.exception.MongoCampException;
import dev.mongocamp.server.exception.MongoCampException$;
import dev.mongocamp.server.model.auth.AuthInputAllMethods;
import dev.mongocamp.server.model.auth.AuthInputBasic;
import dev.mongocamp.server.model.auth.AuthInputBasicWithApiKey;
import dev.mongocamp.server.model.auth.AuthInputBearer;
import dev.mongocamp.server.model.auth.AuthInputBearerWithApiKey;
import dev.mongocamp.server.model.auth.AuthInputBearerWithBasic;
import dev.mongocamp.server.model.auth.AuthInputToken;
import dev.mongocamp.server.model.auth.UserInformation;
import dev.mongocamp.server.service.ConfigurationService$;
import java.io.Serializable;
import scala.Function0;
import sttp.model.StatusCode$;
import sttp.tapir.model.UsernamePassword;

public final class AuthHolder$ {
    public static final AuthHolder$ MODULE$ = new AuthHolder$();
    private static String authHandlerType;
    private static AuthHolder handler;
    private static volatile byte bitmap$0;

    private String authHandlerType$lzycompute() {
        AuthHolder$ authHolder$ = this;
        synchronized (authHolder$) {
            if ((byte)(bitmap$0 & 1) == 0) {
                authHandlerType = (String)ConfigurationService$.MODULE$.getConfigValue(DefaultConfigurations$.MODULE$.ConfigKeyAuthHandler());
                bitmap$0 = (byte)(bitmap$0 | 1);
            }
        }
        return authHandlerType;
    }

    private String authHandlerType() {
        if ((byte)(bitmap$0 & 1) == 0) {
            return this.authHandlerType$lzycompute();
        }
        return authHandlerType;
    }

    public boolean isMongoDbAuthHolder() {
        return this.authHandlerType().equalsIgnoreCase("mongo");
    }

    public boolean isStaticAuthHolder() {
        return this.authHandlerType().equalsIgnoreCase("static");
    }

    private AuthHolder handler$lzycompute() {
        AuthHolder$ authHolder$ = this;
        synchronized (authHolder$) {
            if ((byte)(bitmap$0 & 2) == 0) {
                AuthHolder authHolder;
                String string = this.authHandlerType();
                if (string != null && this.isStaticAuthHolder()) {
                    authHolder = new StaticAuthHolder();
                } else if (string != null && this.isMongoDbAuthHolder()) {
                    MongoAuthHolder mongoHolder = new MongoAuthHolder();
                    mongoHolder.createIndicesAndInitData();
                    authHolder = mongoHolder;
                } else {
                    throw new MongoCampException("Unknown Auth Handler defined", StatusCode$.MODULE$.InternalServerError(), MongoCampException$.MODULE$.apply$default$3(), MongoCampException$.MODULE$.apply$default$4());
                }
                handler = authHolder;
                bitmap$0 = (byte)(bitmap$0 | 2);
            }
        }
        return handler;
    }

    public AuthHolder handler() {
        if ((byte)(bitmap$0 & 2) == 0) {
            return this.handler$lzycompute();
        }
        return handler;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public UserInformation findUserInformationByLoginRequest(Object loginInformation) {
        UserInformation userInformation;
        Object object = loginInformation;
        if (object instanceof AuthInputBearer) {
            UserInformation userInfo;
            AuthInputBearer authInputBearer = (AuthInputBearer)object;
            if (authInputBearer.bearerToken().isEmpty()) {
                throw MongoCampException$.MODULE$.unauthorizedException(MongoCampException$.MODULE$.unauthorizedException$default$1(), MongoCampException$.MODULE$.unauthorizedException$default$2());
            }
            userInformation = userInfo = (UserInformation)TokenCache$.MODULE$.validateToken((String)authInputBearer.bearerToken().get()).getOrElse((Function0 & Serializable)() -> {
                throw MongoCampException$.MODULE$.unauthorizedException(MongoCampException$.MODULE$.unauthorizedException$default$1(), MongoCampException$.MODULE$.unauthorizedException$default$2());
            });
            return userInformation;
        } else if (object instanceof AuthInputBearerWithApiKey) {
            AuthInputBearerWithApiKey authInputBearerWithApiKey = (AuthInputBearerWithApiKey)object;
            if (authInputBearerWithApiKey.bearerToken().isDefined()) {
                UserInformation userInfo;
                userInformation = userInfo = (UserInformation)TokenCache$.MODULE$.validateToken((String)authInputBearerWithApiKey.bearerToken().get()).getOrElse((Function0 & Serializable)() -> {
                    throw MongoCampException$.MODULE$.unauthorizedException(MongoCampException$.MODULE$.unauthorizedException$default$1(), MongoCampException$.MODULE$.unauthorizedException$default$2());
                });
                return userInformation;
            } else {
                if (!authInputBearerWithApiKey.apiKey().isDefined()) throw MongoCampException$.MODULE$.unauthorizedException(MongoCampException$.MODULE$.unauthorizedException$default$1(), MongoCampException$.MODULE$.unauthorizedException$default$2());
                String apiKey = (String)authInputBearerWithApiKey.apiKey().get();
                if (apiKey.trim().isEmpty()) throw MongoCampException$.MODULE$.unauthorizedException(MongoCampException$.MODULE$.unauthorizedException$default$1(), MongoCampException$.MODULE$.unauthorizedException$default$2());
                if (apiKey.trim().isBlank()) {
                    throw MongoCampException$.MODULE$.unauthorizedException(MongoCampException$.MODULE$.unauthorizedException$default$1(), MongoCampException$.MODULE$.unauthorizedException$default$2());
                }
                userInformation = this.handler().findUserByApiKey(apiKey);
            }
            return userInformation;
        } else if (object instanceof AuthInputToken) {
            AuthInputToken authInputToken = (AuthInputToken)object;
            if (!authInputToken.apiKey().isDefined()) throw MongoCampException$.MODULE$.unauthorizedException(MongoCampException$.MODULE$.unauthorizedException$default$1(), MongoCampException$.MODULE$.unauthorizedException$default$2());
            String apiKey = (String)authInputToken.apiKey().get();
            if (apiKey.trim().isEmpty()) throw MongoCampException$.MODULE$.unauthorizedException(MongoCampException$.MODULE$.unauthorizedException$default$1(), MongoCampException$.MODULE$.unauthorizedException$default$2());
            if (apiKey.trim().isBlank()) {
                throw MongoCampException$.MODULE$.unauthorizedException(MongoCampException$.MODULE$.unauthorizedException$default$1(), MongoCampException$.MODULE$.unauthorizedException$default$2());
            }
            userInformation = this.handler().findUserByApiKey(apiKey);
            return userInformation;
        } else if (object instanceof AuthInputBasicWithApiKey) {
            AuthInputBasicWithApiKey authInputBasicWithApiKey = (AuthInputBasicWithApiKey)object;
            if (authInputBasicWithApiKey.basic().isDefined()) {
                userInformation = this.handler().findUser(((UsernamePassword)authInputBasicWithApiKey.basic().get()).username(), this.handler().encryptPassword((String)((UsernamePassword)authInputBasicWithApiKey.basic().get()).password().getOrElse((Function0 & Serializable)() -> "not_set")));
                return userInformation;
            } else {
                if (!authInputBasicWithApiKey.apiKey().isDefined()) throw MongoCampException$.MODULE$.unauthorizedException(MongoCampException$.MODULE$.unauthorizedException$default$1(), MongoCampException$.MODULE$.unauthorizedException$default$2());
                String apiKey = (String)authInputBasicWithApiKey.apiKey().get();
                if (apiKey.trim().isEmpty()) throw MongoCampException$.MODULE$.unauthorizedException(MongoCampException$.MODULE$.unauthorizedException$default$1(), MongoCampException$.MODULE$.unauthorizedException$default$2());
                if (apiKey.trim().isBlank()) {
                    throw MongoCampException$.MODULE$.unauthorizedException(MongoCampException$.MODULE$.unauthorizedException$default$1(), MongoCampException$.MODULE$.unauthorizedException$default$2());
                }
                userInformation = this.handler().findUserByApiKey(apiKey);
            }
            return userInformation;
        } else if (object instanceof AuthInputBasic) {
            AuthInputBasic authInputBasic = (AuthInputBasic)object;
            if (!authInputBasic.basic().isDefined()) throw MongoCampException$.MODULE$.unauthorizedException(MongoCampException$.MODULE$.unauthorizedException$default$1(), MongoCampException$.MODULE$.unauthorizedException$default$2());
            userInformation = this.handler().findUser(((UsernamePassword)authInputBasic.basic().get()).username(), this.handler().encryptPassword((String)((UsernamePassword)authInputBasic.basic().get()).password().getOrElse((Function0 & Serializable)() -> "not_set")));
            return userInformation;
        } else if (object instanceof AuthInputAllMethods) {
            AuthInputAllMethods authInputAllMethods = (AuthInputAllMethods)object;
            if (authInputAllMethods.bearerToken().isDefined()) {
                UserInformation userInfo;
                userInformation = userInfo = (UserInformation)TokenCache$.MODULE$.validateToken((String)authInputAllMethods.bearerToken().get()).getOrElse((Function0 & Serializable)() -> {
                    throw MongoCampException$.MODULE$.unauthorizedException(MongoCampException$.MODULE$.unauthorizedException$default$1(), MongoCampException$.MODULE$.unauthorizedException$default$2());
                });
                return userInformation;
            } else if (authInputAllMethods.basic().isDefined()) {
                userInformation = this.handler().findUser(((UsernamePassword)authInputAllMethods.basic().get()).username(), this.handler().encryptPassword((String)((UsernamePassword)authInputAllMethods.basic().get()).password().getOrElse((Function0 & Serializable)() -> "not_set")));
                return userInformation;
            } else {
                if (!authInputAllMethods.apiKey().isDefined()) throw MongoCampException$.MODULE$.unauthorizedException(MongoCampException$.MODULE$.unauthorizedException$default$1(), MongoCampException$.MODULE$.unauthorizedException$default$2());
                String apiKey = (String)authInputAllMethods.apiKey().get();
                if (apiKey.trim().isEmpty()) throw MongoCampException$.MODULE$.unauthorizedException(MongoCampException$.MODULE$.unauthorizedException$default$1(), MongoCampException$.MODULE$.unauthorizedException$default$2());
                if (apiKey.trim().isBlank()) {
                    throw MongoCampException$.MODULE$.unauthorizedException(MongoCampException$.MODULE$.unauthorizedException$default$1(), MongoCampException$.MODULE$.unauthorizedException$default$2());
                }
                userInformation = this.handler().findUserByApiKey(apiKey);
            }
            return userInformation;
        } else {
            if (!(object instanceof AuthInputBearerWithBasic)) throw MongoCampException$.MODULE$.badAuthConfiguration();
            AuthInputBearerWithBasic authInputBearerWithBasic = (AuthInputBearerWithBasic)object;
            if (authInputBearerWithBasic.bearerToken().isDefined()) {
                UserInformation userInfo;
                userInformation = userInfo = (UserInformation)TokenCache$.MODULE$.validateToken((String)authInputBearerWithBasic.bearerToken().get()).getOrElse((Function0 & Serializable)() -> {
                    throw MongoCampException$.MODULE$.unauthorizedException(MongoCampException$.MODULE$.unauthorizedException$default$1(), MongoCampException$.MODULE$.unauthorizedException$default$2());
                });
                return userInformation;
            } else {
                if (!authInputBearerWithBasic.basic().isDefined()) throw MongoCampException$.MODULE$.unauthorizedException(MongoCampException$.MODULE$.unauthorizedException$default$1(), MongoCampException$.MODULE$.unauthorizedException$default$2());
                userInformation = this.handler().findUser(((UsernamePassword)authInputBearerWithBasic.basic().get()).username(), this.handler().encryptPassword((String)((UsernamePassword)authInputBearerWithBasic.basic().get()).password().getOrElse((Function0 & Serializable)() -> "not_set")));
            }
        }
        return userInformation;
    }

    private AuthHolder$() {
    }
}

