/*
 * Decompiled with CFR 0.152.
 */
package dev.mongocamp.server.auth;

import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;
import dev.mongocamp.driver.mongodb.operation.ObservableIncludes;
import dev.mongocamp.driver.mongodb.package$;
import dev.mongocamp.server.auth.AuthHolder;
import dev.mongocamp.server.config.DefaultConfigurations$;
import dev.mongocamp.server.database.MongoDaoHolder$;
import dev.mongocamp.server.database.paging.MongoPaginatedFilter;
import dev.mongocamp.server.database.paging.MongoPaginatedFilter$;
import dev.mongocamp.server.database.paging.PaginationInfo;
import dev.mongocamp.server.database.paging.PaginationResult;
import dev.mongocamp.server.exception.MongoCampException;
import dev.mongocamp.server.exception.MongoCampException$;
import dev.mongocamp.server.model.ModelConstants$;
import dev.mongocamp.server.model.auth.AuthorizedCollectionRequest$;
import dev.mongocamp.server.model.auth.Grant;
import dev.mongocamp.server.model.auth.LoginResult;
import dev.mongocamp.server.model.auth.Role;
import dev.mongocamp.server.model.auth.UpdateRoleRequest;
import dev.mongocamp.server.model.auth.UserInformation;
import dev.mongocamp.server.model.auth.UserProfile;
import dev.mongocamp.server.route.parameter.paging.Paging;
import dev.mongocamp.server.route.parameter.paging.PagingFunctions$;
import dev.mongocamp.server.service.ConfigurationService$;
import java.io.Serializable;
import org.bson.conversions.Bson;
import org.joda.time.DateTime;
import org.mongodb.scala.Observable;
import org.mongodb.scala.model.Filters$;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Random$;
import sttp.model.StatusCode$;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0015e\u0001B\u000e\u001d\u0001\u0015BQ\u0001\r\u0001\u0005\u0002EBqa\r\u0001C\u0002\u0013%A\u0007\u0003\u0004>\u0001\u0001\u0006I!\u000e\u0005\b}\u0001\u0011\r\u0011\"\u00035\u0011\u0019y\u0004\u0001)A\u0005k!9\u0001\t\u0001b\u0001\n\u0013!\u0004BB!\u0001A\u0003%Q\u0007C\u0004C\u0001\t\u0007I\u0011\u0002\u001b\t\r\r\u0003\u0001\u0015!\u00036\u0011\u001d!\u0005A1A\u0005\nQBa!\u0012\u0001!\u0002\u0013)\u0004\"\u0002$\u0001\t\u00039\u0005\"B&\u0001\t\u0003b\u0005\"B2\u0001\t\u0003\"\u0007\"\u00025\u0001\t\u0003J\u0007\"B=\u0001\t\u0003Q\b\"B?\u0001\t\u0003q\bbBA\u0002\u0001\u0011\u0005\u0011Q\u0001\u0005\b\u0003\u0013\u0001A\u0011AA\u0006\u0011\u001d\t\u0019\u0002\u0001C\u0001\u0003+Aq!!\u0007\u0001\t\u0003\nY\u0002C\u0004\u0002\"\u0001!\t%a\t\t\u000f\u0005e\u0003\u0001\"\u0011\u0002\\!9\u0011Q\r\u0001\u0005\u0002\u0005\u001d\u0004bBA7\u0001\u0011\u0005\u0011q\u000e\u0005\b\u0003\u007f\u0002A\u0011AAA\u0005=iuN\\4p\u0003V$\b\u000eS8mI\u0016\u0014(BA\u000f\u001f\u0003\u0011\tW\u000f\u001e5\u000b\u0005}\u0001\u0013AB:feZ,'O\u0003\u0002\"E\u0005IQn\u001c8h_\u000e\fW\u000e\u001d\u0006\u0002G\u0005\u0019A-\u001a<\u0004\u0001M\u0019\u0001A\n\u0017\u0011\u0005\u001dRS\"\u0001\u0015\u000b\u0003%\nQa]2bY\u0006L!a\u000b\u0015\u0003\r\u0005s\u0017PU3g!\tic&D\u0001\u001d\u0013\tyCD\u0001\u0006BkRD\u0007j\u001c7eKJ\fa\u0001P5oSRtD#\u0001\u001a\u0011\u00055\u0002\u0011!C&fsV\u001bXM]%e+\u0005)\u0004C\u0001\u001c<\u001b\u00059$B\u0001\u001d:\u0003\u0011a\u0017M\\4\u000b\u0003i\nAA[1wC&\u0011Ah\u000e\u0002\u0007'R\u0014\u0018N\\4\u0002\u0015-+\u00170V:fe&#\u0007%A\u0005LKf\f\u0005/[&fs\u0006Q1*Z=Ba&\\U-\u001f\u0011\u0002\u0017-+\u0017\u0010U1tg^|'\u000fZ\u0001\r\u0017\u0016L\b+Y:to>\u0014H\rI\u0001\t\u0017\u0016L(k\u001c7fg\u0006I1*Z=S_2,7\u000fI\u0001\b\u0017\u0016Lh*Y7f\u0003!YU-\u001f(b[\u0016\u0004\u0013\u0001G2sK\u0006$X-\u00138eS\u000e,7/\u00118e\u0013:LG\u000fR1uCR\t\u0001\n\u0005\u0002(\u0013&\u0011!\n\u000b\u0002\b\u0005>|G.Z1o\u000391\u0017N\u001c3Vg\u0016\u0014x\n\u001d;j_:$\"!T,\u0011\u0007\u001dr\u0005+\u0003\u0002PQ\t1q\n\u001d;j_:\u0004\"!U+\u000e\u0003IS!!H*\u000b\u0005Qs\u0012!B7pI\u0016d\u0017B\u0001,S\u0005=)6/\u001a:J]\u001a|'/\\1uS>t\u0007\"\u0002-\u000e\u0001\u0004I\u0016AB;tKJLE\r\u0005\u0002[C:\u00111l\u0018\t\u00039\"j\u0011!\u0018\u0006\u0003=\u0012\na\u0001\u0010:p_Rt\u0014B\u00011)\u0003\u0019\u0001&/\u001a3fM&\u0011AH\u0019\u0006\u0003A\"\n\u0001BZ5oIV\u001bXM\u001d\u000b\u0004!\u00164\u0007\"\u0002-\u000f\u0001\u0004I\u0006\"B4\u000f\u0001\u0004I\u0016\u0001\u00039bgN<xN\u001d3\u0002\u0013\u0019Lg\u000e\u001a*pY\u0016\u001cHC\u00016w!\rY\u0007o\u001d\b\u0003Y:t!\u0001X7\n\u0003%J!a\u001c\u0015\u0002\u000fA\f7m[1hK&\u0011\u0011O\u001d\u0002\u0005\u0019&\u001cHO\u0003\u0002pQA\u0011\u0011\u000b^\u0005\u0003kJ\u0013AAU8mK\")qo\u0004a\u0001q\u0006)!o\u001c7fgB\u00191\u000e]-\u0002\u000f\u0005$G-V:feR\u0011\u0001k\u001f\u0005\u0006yB\u0001\r\u0001U\u0001\u0010kN,'/\u00138g_Jl\u0017\r^5p]\u0006\u0001R\u000f\u001d3bi\u0016,6/\u001a:t%>dWm\u001d\u000b\u0005!~\f\t\u0001C\u0003Y#\u0001\u0007\u0011\fC\u0003x#\u0001\u0007\u00010\u0001\u0006eK2,G/Z+tKJ$2\u0001SA\u0004\u0011\u0015A&\u00031\u0001Z\u0003U)\b\u000fZ1uKB\u000b7o]<pe\u00124uN]+tKJ$R\u0001SA\u0007\u0003\u001fAQ\u0001W\nA\u0002eCa!!\u0005\u0014\u0001\u0004I\u0016a\u00038foB\u000b7o]<pe\u0012\f\u0001#\u001e9eCR,\u0017\t]5LKf,6/\u001a:\u0015\u0007e\u000b9\u0002C\u0003Y)\u0001\u0007\u0011,\u0001\fgS:$Wk]3s\u0005f\f\u0005/[&fs>\u0003H/[8o)\ri\u0015Q\u0004\u0005\u0007\u0003?)\u0002\u0019A-\u0002\r\u0005\u0004\u0018nS3z\u0003!\tG\u000e\\+tKJ\u001cHCBA\u0013\u0003{\t\u0019\u0005E\u0004(\u0003O\tY#!\f\n\u0007\u0005%\u0002F\u0001\u0004UkBdWM\r\t\u0004WB\u0004\u0006\u0003BA\u0018\u0003si!!!\r\u000b\t\u0005M\u0012QG\u0001\u0007a\u0006<\u0017N\\4\u000b\u0007\u0005]b$\u0001\u0005eCR\f'-Y:f\u0013\u0011\tY$!\r\u0003\u001dA\u000bw-\u001b8bi&|g.\u00138g_\"9\u0011q\b\fA\u0002\u0005\u0005\u0013\u0001D;tKJ$vnU3be\u000eD\u0007cA\u0014O3\"9\u0011Q\t\fA\u0002\u0005\u001d\u0013A\u00039bO&tw-\u00138g_B!\u0011\u0011JA+\u001b\t\tYE\u0003\u0003\u00024\u00055#\u0002BA(\u0003#\n\u0011\u0002]1sC6,G/\u001a:\u000b\u0007\u0005Mc$A\u0003s_V$X-\u0003\u0003\u0002X\u0005-#A\u0002)bO&tw-\u0001\u0005bY2\u0014v\u000e\\3t)\u0019\ti&a\u0018\u0002dA1q%a\nk\u0003[Aq!!\u0019\u0018\u0001\u0004\t\t%\u0001\u0007s_2,Gk\\*fCJ\u001c\u0007\u000eC\u0004\u0002F]\u0001\r!a\u0012\u0002\u000f\u0005$GMU8mKR\u00191/!\u001b\t\r\u0005-\u0004\u00041\u0001t\u0003\u0011\u0011x\u000e\\3\u0002\u0015U\u0004H-\u0019;f%>dW\rF\u0003t\u0003c\n)\b\u0003\u0004\u0002te\u0001\r!W\u0001\be>dWmS3z\u0011\u001d\t9(\u0007a\u0001\u0003s\n!B]8mKV\u0003H-\u0019;f!\r\t\u00161P\u0005\u0004\u0003{\u0012&!E+qI\u0006$XMU8mKJ+\u0017/^3ti\u0006QA-\u001a7fi\u0016\u0014v\u000e\\3\u0015\u0007!\u000b\u0019\t\u0003\u0004\u0002li\u0001\r!\u0017")
public class MongoAuthHolder
implements AuthHolder {
    private final String KeyUserId;
    private final String KeyApiKey;
    private final String KeyPassword;
    private final String KeyRoles;
    private final String KeyName;

    @Override
    public UserInformation findUserByApiKey(String apiKey) {
        return AuthHolder.findUserByApiKey$(this, apiKey);
    }

    @Override
    public UserInformation findUser(String userId) {
        return AuthHolder.findUser$(this, userId);
    }

    @Override
    public Option<Role> findRole(String roles) {
        return AuthHolder.findRole$(this, roles);
    }

    @Override
    public List<Role> findRoles(UserInformation userInformation) {
        return AuthHolder.findRoles$(this, userInformation);
    }

    @Override
    public String encryptPassword(String password) {
        return AuthHolder.encryptPassword$(this, password);
    }

    @Override
    public String encodeToken(UserProfile userProfile, DateTime expirationDate) {
        return AuthHolder.encodeToken$(this, userProfile, expirationDate);
    }

    @Override
    public LoginResult generateLoginResult(UserInformation user) {
        return AuthHolder.generateLoginResult$(this, user);
    }

    private String KeyUserId() {
        return this.KeyUserId;
    }

    private String KeyApiKey() {
        return this.KeyApiKey;
    }

    private String KeyPassword() {
        return this.KeyPassword;
    }

    private String KeyRoles() {
        return this.KeyRoles;
    }

    private String KeyName() {
        return this.KeyName;
    }

    public boolean createIndicesAndInitData() {
        boolean bl;
        try {
            String newPassword = Random$.MODULE$.alphanumeric().take(10).mkString();
            ObservableIncludes.GenericObservable qual$1 = package$.MODULE$.GenericObservable(MongoDaoHolder$.MODULE$.userDao().count(MongoDaoHolder$.MODULE$.userDao().count$default$1(), MongoDaoHolder$.MODULE$.userDao().count$default$2()));
            int x$1 = qual$1.result$default$1();
            if (BoxesRunTime.unboxToLong((Object)qual$1.result(x$1)) == 0L) {
                String generatedUserId = "admin";
                String roleName = "adminRole";
                ObservableIncludes.GenericObservable qual$2 = package$.MODULE$.GenericObservable(MongoDaoHolder$.MODULE$.userDao().insertOne(new UserInformation(generatedUserId, this.encryptPassword(newPassword), (Option<String>)None$.MODULE$, (List<String>)new .colon.colon((Object)roleName, (List)Nil$.MODULE$))));
                int x$2 = qual$2.result$default$1();
                qual$2.result(x$2);
                ObservableIncludes.GenericObservable qual$3 = package$.MODULE$.GenericObservable((Observable)MongoDaoHolder$.MODULE$.userDao().createUniqueIndexForField(this.KeyUserId(), MongoDaoHolder$.MODULE$.userDao().createUniqueIndexForField$default$2(), MongoDaoHolder$.MODULE$.userDao().createUniqueIndexForField$default$3()));
                int x$3 = qual$3.result$default$1();
                qual$3.result(x$3);
                ObservableIncludes.GenericObservable qual$4 = package$.MODULE$.GenericObservable(MongoDaoHolder$.MODULE$.rolesDao().insertOne(new Role(roleName, true, (List<Grant>)new .colon.colon((Object)new Grant(AuthorizedCollectionRequest$.MODULE$.all(), true, true, true, ModelConstants$.MODULE$.grantTypeCollection()), (List)new .colon.colon((Object)new Grant(AuthorizedCollectionRequest$.MODULE$.all(), true, true, true, ModelConstants$.MODULE$.grantTypeBucket()), (List)Nil$.MODULE$)))));
                int x$4 = qual$4.result$default$1();
                qual$4.result(x$4);
                ObservableIncludes.GenericObservable qual$5 = package$.MODULE$.GenericObservable((Observable)MongoDaoHolder$.MODULE$.rolesDao().createUniqueIndexForField(this.KeyName(), MongoDaoHolder$.MODULE$.rolesDao().createUniqueIndexForField$default$2(), MongoDaoHolder$.MODULE$.rolesDao().createUniqueIndexForField$default$3()));
                int x$5 = qual$5.result$default$1();
                qual$5.result(x$5);
                Predef$.MODULE$.println((Object)"****************************************");
                Predef$.MODULE$.println((Object)new StringBuilder(8).append("* user: ").append(generatedUserId).toString());
                Predef$.MODULE$.println((Object)new StringBuilder(12).append("* Password: ").append(newPassword).toString());
                Predef$.MODULE$.println((Object)"****************************************");
            }
            bl = true;
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    @Override
    public Option<UserInformation> findUserOption(String userId) {
        ObservableIncludes.GenericObservable qual$1 = package$.MODULE$.GenericObservable((Observable)MongoDaoHolder$.MODULE$.userDao().find(this.KeyUserId(), userId));
        int x$1 = qual$1.resultOption$default$1();
        return qual$1.resultOption(x$1);
    }

    @Override
    public UserInformation findUser(String userId, String password) {
        ObservableIncludes.GenericObservable qual$1 = package$.MODULE$.GenericObservable((Observable)MongoDaoHolder$.MODULE$.userDao().find((Bson)package$.MODULE$.documentFromScalaMap((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.KeyUserId()), (Object)userId), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.KeyPassword()), (Object)password)}))), MongoDaoHolder$.MODULE$.userDao().find$default$2(), MongoDaoHolder$.MODULE$.userDao().find$default$3(), MongoDaoHolder$.MODULE$.userDao().find$default$4()));
        int x$1 = qual$1.resultOption$default$1();
        return (UserInformation)qual$1.resultOption(x$1).getOrElse((Function0 & Serializable)() -> {
            throw MongoCampException$.MODULE$.userOrPasswordException();
        });
    }

    @Override
    public List<Role> findRoles(List<String> roles) {
        Map searchMap = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.KeyName()), Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"$in"), roles)})))}));
        ObservableIncludes.GenericObservable qual$1 = package$.MODULE$.GenericObservable((Observable)MongoDaoHolder$.MODULE$.rolesDao().find((Bson)package$.MODULE$.documentFromScalaMap(searchMap), MongoDaoHolder$.MODULE$.rolesDao().find$default$2(), MongoDaoHolder$.MODULE$.rolesDao().find$default$3(), MongoDaoHolder$.MODULE$.rolesDao().find$default$4()));
        int x$1 = qual$1.resultList$default$1();
        return qual$1.resultList(x$1);
    }

    public UserInformation addUser(UserInformation userInformation) {
        if (this.findUserOption(userInformation.userId()).isDefined()) {
            throw new MongoCampException("User already exists.", StatusCode$.MODULE$.BadRequest(), MongoCampException$.MODULE$.apply$default$3(), MongoCampException$.MODULE$.apply$default$4());
        }
        String x$1 = this.encryptPassword(userInformation.password());
        String x$2 = userInformation.copy$default$1();
        Option<String> x$3 = userInformation.copy$default$3();
        List<String> x$4 = userInformation.copy$default$4();
        UserInformation userToAdd = userInformation.copy(x$2, x$1, x$3, x$4);
        ObservableIncludes.GenericObservable qual$1 = package$.MODULE$.GenericObservable(MongoDaoHolder$.MODULE$.userDao().insertOne(userToAdd));
        int x$5 = qual$1.result$default$1();
        qual$1.result(x$5);
        return this.findUser(userToAdd.userId(), userToAdd.password());
    }

    public UserInformation updateUsersRoles(String userId, List<String> roles) {
        UserInformation userInformation = this.findUser(userId);
        List<String> x$1 = roles;
        String x$2 = userInformation.copy$default$1();
        String x$3 = userInformation.copy$default$2();
        Option<String> x$4 = userInformation.copy$default$3();
        ObservableIncludes.GenericObservable qual$1 = package$.MODULE$.GenericObservable(MongoDaoHolder$.MODULE$.userDao().replaceOne((Bson)package$.MODULE$.documentFromScalaMap((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.KeyUserId()), (Object)userId)}))), userInformation.copy(x$2, x$3, x$4, x$1)));
        int x$5 = qual$1.result$default$1();
        qual$1.result(x$5);
        return this.findUser(userId);
    }

    public boolean deleteUser(String userId) {
        int x$1;
        ObservableIncludes.GenericObservable qual$1 = package$.MODULE$.GenericObservable(MongoDaoHolder$.MODULE$.userDao().deleteOne((Bson)package$.MODULE$.documentFromScalaMap((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.KeyUserId()), (Object)userId)})))));
        DeleteResult insertResult = (DeleteResult)qual$1.result(x$1 = qual$1.result$default$1());
        return insertResult.wasAcknowledged() && insertResult.getDeletedCount() == 1L;
    }

    public boolean updatePasswordForUser(String userId, String newPassword) {
        int x$5;
        UserInformation userInformation = this.findUser(userId);
        String x$1 = this.encryptPassword(newPassword);
        String x$2 = userInformation.copy$default$1();
        Option<String> x$3 = userInformation.copy$default$3();
        List<String> x$4 = userInformation.copy$default$4();
        ObservableIncludes.GenericObservable qual$1 = package$.MODULE$.GenericObservable(MongoDaoHolder$.MODULE$.userDao().replaceOne((Bson)package$.MODULE$.documentFromScalaMap((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.KeyUserId()), (Object)userId)}))), userInformation.copy(x$2, x$1, x$3, x$4)));
        UpdateResult updateResult = (UpdateResult)qual$1.result(x$5 = qual$1.result$default$1());
        return updateResult.wasAcknowledged() && updateResult.getModifiedCount() == 1L;
    }

    public String updateApiKeyUser(String userId) {
        int x$5;
        UserInformation userInformation = this.findUser(userId);
        String apiKey = Random$.MODULE$.alphanumeric().take((int)BoxesRunTime.unboxToLong(ConfigurationService$.MODULE$.getConfigValue(DefaultConfigurations$.MODULE$.ConfigKeyAuthApiKeyLength()))).mkString();
        Some x$1 = new Some((Object)apiKey);
        String x$2 = userInformation.copy$default$1();
        String x$3 = userInformation.copy$default$2();
        List<String> x$4 = userInformation.copy$default$4();
        ObservableIncludes.GenericObservable qual$1 = package$.MODULE$.GenericObservable(MongoDaoHolder$.MODULE$.userDao().replaceOne((Bson)package$.MODULE$.documentFromScalaMap((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.KeyUserId()), (Object)userId)}))), userInformation.copy(x$2, x$3, (Option<String>)x$1, x$4)));
        UpdateResult updateResult = (UpdateResult)qual$1.result(x$5 = qual$1.result$default$1());
        if (updateResult.wasAcknowledged() && updateResult.getModifiedCount() == 1L) {
            return apiKey;
        }
        throw new MongoCampException("could not update apikey for user", StatusCode$.MODULE$.BadRequest(), MongoCampException$.MODULE$.apply$default$3(), MongoCampException$.MODULE$.apply$default$4());
    }

    @Override
    public Option<UserInformation> findUserByApiKeyOption(String apiKey) {
        if (apiKey == null) {
            throw MongoCampException$.MODULE$.apiKeyException();
        }
        Map searchMap = (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.KeyApiKey()), (Object)apiKey)}));
        ObservableIncludes.GenericObservable qual$1 = package$.MODULE$.GenericObservable((Observable)MongoDaoHolder$.MODULE$.userDao().find((Bson)package$.MODULE$.documentFromScalaMap(searchMap), MongoDaoHolder$.MODULE$.userDao().find$default$2(), MongoDaoHolder$.MODULE$.userDao().find$default$3(), MongoDaoHolder$.MODULE$.userDao().find$default$4()));
        int x$1 = qual$1.resultOption$default$1();
        return qual$1.resultOption(x$1);
    }

    @Override
    public Tuple2<List<UserInformation>, PaginationInfo> allUsers(Option<String> userToSearch, Paging pagingInfo) {
        long rowsPerPage = BoxesRunTime.unboxToLong((Object)pagingInfo.rowsPerPage().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> PagingFunctions$.MODULE$.DefaultRowsPerPage()));
        long page = BoxesRunTime.unboxToLong((Object)pagingInfo.page().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 1L));
        if (userToSearch.isEmpty()) {
            PaginationResult<UserInformation> databasePage = new MongoPaginatedFilter<UserInformation>(MongoDaoHolder$.MODULE$.userDao(), MongoPaginatedFilter$.MODULE$.apply$default$2(), MongoPaginatedFilter$.MODULE$.apply$default$3(), MongoPaginatedFilter$.MODULE$.apply$default$4()).paginate(rowsPerPage, page);
            return new Tuple2(databasePage.databaseObjects(), (Object)databasePage.paginationInfo());
        }
        Bson filter = Filters$.MODULE$.regex(this.KeyUserId(), new StringBuilder(10).append("(.*?)").append(userToSearch.get()).append("(.*?)").toString(), "i");
        PaginationResult<UserInformation> databasePage = new MongoPaginatedFilter<UserInformation>(MongoDaoHolder$.MODULE$.userDao(), filter, MongoPaginatedFilter$.MODULE$.apply$default$3(), MongoPaginatedFilter$.MODULE$.apply$default$4()).paginate(rowsPerPage, page);
        return new Tuple2(databasePage.databaseObjects(), (Object)databasePage.paginationInfo());
    }

    @Override
    public Tuple2<List<Role>, PaginationInfo> allRoles(Option<String> roleToSearch, Paging pagingInfo) {
        long rowsPerPage = BoxesRunTime.unboxToLong((Object)pagingInfo.rowsPerPage().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> PagingFunctions$.MODULE$.DefaultRowsPerPage()));
        long page = BoxesRunTime.unboxToLong((Object)pagingInfo.page().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 1L));
        if (roleToSearch.isEmpty()) {
            PaginationResult<Role> databasePage = new MongoPaginatedFilter<Role>(MongoDaoHolder$.MODULE$.rolesDao(), MongoPaginatedFilter$.MODULE$.apply$default$2(), MongoPaginatedFilter$.MODULE$.apply$default$3(), MongoPaginatedFilter$.MODULE$.apply$default$4()).paginate(rowsPerPage, page);
            return new Tuple2(databasePage.databaseObjects(), (Object)databasePage.paginationInfo());
        }
        Bson filter = Filters$.MODULE$.regex(this.KeyName(), new StringBuilder(10).append("(.*?)").append(roleToSearch.get()).append("(.*?)").toString(), "i");
        PaginationResult<Role> databasePage = new MongoPaginatedFilter<Role>(MongoDaoHolder$.MODULE$.rolesDao(), filter, MongoPaginatedFilter$.MODULE$.apply$default$3(), MongoPaginatedFilter$.MODULE$.apply$default$4()).paginate(rowsPerPage, page);
        return new Tuple2(databasePage.databaseObjects(), (Object)databasePage.paginationInfo());
    }

    public Role addRole(Role role) {
        if (this.findRole(role.name()).isDefined()) {
            throw new MongoCampException("UserRole already exists.", StatusCode$.MODULE$.BadRequest(), MongoCampException$.MODULE$.apply$default$3(), MongoCampException$.MODULE$.apply$default$4());
        }
        ObservableIncludes.GenericObservable qual$1 = package$.MODULE$.GenericObservable(MongoDaoHolder$.MODULE$.rolesDao().insertOne(role));
        int x$1 = qual$1.result$default$1();
        qual$1.result(x$1);
        return (Role)this.findRole(role.name()).getOrElse((Function0 & Serializable)() -> {
            throw new MongoCampException("could not create UserRole", StatusCode$.MODULE$.BadRequest(), MongoCampException$.MODULE$.apply$default$3(), MongoCampException$.MODULE$.apply$default$4());
        });
    }

    public Role updateRole(String roleKey, UpdateRoleRequest roleUpdate) {
        Option<Role> role = this.findRole(roleKey);
        if (role.isEmpty()) {
            throw new MongoCampException("UserRole not exists.", StatusCode$.MODULE$.NotFound(), MongoCampException$.MODULE$.apply$default$3(), MongoCampException$.MODULE$.apply$default$4());
        }
        Role qual$1 = (Role)role.get();
        boolean x$1 = roleUpdate.isAdmin();
        List<Grant> x$2 = roleUpdate.collectionGrants();
        String x$3 = qual$1.copy$default$1();
        Role updated = qual$1.copy(x$3, x$1, x$2);
        ObservableIncludes.GenericObservable qual$2 = package$.MODULE$.GenericObservable(MongoDaoHolder$.MODULE$.rolesDao().replaceOne((Bson)package$.MODULE$.documentFromScalaMap((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.KeyName()), (Object)roleKey)}))), updated));
        int x$4 = qual$2.result$default$1();
        qual$2.result(x$4);
        return (Role)this.findRole(roleKey).getOrElse((Function0 & Serializable)() -> {
            throw new MongoCampException("could not create UserRole", StatusCode$.MODULE$.BadRequest(), MongoCampException$.MODULE$.apply$default$3(), MongoCampException$.MODULE$.apply$default$4());
        });
    }

    public boolean deleteRole(String role) {
        int x$1;
        ObservableIncludes.GenericObservable qual$1 = package$.MODULE$.GenericObservable(MongoDaoHolder$.MODULE$.rolesDao().deleteOne((Bson)package$.MODULE$.documentFromScalaMap((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.KeyName()), (Object)role)})))));
        DeleteResult deleteResult = (DeleteResult)qual$1.result(x$1 = qual$1.result$default$1());
        return deleteResult.wasAcknowledged() && deleteResult.getDeletedCount() == 1L;
    }

    public MongoAuthHolder() {
        AuthHolder.$init$(this);
        this.KeyUserId = "userId";
        this.KeyApiKey = "apiKey";
        this.KeyPassword = "password";
        this.KeyRoles = "roles";
        this.KeyName = "name";
    }
}

