/*
 * Decompiled with CFR 0.152.
 */
package dev.mongocamp.server.auth;

import com.github.blemale.scaffeine.Cache;
import com.github.blemale.scaffeine.Scaffeine$;
import dev.mongocamp.driver.mongodb.operation.ObservableIncludes;
import dev.mongocamp.server.auth.AuthHolder$;
import dev.mongocamp.server.config.DefaultConfigurations$;
import dev.mongocamp.server.database.MongoDaoHolder$;
import dev.mongocamp.server.jobs.CleanUpTokenJob;
import dev.mongocamp.server.model.JobConfig;
import dev.mongocamp.server.model.auth.TokenCacheElement;
import dev.mongocamp.server.model.auth.UserInformation;
import dev.mongocamp.server.plugin.JobPlugin$;
import dev.mongocamp.server.service.ConfigurationService$;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import org.bson.conversions.Bson;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.mongodb.scala.Observable;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;
import scala.concurrent.duration.FiniteDuration$;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Try$;

public final class TokenCache$ {
    public static final TokenCache$ MODULE$;
    private static Cache<String, UserInformation> internalTokenCache;
    private static final String keyToken;
    private static final String keyValidTo;
    private static volatile boolean bitmap$0;

    static {
        Object object;
        MODULE$ = new TokenCache$();
        keyToken = "token";
        keyValidTo = "validTo";
        Try$.MODULE$.apply((Function0)(JFunction0.mcZ.sp & Serializable)() -> {
            Class<CleanUpTokenJob> cleanUpJobClass = CleanUpTokenJob.class;
            return JobPlugin$.MODULE$.addJob(new JobConfig(cleanUpJobClass.getSimpleName(), cleanUpJobClass.getName(), "", "0 0/5 * ? * * *", "CleanUp", 10), JobPlugin$.MODULE$.addJob$default$2());
        });
        if (MODULE$.authTokenCacheDB()) {
            ObservableIncludes.GenericObservable qual$1 = dev.mongocamp.driver.mongodb.package$.MODULE$.GenericObservable((Observable)MongoDaoHolder$.MODULE$.tokenCacheDao().createUniqueIndexForField(MODULE$.keyToken(), MongoDaoHolder$.MODULE$.tokenCacheDao().createUniqueIndexForField$default$2(), MongoDaoHolder$.MODULE$.tokenCacheDao().createUniqueIndexForField$default$3()));
            int x$1 = qual$1.result$default$1();
            qual$1.result(x$1);
            ObservableIncludes.GenericObservable qual$2 = dev.mongocamp.driver.mongodb.package$.MODULE$.GenericObservable((Observable)MongoDaoHolder$.MODULE$.tokenCacheDao().createExpiringIndexForField(MODULE$.keyValidTo(), (Duration)new package.DurationInt(package$.MODULE$.DurationInt(1)).seconds(), MongoDaoHolder$.MODULE$.tokenCacheDao().createExpiringIndexForField$default$3(), MongoDaoHolder$.MODULE$.tokenCacheDao().createExpiringIndexForField$default$4()));
            int x$2 = qual$2.result$default$1();
            object = qual$2.result(x$2);
        } else {
            object = BoxedUnit.UNIT;
        }
    }

    public String keyToken() {
        return keyToken;
    }

    public String keyValidTo() {
        return keyValidTo;
    }

    private Cache<String, UserInformation> internalTokenCache$lzycompute() {
        TokenCache$ tokenCache$ = this;
        synchronized (tokenCache$) {
            if (!bitmap$0) {
                internalTokenCache = Scaffeine$.MODULE$.apply().recordStats().expireAfterWrite(this.cacheDuration()).build();
                bitmap$0 = true;
            }
        }
        return internalTokenCache;
    }

    private Cache<String, UserInformation> internalTokenCache() {
        if (!bitmap$0) {
            return this.internalTokenCache$lzycompute();
        }
        return internalTokenCache;
    }

    private boolean authTokenCacheDB() {
        return BoxesRunTime.unboxToBoolean(ConfigurationService$.MODULE$.getConfigValue(DefaultConfigurations$.MODULE$.ConfigKeyAuthCacheDb()));
    }

    public FiniteDuration cacheDuration() {
        if (this.authTokenCacheDB()) {
            return FiniteDuration$.MODULE$.apply(5L, TimeUnit.MINUTES);
        }
        Duration duration = (Duration)ConfigurationService$.MODULE$.getConfigValue(DefaultConfigurations$.MODULE$.ConfigKeyAuthExpiringDuration());
        return FiniteDuration$.MODULE$.apply(duration.toNanos(), TimeUnit.NANOSECONDS);
    }

    public Option<UserInformation> validateToken(String token) {
        Option cachedToken = this.internalTokenCache().getIfPresent((Object)token);
        if (cachedToken.isEmpty() && this.authTokenCacheDB()) {
            int x$1;
            ObservableIncludes.GenericObservable qual$1 = dev.mongocamp.driver.mongodb.package$.MODULE$.GenericObservable((Observable)MongoDaoHolder$.MODULE$.tokenCacheDao().find((Bson)dev.mongocamp.driver.mongodb.package$.MODULE$.documentFromScalaMap((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.keyToken()), (Object)token)}))), MongoDaoHolder$.MODULE$.tokenCacheDao().find$default$2(), MongoDaoHolder$.MODULE$.tokenCacheDao().find$default$3(), MongoDaoHolder$.MODULE$.tokenCacheDao().find$default$4()));
            Option userOption = qual$1.resultOption(x$1 = qual$1.resultOption$default$1()).filter((Function1 & Serializable)tokenCache -> BoxesRunTime.boxToBoolean((boolean)TokenCache$.$anonfun$validateToken$1(tokenCache))).map((Function1 & Serializable)tokenCache -> AuthHolder$.MODULE$.handler().findUser(tokenCache.userId()));
            if (userOption.isDefined()) {
                this.internalTokenCache().put((Object)token, userOption.get());
            }
            return userOption;
        }
        return cachedToken;
    }

    public void invalidateToken(String token) {
        this.internalTokenCache().invalidate((Object)token);
        ObservableIncludes.GenericObservable qual$1 = dev.mongocamp.driver.mongodb.package$.MODULE$.GenericObservable(MongoDaoHolder$.MODULE$.tokenCacheDao().deleteMany((Bson)dev.mongocamp.driver.mongodb.package$.MODULE$.documentFromScalaMap((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.keyToken()), (Object)token)})))));
        int x$1 = qual$1.resultOption$default$1();
        qual$1.resultOption(x$1);
    }

    public void saveToken(String token, UserInformation userInformation) {
        this.internalTokenCache().put((Object)token, (Object)userInformation);
        TokenCacheElement element = new TokenCacheElement(token, userInformation.userId(), new DateTime().plusMillis((int)((Duration)ConfigurationService$.MODULE$.getConfigValue(DefaultConfigurations$.MODULE$.ConfigKeyAuthExpiringDuration())).toMillis()).toDate());
        if (this.authTokenCacheDB()) {
            dev.mongocamp.driver.mongodb.package$.MODULE$.GenericObservable(MongoDaoHolder$.MODULE$.tokenCacheDao().insertOne(element)).asFuture();
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$validateToken$1(TokenCacheElement tokenCache) {
        boolean result = new DateTime().isBefore((ReadableInstant)new DateTime((Object)tokenCache.validTo()));
        Object object = !result ? dev.mongocamp.driver.mongodb.package$.MODULE$.GenericObservable(MongoDaoHolder$.MODULE$.tokenCacheDao().deleteOne((Bson)dev.mongocamp.driver.mongodb.package$.MODULE$.documentFromScalaMap((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)MODULE$.keyToken()), (Object)tokenCache.token())}))))).asFuture() : BoxedUnit.UNIT;
        return result;
    }

    private TokenCache$() {
    }
}

