/*
 * Decompiled with CFR 0.152.
 */
package dev.mongocamp.server.interceptor;

import dev.mongocamp.server.auth.AuthHolder$;
import dev.mongocamp.server.auth.TokenCache$;
import dev.mongocamp.server.event.EventSystem$;
import dev.mongocamp.server.event.http.HttpRequestCompletedEvent;
import dev.mongocamp.server.event.http.HttpRequestStartEvent;
import dev.mongocamp.server.exception.MongoCampException;
import dev.mongocamp.server.interceptor.RequestFunctions$;
import java.io.Serializable;
import org.joda.time.DateTime;
import org.joda.time.Duration;
import org.joda.time.ReadableInstant;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Function3;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0;
import sttp.model.HeaderNames$;
import sttp.tapir.model.ServerRequest;
import sttp.tapir.server.metrics.EndpointMetric;
import sttp.tapir.server.metrics.EndpointMetric$;
import sttp.tapir.server.metrics.Metric;
import sttp.tapir.server.metrics.MetricLabels;
import sttp.tapir.server.metrics.MetricLabels$;

public final class RequestLogging$ {
    public static final RequestLogging$ MODULE$ = new RequestLogging$();

    public <F> Metric<F, ?> responsesDuration(MetricLabels labels) {
        return new Metric((Object)BoxedUnit.UNIT, (Function3 & Serializable)(request, histogram, m) -> {
            String requestId = (String)RequestFunctions$.MODULE$.getRequestIdOption((ServerRequest)request).getOrElse((Function0 & Serializable)() -> Integer.toString(request.hashCode()));
            DateTime requestStart = new DateTime();
            Option remoteAddress = request.header(HeaderNames$.MODULE$.XForwardedFor()).flatMap((Function1 & Serializable)x$1 -> ArrayOps$.MODULE$.headOption$extension(Predef$.MODULE$.refArrayOps((Object[])x$1.split(",")))).orElse((Function0 & Serializable)() -> request.header(RequestFunctions$.MODULE$.requestHeaderKeyRemoteAddress())).orElse((Function0 & Serializable)() -> request.header(RequestFunctions$.MODULE$.requestHeaderKeyRealIp())).orElse((Function0 & Serializable)() -> request.connectionInfo().remote().flatMap((Function1 & Serializable)a -> Option$.MODULE$.apply((Object)a.getAddress().getHostAddress())));
            String user = (String)request.header(HeaderNames$.MODULE$.Authorization()).map((Function1 & Serializable)auth -> {
                if (auth.startsWith("Bearer ")) {
                    String token = (String)ArrayOps$.MODULE$.last$extension(Predef$.MODULE$.refArrayOps((Object[])auth.split(" ")));
                    return (String)TokenCache$.MODULE$.validateToken(token).map((Function1 & Serializable)x$2 -> x$2.userId()).getOrElse((Function0 & Serializable)() -> "INVALID_TOKEN");
                }
                return "INVALID_AUTH";
            }).getOrElse((Function0 & Serializable)() -> (String)request.header("X-AUTH-APIKEY").map((Function1 & Serializable)key -> (String)AuthHolder$.MODULE$.handler().findUserByApiKeyOption((String)key).map((Function1 & Serializable)x$3 -> x$3.userId()).getOrElse((Function0 & Serializable)() -> "INVALID_APIKEY")).getOrElse((Function0 & Serializable)() -> ""));
            return m.unit((Object)new EndpointMetric((Option)EndpointMetric$.MODULE$.apply$default$1(), (Option)EndpointMetric$.MODULE$.apply$default$2(), (Option)EndpointMetric$.MODULE$.apply$default$3(), (Option)EndpointMetric$.MODULE$.apply$default$4()).onResponseBody((Function2 & Serializable)(endpoint, response) -> m.eval((Function0)(JFunction0.mcV.sp & Serializable)() -> {
                String headOfTags = (String)endpoint.info().tags().headOption().getOrElse((Function0 & Serializable)() -> "NOT_SET");
                String controllerName = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(headOfTags.replace("/", "")), ' ')), (Function1 & Serializable)x$4 -> StringOps$.MODULE$.capitalize$extension(Predef$.MODULE$.augmentString(x$4)), ClassTag$.MODULE$.apply(String.class))).mkString("");
                String methodeName = (String)endpoint.info().name().getOrElse((Function0 & Serializable)() -> headOfTags);
                HttpRequestCompletedEvent requestCompletedEvent = new HttpRequestCompletedEvent(requestId, request.method(), methodeName, request.uri().toString(), (String)remoteAddress.getOrElse((Function0 & Serializable)() -> "NOT_SET"), user, new Duration((ReadableInstant)requestStart, (ReadableInstant)new DateTime()), response.code(), controllerName, methodeName, (String)endpoint.info().description().getOrElse((Function0 & Serializable)() -> "NOT_SET"));
                EventSystem$.MODULE$.eventStream().publish((Object)requestCompletedEvent);
            })).onException((Function2 & Serializable)(endpoint, exception) -> m.eval((Function0)(JFunction0.mcV.sp & Serializable)() -> {
                int n;
                Throwable throwable = exception;
                if (throwable instanceof MongoCampException) {
                    MongoCampException mongoCampException = (MongoCampException)throwable;
                    n = mongoCampException.statusCode();
                } else {
                    n = 500;
                }
                int statusCode = n;
                String headOfTags = (String)endpoint.info().tags().headOption().getOrElse((Function0 & Serializable)() -> "NOT_SET");
                String controllerName = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(headOfTags.replace("/", "")), ' ')), (Function1 & Serializable)x$5 -> StringOps$.MODULE$.capitalize$extension(Predef$.MODULE$.augmentString(x$5)), ClassTag$.MODULE$.apply(String.class))).mkString("");
                String methodeName = (String)endpoint.info().name().getOrElse((Function0 & Serializable)() -> headOfTags);
                HttpRequestCompletedEvent requestCompletedEvent = new HttpRequestCompletedEvent(requestId, request.method(), methodeName, request.uri().toString(), (String)remoteAddress.getOrElse((Function0 & Serializable)() -> "NOT_SET"), user, new Duration((ReadableInstant)requestStart, (ReadableInstant)new DateTime()), statusCode, controllerName, methodeName, (String)endpoint.info().description().getOrElse((Function0 & Serializable)() -> "NOT_SET"));
                EventSystem$.MODULE$.eventStream().publish((Object)requestCompletedEvent);
            })).onEndpointRequest((Function1 & Serializable)endpoint -> m.eval((Function0)(JFunction0.mcV.sp & Serializable)() -> {
                String headOfTags = (String)endpoint.info().tags().headOption().getOrElse((Function0 & Serializable)() -> "NOT_SET");
                String controllerName = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(headOfTags.replace("/", "")), ' ')), (Function1 & Serializable)x$6 -> StringOps$.MODULE$.capitalize$extension(Predef$.MODULE$.augmentString(x$6)), ClassTag$.MODULE$.apply(String.class))).mkString("");
                String methodeName = (String)endpoint.info().name().getOrElse((Function0 & Serializable)() -> headOfTags);
                HttpRequestStartEvent requestStartEvent = new HttpRequestStartEvent(requestId, request.method(), methodeName, request.uri().toString(), (String)remoteAddress.getOrElse((Function0 & Serializable)() -> "NOT_SET"), user, controllerName, methodeName, (String)endpoint.info().description().getOrElse((Function0 & Serializable)() -> "NOT_SET"));
                EventSystem$.MODULE$.eventStream().publish((Object)requestStartEvent);
            })));
        });
    }

    public <F> MetricLabels responsesDuration$default$1() {
        return MetricLabels$.MODULE$.Default();
    }

    private RequestLogging$() {
    }
}

