/*
 * Decompiled with CFR 0.152.
 */
package dev.mongocamp.server.plugin;

import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.InsertOneResult;
import com.mongodb.client.result.UpdateResult;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import dev.mongocamp.driver.mongodb.operation.ObservableIncludes;
import dev.mongocamp.server.database.MongoDaoHolder$;
import dev.mongocamp.server.event.EventSystem$;
import dev.mongocamp.server.event.job.CreateJobEvent;
import dev.mongocamp.server.event.job.DeleteJobEvent;
import dev.mongocamp.server.event.job.UpdateJobEvent;
import dev.mongocamp.server.exception.ErrorCodes$;
import dev.mongocamp.server.exception.MongoCampException;
import dev.mongocamp.server.exception.MongoCampException$;
import dev.mongocamp.server.model.JobConfig;
import dev.mongocamp.server.model.JobInformation;
import dev.mongocamp.server.model.auth.UserInformation;
import dev.mongocamp.server.plugin.ServerPlugin;
import dev.mongocamp.server.service.ReflectionService$;
import java.io.Serializable;
import java.util.Date;
import org.bson.conversions.Bson;
import org.mongodb.scala.Observable;
import org.mongodb.scala.model.package;
import org.mongodb.scala.package$;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.Job;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.impl.StdSchedulerFactory;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.math.Ordering$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import sttp.model.StatusCode$;

public final class JobPlugin$
implements ServerPlugin,
LazyLogging {
    public static final JobPlugin$ MODULE$ = new JobPlugin$();
    private static Scheduler scheduler;
    private static transient Logger logger;
    private static volatile transient boolean bitmap$trans$0;
    private static volatile boolean bitmap$0;

    static {
        LazyLogging.$init$((LazyLogging)MODULE$);
    }

    private Logger logger$lzycompute() {
        JobPlugin$ jobPlugin$ = this;
        synchronized (jobPlugin$) {
            if (!bitmap$trans$0) {
                logger = LazyLogging.logger$((LazyLogging)this);
                bitmap$trans$0 = true;
            }
        }
        return logger;
    }

    public Logger logger() {
        if (!bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    private Scheduler scheduler$lzycompute() {
        JobPlugin$ jobPlugin$ = this;
        synchronized (jobPlugin$) {
            if (!bitmap$0) {
                scheduler = StdSchedulerFactory.getDefaultScheduler();
                bitmap$0 = true;
            }
        }
        return scheduler;
    }

    private Scheduler scheduler() {
        if (!bitmap$0) {
            return this.scheduler$lzycompute();
        }
        return scheduler;
    }

    @Override
    public void activate() {
        this.scheduler().start();
        package$.MODULE$.SingleObservableFuture((Function0 & Serializable)() -> MongoDaoHolder$.MODULE$.jobDao().createIndex((Bson)dev.mongocamp.driver.mongodb.package$.MODULE$.documentFromScalaMap((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"group"), (Object)BoxesRunTime.boxToInteger((int)1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)BoxesRunTime.boxToInteger((int)1))}))), package.IndexOptions$.MODULE$.apply().unique(true))).toFuture();
        this.reloadJobs();
        scala.sys.package$.MODULE$.addShutdownHook((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            BoxedUnit boxedUnit;
            if (MODULE$.logger().underlying().isInfoEnabled()) {
                MODULE$.logger().underlying().info("Shutdown for Job Scheduler triggered. Wait fore Jobs to be completed");
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            MODULE$.scheduler().shutdown(true);
        });
    }

    public void reloadJobs() {
        this.scheduler().clear();
        this.loadJobs();
    }

    public JobInformation convertToJobInformation(JobConfig jobConfig) {
        List<Trigger> schedulerTriggerList = this.getTriggerList(jobConfig.name(), jobConfig.group());
        None$ nextFireTime = None$.MODULE$;
        None$ lastFireTime = None$.MODULE$;
        None$ scheduleInfo = None$.MODULE$;
        if (schedulerTriggerList.nonEmpty()) {
            nextFireTime = Option$.MODULE$.apply(schedulerTriggerList.map((Function1 & Serializable)x$1 -> x$1.getNextFireTime()).min(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms())));
            lastFireTime = Option$.MODULE$.apply(schedulerTriggerList.map((Function1 & Serializable)x$2 -> x$2.getPreviousFireTime()).max(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms())));
        } else {
            scheduleInfo = new Some((Object)new StringBuilder(36).append("Job `").append(jobConfig.name()).append("` in group `").append(jobConfig.group()).append("` is not scheduled.").toString());
        }
        return new JobInformation(jobConfig.name(), jobConfig.group(), jobConfig.className(), jobConfig.description(), jobConfig.cronExpression(), jobConfig.priority(), (Option<Date>)lastFireTime, (Option<Date>)nextFireTime, (Option<String>)scheduleInfo);
    }

    public boolean addJob(JobConfig jobConfig, Option<UserInformation> userInformationOption) {
        int x$1;
        Class<? extends Job> jobClass = this.getJobClass(jobConfig);
        String internalJobName = jobConfig.name().trim().equalsIgnoreCase("") ? jobClass.getSimpleName() : jobConfig.name();
        ObservableIncludes.GenericObservable qual$1 = dev.mongocamp.driver.mongodb.package$.MODULE$.GenericObservable((Observable)MongoDaoHolder$.MODULE$.jobDao().find((Bson)dev.mongocamp.driver.mongodb.package$.MODULE$.documentFromScalaMap((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)internalJobName), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"group"), (Object)jobConfig.group())}))), MongoDaoHolder$.MODULE$.jobDao().find$default$2(), MongoDaoHolder$.MODULE$.jobDao().find$default$3(), MongoDaoHolder$.MODULE$.jobDao().find$default$4()));
        boolean couldAddJob = qual$1.resultOption(x$1 = qual$1.resultOption$default$1()).isEmpty();
        if (couldAddJob) {
            JobConfig jobConfigDetail = jobConfig.copy(internalJobName, jobConfig.copy$default$2(), jobConfig.copy$default$3(), jobConfig.copy$default$4(), jobConfig.copy$default$5(), jobConfig.copy$default$6());
            ObservableIncludes.GenericObservable qual$2 = dev.mongocamp.driver.mongodb.package$.MODULE$.GenericObservable(MongoDaoHolder$.MODULE$.jobDao().insertOne(jobConfigDetail));
            int x$2 = qual$2.result$default$1();
            InsertOneResult inserted = (InsertOneResult)qual$2.result(x$2);
            this.reloadJobs();
            if (inserted.wasAcknowledged()) {
                userInformationOption.foreach((Function1 & Serializable)userInformation -> {
                    JobPlugin$.$anonfun$addJob$1(jobConfig, userInformation);
                    return BoxedUnit.UNIT;
                });
            }
            return inserted.wasAcknowledged();
        }
        throw new MongoCampException(new StringBuilder(30).append(jobConfig.name()).append(" with group ").append(jobConfig.group()).append(" is already added.").toString(), StatusCode$.MODULE$.PreconditionFailed(), ErrorCodes$.MODULE$.jobAlreadyAdded(), MongoCampException$.MODULE$.apply$default$4());
    }

    public Option<UserInformation> addJob$default$2() {
        return None$.MODULE$;
    }

    public List<Trigger> getTriggerList(String jobName, String groupName) {
        Nil$ nil$;
        try {
            nil$ = CollectionConverters$.MODULE$.ListHasAsScala(this.scheduler().getTriggersOfJob(new JobKey(jobName, groupName))).asScala().toList();
        }
        catch (Exception exception) {
            nil$ = Nil$.MODULE$;
        }
        return nil$;
    }

    public Class<? extends Job> getJobClass(JobConfig jobConfig) {
        Class jobClass = null;
        try {
            jobClass = ReflectionService$.MODULE$.getClassByName(jobConfig.className());
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new MongoCampException(new StringBuilder(28).append(jobConfig.className()).append(" for ").append(jobConfig.name()).append(" with group ").append(jobConfig.group()).append(" not found.").toString(), StatusCode$.MODULE$.NotFound(), ErrorCodes$.MODULE$.jobClassNotFound(), MongoCampException$.MODULE$.apply$default$4());
        }
        return jobClass;
    }

    /*
     * Unable to fully structure code
     */
    public boolean updateJob(UserInformation userInformation, String groupName, String jobName, JobConfig jobConfig) {
        qual$1 = dev.mongocamp.driver.mongodb.package$.MODULE$.GenericObservable((Observable)MongoDaoHolder$.MODULE$.jobDao().find((Bson)dev.mongocamp.driver.mongodb.package$.MODULE$.documentFromScalaMap((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)jobName), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"group"), (Object)groupName)}))), MongoDaoHolder$.MODULE$.jobDao().find$default$2(), MongoDaoHolder$.MODULE$.jobDao().find$default$3(), MongoDaoHolder$.MODULE$.jobDao().find$default$4()));
        jobExists = qual$1.resultOption(x$1 = qual$1.resultOption$default$1()).isDefined();
        if (!jobExists) {
            throw new MongoCampException(new StringBuilder(29).append(jobName).append(" with group ").append(groupName).append(" does not exists.").toString(), StatusCode$.MODULE$.NotFound(), ErrorCodes$.MODULE$.jobCouldNotFound(), MongoCampException$.MODULE$.apply$default$4());
        }
        v0 = jobName;
        var9_8 = jobConfig.name();
        if (v0 != null ? v0.equals(var9_8) == false : var9_8 != null) ** GOTO lbl-1000
        v1 = groupName;
        var10_9 = jobConfig.group();
        if (!(v1 != null ? v1.equals(var10_9) == false : var10_9 != null)) {
            v2 = true;
        } else lbl-1000:
        // 2 sources

        {
            jobClass = this.getJobClass(jobConfig);
            internalJobName = jobConfig.name().trim().equalsIgnoreCase("") != false ? jobClass.getSimpleName() : jobConfig.name();
            qual$2 = dev.mongocamp.driver.mongodb.package$.MODULE$.GenericObservable((Observable)MongoDaoHolder$.MODULE$.jobDao().find((Bson)dev.mongocamp.driver.mongodb.package$.MODULE$.documentFromScalaMap((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)internalJobName), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"group"), (Object)jobConfig.group())}))), MongoDaoHolder$.MODULE$.jobDao().find$default$2(), MongoDaoHolder$.MODULE$.jobDao().find$default$3(), MongoDaoHolder$.MODULE$.jobDao().find$default$4()));
            x$2 = qual$2.resultOption$default$1();
            v2 = couldUpdate = qual$2.resultOption(x$2).isEmpty();
        }
        if (couldUpdate) {
            qual$3 = dev.mongocamp.driver.mongodb.package$.MODULE$.GenericObservable(MongoDaoHolder$.MODULE$.jobDao().replaceOne((Bson)dev.mongocamp.driver.mongodb.package$.MODULE$.documentFromScalaMap((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)jobName), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"group"), (Object)groupName)}))), jobConfig));
            x$3 = qual$3.result$default$1();
            updateResponse = (UpdateResult)qual$3.result(x$3);
            this.reloadJobs();
            if (updateResponse.getModifiedCount() > 0L) {
                EventSystem$.MODULE$.eventStream().publish((Object)new UpdateJobEvent(userInformation, jobName, groupName, jobConfig));
            }
            return updateResponse.wasAcknowledged() != false && updateResponse.getModifiedCount() > 0L;
        }
        throw new MongoCampException(new StringBuilder(49).append(jobName).append(" with group ").append(groupName).append(" is already exists. Could not rename.").toString(), StatusCode$.MODULE$.PreconditionFailed(), ErrorCodes$.MODULE$.jobCouldNotUpdated(), MongoCampException$.MODULE$.apply$default$4());
    }

    public boolean deleteJob(UserInformation userInformation, String groupName, String jobName) {
        ObservableIncludes.GenericObservable qual$1 = dev.mongocamp.driver.mongodb.package$.MODULE$.GenericObservable(MongoDaoHolder$.MODULE$.jobDao().deleteMany((Bson)dev.mongocamp.driver.mongodb.package$.MODULE$.documentFromScalaMap((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"name"), (Object)jobName), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"group"), (Object)groupName)})))));
        int x$1 = qual$1.result$default$1();
        DeleteResult deleteResponse = (DeleteResult)qual$1.result(x$1);
        this.reloadJobs();
        if (deleteResponse.getDeletedCount() > 0L) {
            EventSystem$.MODULE$.eventStream().publish((Object)new DeleteJobEvent(userInformation, jobName, groupName));
        }
        return deleteResponse.wasAcknowledged() && deleteResponse.getDeletedCount() > 0L;
    }

    public boolean executeJob(String groupName, String jobName) {
        boolean bl;
        try {
            this.scheduler().triggerJob(new JobKey(jobName, groupName));
            bl = true;
        }
        catch (Exception exception) {
            throw new MongoCampException(new StringBuilder(22).append(jobName).append(" with group ").append(groupName).append(" not found").toString(), StatusCode$.MODULE$.NotFound(), ErrorCodes$.MODULE$.jobCouldNotFound(), MongoCampException$.MODULE$.apply$default$4());
        }
        return bl;
    }

    private void loadJobs() {
        ObservableIncludes.GenericObservable qual$1 = dev.mongocamp.driver.mongodb.package$.MODULE$.GenericObservable((Observable)MongoDaoHolder$.MODULE$.jobDao().find(MongoDaoHolder$.MODULE$.jobDao().find$default$1(), MongoDaoHolder$.MODULE$.jobDao().find$default$2(), MongoDaoHolder$.MODULE$.jobDao().find$default$3(), MongoDaoHolder$.MODULE$.jobDao().find$default$4()));
        int x$1 = qual$1.resultList$default$1();
        List foundJobs = qual$1.resultList(x$1);
        foundJobs.foreach((Function1 & Serializable)dbJob -> {
            JobPlugin$.MODULE$.scheduleJob(dbJob);
            return BoxedUnit.UNIT;
        });
    }

    private void scheduleJob(JobConfig dbJob) {
        block3: {
            try {
                Class jobClass = ReflectionService$.MODULE$.getClassByName(dbJob.className());
                JobDetail job = JobBuilder.newJob((Class)jobClass).withIdentity(dbJob.name(), dbJob.group()).build();
                CronTrigger trigger = (CronTrigger)TriggerBuilder.newTrigger().withIdentity(new StringBuilder(7).append(dbJob.name()).append("Trigger").toString(), dbJob.group()).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)dbJob.cronExpression())).withPriority(dbJob.priority()).forJob(job).build();
                this.scheduler().scheduleJob(job, (Trigger)trigger);
            }
            catch (ClassNotFoundException classNotFoundException) {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error("job {} for group {} class ({}) not found ", new Object[]{dbJob.name(), dbJob.group(), dbJob.className()});
                    boxedUnit = BoxedUnit.UNIT;
                    break block3;
                }
                boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    public static final /* synthetic */ void $anonfun$addJob$1(JobConfig jobConfig$1, UserInformation userInformation) {
        EventSystem$.MODULE$.eventStream().publish((Object)new CreateJobEvent(userInformation, jobConfig$1));
    }

    private JobPlugin$() {
    }
}

