/*
 * Decompiled with CFR 0.152.
 */
package dev.mongocamp.server.service;

import dev.mongocamp.driver.mongodb.package$;
import dev.mongocamp.server.converter.MongoCampBsonConverter$;
import dev.mongocamp.server.database.MongoDatabase$;
import dev.mongocamp.server.database.paging.MongoPaginatedAggregation;
import dev.mongocamp.server.database.paging.PaginationInfo;
import dev.mongocamp.server.database.paging.PaginationResult;
import dev.mongocamp.server.model.MongoAggregateRequest;
import dev.mongocamp.server.model.PipelineStage;
import dev.mongocamp.server.model.auth.AuthorizedCollectionRequest;
import java.io.Serializable;
import org.bson.BsonDocument;
import org.bson.conversions.Bson;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.runtime.ScalaRunTime$;

public final class AggregationService$ {
    public static final AggregationService$ MODULE$ = new AggregationService$();

    public Tuple2<List<Map<String, Object>>, PaginationInfo> paginatedAggregation(AuthorizedCollectionRequest authorizedCollectionRequest, Seq<Bson> pipeline, boolean allowDiskUse, long rowsPerPage, long page) {
        MongoPaginatedAggregation mongoPaginatedFilter = new MongoPaginatedAggregation(MongoDatabase$.MODULE$.databaseProvider().dao(authorizedCollectionRequest.collection()), allowDiskUse, (List<Bson>)pipeline.toList());
        PaginationResult<BsonDocument> aggregateResult = mongoPaginatedFilter.paginate(rowsPerPage, page);
        return new Tuple2((Object)aggregateResult.databaseObjects().map((Function1 & Serializable)document -> MongoCampBsonConverter$.MODULE$.documentToMap((BsonDocument)document)), (Object)aggregateResult.paginationInfo());
    }

    public Tuple2<List<Map<String, Object>>, PaginationInfo> paginatedAggregation(AuthorizedCollectionRequest authorizedCollectionRequest, MongoAggregateRequest mongoAggregateRequest, long rowsPerPage, long page) {
        Seq<Bson> pipeline = this.convertToBsonPipeline(mongoAggregateRequest.pipeline());
        return this.paginatedAggregation(authorizedCollectionRequest, pipeline, mongoAggregateRequest.allowDiskUse(), rowsPerPage, page);
    }

    public Seq<Bson> convertToBsonPipeline(List<PipelineStage> pipeline) {
        List response = pipeline.map((Function1 & Serializable)element -> {
            String stage = element.stage().startsWith("$") ? element.stage() : new StringBuilder(1).append("$").append(element.stage()).toString();
            return package$.MODULE$.mapToBson((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)stage), element.value())})));
        });
        return response;
    }

    private AggregationService$() {
    }
}

