/*
 * Decompiled with CFR 0.152.
 */
package dev.mongocamp.server.service;

import com.mongodb.client.result.DeleteResult;
import com.mongodb.client.result.UpdateResult;
import com.typesafe.config.Config;
import dev.mongocamp.driver.mongodb.Converter$;
import dev.mongocamp.driver.mongodb.operation.ObservableIncludes;
import dev.mongocamp.driver.mongodb.package$;
import dev.mongocamp.server.database.ConfigDao;
import dev.mongocamp.server.event.EventSystem$;
import dev.mongocamp.server.event.config.ConfigRegisterEvent;
import dev.mongocamp.server.event.config.ConfigUpdateEvent;
import dev.mongocamp.server.model.MongoCampConfiguration;
import dev.mongocamp.server.service.ConfigurationRead;
import dev.mongocamp.server.service.ConfigurationRead$;
import java.io.Serializable;
import org.bson.conversions.Bson;
import scala.Function0;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.runtime.ScalaRunTime$;

public final class ConfigurationService$
implements ConfigurationRead {
    public static final ConfigurationService$ MODULE$ = new ConfigurationService$();
    private static Config dev$mongocamp$server$service$ConfigurationRead$$conf;
    private static volatile boolean bitmap$0;

    static {
        ConfigurationRead.$init$((ConfigurationRead)MODULE$);
    }

    public <A> A getConfigValue(String key) {
        return (A)ConfigurationRead.getConfigValue$((ConfigurationRead)this, (String)key);
    }

    public Option<MongoCampConfiguration> getConfig(String key) {
        return ConfigurationRead.getConfig$((ConfigurationRead)this, (String)key);
    }

    public List<MongoCampConfiguration> getAllRegisteredConfigurations() {
        return ConfigurationRead.getAllRegisteredConfigurations$((ConfigurationRead)this);
    }

    public void registerMongoCampServerDefaultConfigs() {
        ConfigurationRead.registerMongoCampServerDefaultConfigs$((ConfigurationRead)this);
    }

    public boolean registerNonPersistentConfig(String configKey, String configType, Option<Object> value, String comment) {
        return ConfigurationRead.registerNonPersistentConfig$((ConfigurationRead)this, (String)configKey, (String)configType, value, (String)comment);
    }

    public Option<Object> registerNonPersistentConfig$default$3() {
        return ConfigurationRead.registerNonPersistentConfig$default$3$((ConfigurationRead)this);
    }

    public String registerNonPersistentConfig$default$4() {
        return ConfigurationRead.registerNonPersistentConfig$default$4$((ConfigurationRead)this);
    }

    public boolean registerConfig(String configKey, String configType, Option<Object> value, String comment, boolean needsRestartForActivation) {
        return ConfigurationRead.registerConfig$((ConfigurationRead)this, (String)configKey, (String)configType, value, (String)comment, (boolean)needsRestartForActivation);
    }

    public Option<Object> registerConfig$default$3() {
        return ConfigurationRead.registerConfig$default$3$((ConfigurationRead)this);
    }

    public String registerConfig$default$4() {
        return ConfigurationRead.registerConfig$default$4$((ConfigurationRead)this);
    }

    public boolean registerConfig$default$5() {
        return ConfigurationRead.registerConfig$default$5$((ConfigurationRead)this);
    }

    public void checkAndUpdateWithEnv(String key) {
        ConfigurationRead.checkAndUpdateWithEnv$((ConfigurationRead)this, (String)key);
    }

    public Option<MongoCampConfiguration> getConfigFromDatabase(String key) {
        return ConfigurationRead.getConfigFromDatabase$((ConfigurationRead)this, (String)key);
    }

    public MongoCampConfiguration convertToDbConfiguration(String configKey, String configType, Option<Object> value, String comment, boolean needsRestartForActivation) {
        return ConfigurationRead.convertToDbConfiguration$((ConfigurationRead)this, (String)configKey, (String)configType, value, (String)comment, (boolean)needsRestartForActivation);
    }

    public Option<Object> convertToDbConfiguration$default$3() {
        return ConfigurationRead.convertToDbConfiguration$default$3$((ConfigurationRead)this);
    }

    public String convertToDbConfiguration$default$4() {
        return ConfigurationRead.convertToDbConfiguration$default$4$((ConfigurationRead)this);
    }

    public boolean convertToDbConfiguration$default$5() {
        return ConfigurationRead.convertToDbConfiguration$default$5$((ConfigurationRead)this);
    }

    public Object convertStringToValue(String stringValue, String configType) {
        return ConfigurationRead.convertStringToValue$((ConfigurationRead)this, (String)stringValue, (String)configType);
    }

    public Option<String> loadEnvValue(String key) {
        return ConfigurationRead.loadEnvValue$((ConfigurationRead)this, (String)key);
    }

    private Config dev$mongocamp$server$service$ConfigurationRead$$conf$lzycompute() {
        ConfigurationService$ configurationService$ = this;
        synchronized (configurationService$) {
            if (!bitmap$0) {
                dev$mongocamp$server$service$ConfigurationRead$$conf = ConfigurationRead.dev$mongocamp$server$service$ConfigurationRead$$conf$((ConfigurationRead)this);
                bitmap$0 = true;
            }
        }
        return dev$mongocamp$server$service$ConfigurationRead$$conf;
    }

    public Config dev$mongocamp$server$service$ConfigurationRead$$conf() {
        if (!bitmap$0) {
            return this.dev$mongocamp$server$service$ConfigurationRead$$conf$lzycompute();
        }
        return dev$mongocamp$server$service$ConfigurationRead$$conf;
    }

    public boolean removeConfig(String configKey) {
        Option nonPersistentRemove = ConfigurationRead$.MODULE$.nonPersistentConfigs().remove((Object)configKey);
        if (nonPersistentRemove.isEmpty()) {
            ConfigurationRead$.MODULE$.configCache().invalidate((Object)configKey);
            ObservableIncludes.GenericObservable qual$1 = package$.MODULE$.GenericObservable(new ConfigDao().deleteOne((Object)package$.MODULE$.documentFromScalaMap((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"key"), (Object)configKey)})))));
            int x$1 = qual$1.result$default$1();
            DeleteResult deleteResult = (DeleteResult)qual$1.result(x$1);
            return deleteResult.wasAcknowledged();
        }
        return nonPersistentRemove.nonEmpty();
    }

    public boolean updateConfig(String key, Object value, Option<String> commentOption) {
        if (this.loadEnvValue(key).isEmpty()) {
            Option<MongoCampConfiguration> dbOption = this.getConfigFromDatabase(key);
            if (dbOption.isDefined()) {
                MongoCampConfiguration qual$1 = (MongoCampConfiguration)dbOption.get();
                Object x$1 = value;
                String x$2 = (String)commentOption.getOrElse((Function0 & Serializable)() -> ((MongoCampConfiguration)dbOption.get()).comment());
                String x$3 = qual$1.copy$default$1();
                String x$4 = qual$1.copy$default$3();
                boolean x$5 = qual$1.copy$default$5();
                MongoCampConfiguration mongoCampConfiguration = qual$1.copy(x$3, x$1, x$4, x$2, x$5);
                ObservableIncludes.GenericObservable qual$2 = package$.MODULE$.GenericObservable(new ConfigDao().replaceOne((Bson)package$.MODULE$.documentFromScalaMap((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"key"), (Object)key)}))), (Object)Converter$.MODULE$.toDocument((Object)mongoCampConfiguration)));
                int x$6 = qual$2.result$default$1();
                UpdateResult replaceResult = (UpdateResult)qual$2.result(x$6);
                ConfigurationRead$.MODULE$.configCache().invalidate((Object)key);
                EventSystem$.MODULE$.eventStream().publish((Object)new ConfigUpdateEvent(key, value, ((MongoCampConfiguration)dbOption.get()).value(), "updateConfig"));
                return replaceResult.wasAcknowledged();
            }
            return false;
        }
        return false;
    }

    public Option<String> updateConfig$default$3() {
        return None$.MODULE$;
    }

    public void publishConfigUpdateEvent(String key, Object newValue, Object oldValue, String callingMethod) {
        EventSystem$.MODULE$.eventStream().publish((Object)new ConfigUpdateEvent(key, newValue, oldValue, "checkAndUpdateWithEnv"));
    }

    public void publishConfigRegisterEvent(boolean persistent, String configKey, String configType, Option<Object> value, String comment, boolean needsRestartForActivation) {
        EventSystem$.MODULE$.eventStream().publish((Object)new ConfigRegisterEvent(persistent, configKey, configType, value, comment, needsRestartForActivation));
    }

    private ConfigurationService$() {
    }
}

