/*
 * Decompiled with CFR 0.152.
 */
package dev.mongocamp.driver.mongodb.lucene;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import dev.mongocamp.driver.mongodb.exception.NotSupportedException;
import dev.mongocamp.driver.mongodb.lucene.MongoCampLuceneAnalyzer;
import dev.mongocamp.driver.mongodb.lucene.MongoCampLuceneAnalyzer$;
import dev.mongocamp.driver.mongodb.package$;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.PhraseQuery;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TermRangeQuery;
import org.apache.lucene.search.WildcardQuery;
import org.bson.conversions.Bson;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

public final class LuceneQueryConverter$
implements LazyLogging {
    public static LuceneQueryConverter$ MODULE$;
    private List<String> datePatters;
    private transient Logger logger;
    private volatile boolean bitmap$0;
    private volatile transient boolean bitmap$trans$0;

    static {
        new LuceneQueryConverter$();
    }

    private Logger logger$lzycompute() {
        LuceneQueryConverter$ luceneQueryConverter$ = this;
        synchronized (luceneQueryConverter$) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$trans$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    public Bson toDocument(Query query) {
        return package$.MODULE$.documentFromScalaMap(this.getMongoDbSearchMap(query, false));
    }

    public Query parse(String queryString, String defaultField) {
        MongoCampLuceneAnalyzer analyzer = new MongoCampLuceneAnalyzer(MongoCampLuceneAnalyzer$.MODULE$.$lessinit$greater$default$1(), MongoCampLuceneAnalyzer$.MODULE$.$lessinit$greater$default$2());
        QueryParser queryParser = new QueryParser(defaultField, (Analyzer)analyzer);
        queryParser.setAllowLeadingWildcard(true);
        Query query = queryParser.parse(queryString);
        analyzer.close();
        analyzer = null;
        return query;
    }

    private Map<String, Object> getMongoDbSearchMap(Query query, boolean negated) {
        scala.collection.mutable.Map searchMapResponse = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        Query query2 = query;
        if (query2 instanceof BooleanQuery) {
            BooleanQuery booleanQuery = (BooleanQuery)query2;
            this.appendBooleanQueryToSearchMap((scala.collection.mutable.Map<String, Object>)searchMapResponse, booleanQuery);
        } else if (query2 instanceof TermRangeQuery) {
            TermRangeQuery termRangeQuery = (TermRangeQuery)query2;
            this.appendTermRangeQueryToSearchMap(negated, (scala.collection.mutable.Map<String, Object>)searchMapResponse, termRangeQuery);
        } else if (query2 instanceof TermQuery) {
            TermQuery termQuery = (TermQuery)query2;
            this.appendTermQueryToSearchMap(negated, (scala.collection.mutable.Map<String, Object>)searchMapResponse, termQuery);
        } else if (query2 instanceof PrefixQuery) {
            PrefixQuery prefixQuery = (PrefixQuery)query2;
            this.appendPrefixQueryToSearchMap(negated, (scala.collection.mutable.Map<String, Object>)searchMapResponse, prefixQuery);
        } else if (query2 instanceof WildcardQuery) {
            WildcardQuery wildcardQuery = (WildcardQuery)query2;
            this.appendWildCardQueryToSearchMap(negated, (scala.collection.mutable.Map<String, Object>)searchMapResponse, wildcardQuery);
        } else if (query2 instanceof PhraseQuery) {
            PhraseQuery phraseQuery = (PhraseQuery)query2;
            this.appendPhraseQueryToSearchMap(negated, (scala.collection.mutable.Map<String, Object>)searchMapResponse, phraseQuery);
        } else if (query2 != null) {
            Query query3 = query2;
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error("Unexpected QueryType <{}>", new Object[]{query3.getClass().getSimpleName()});
            }
        } else {
            throw new MatchError((Object)query2);
        }
        return searchMapResponse.toMap(Predef$.MODULE$.$conforms());
    }

    private void appendBooleanQueryToSearchMap(scala.collection.mutable.Map<String, Object> searchMapResponse, BooleanQuery booleanQuery) {
        Buffer subQueries = (Buffer)CollectionConverters$.MODULE$.asScalaBufferConverter(booleanQuery.clauses()).asScala();
        ArrayBuffer listOfAnd = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        ArrayBuffer listOfOr = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        BooleanRef nextTypeAnd = BooleanRef.create((boolean)true);
        subQueries.foreach((Function1 & Serializable & scala.Serializable)c -> {
            LuceneQueryConverter$.$anonfun$appendBooleanQueryToSearchMap$1(nextTypeAnd, listOfAnd, listOfOr, c);
            return BoxedUnit.UNIT;
        });
        Object object = listOfAnd.nonEmpty() ? searchMapResponse.put((Object)"$and", (Object)listOfAnd.toList()) : BoxedUnit.UNIT;
        if (listOfOr.nonEmpty()) {
            searchMapResponse.put((Object)"$or", (Object)listOfOr.toList());
            return;
        }
    }

    private void appendTermRangeQueryToSearchMap(boolean negated, scala.collection.mutable.Map<String, Object> searchMapResponse, TermRangeQuery termRangeQuery) {
        Object lowerBound = this.checkAndConvertValue(new String(termRangeQuery.getLowerTerm().bytes));
        Object upperBound = this.checkAndConvertValue(new String(termRangeQuery.getUpperTerm().bytes));
        Map inRangeSearch = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"$lte"), upperBound), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"$gte"), lowerBound)}));
        if (negated) {
            searchMapResponse.put((Object)termRangeQuery.getField(), (Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"$not"), (Object)inRangeSearch)})));
            return;
        }
        searchMapResponse.put((Object)termRangeQuery.getField(), (Object)inRangeSearch);
    }

    private void appendTermQueryToSearchMap(boolean negated, scala.collection.mutable.Map<String, Object> searchMapResponse, TermQuery termQuery) {
        if (negated) {
            searchMapResponse.put((Object)termQuery.getTerm().field(), (Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"$ne"), this.checkAndConvertValue(termQuery.getTerm().text()))})));
            return;
        }
        searchMapResponse.put((Object)termQuery.getTerm().field(), (Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"$eq"), this.checkAndConvertValue(termQuery.getTerm().text()))})));
    }

    private void appendPrefixQueryToSearchMap(boolean negated, scala.collection.mutable.Map<String, Object> searchMapResponse, PrefixQuery query) {
        String searchValue = new StringBuilder(5).append(this.checkAndConvertValue(query.getPrefix().text())).append("(.*?)").toString();
        .colon.colon listOfSearches = new .colon.colon((Object)package$.MODULE$.documentFromScalaMap((Map<String, Object>)((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)query.getField()), this.generateRegexQuery(String.valueOf(searchValue), "i"))})))), (List)Nil$.MODULE$);
        if (negated) {
            searchMapResponse.put((Object)"$nor", (Object)listOfSearches);
            return;
        }
        searchMapResponse.$plus$plus$eq((TraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"$and"), (Object)listOfSearches)})));
    }

    private void appendWildCardQueryToSearchMap(boolean negated, scala.collection.mutable.Map<String, Object> searchMapResponse, WildcardQuery query) {
        Object searchValue = this.checkAndConvertValue(query.getTerm().text().replace("*", "(.*?)"));
        if (negated) {
            searchMapResponse.put((Object)query.getField(), (Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"$not"), this.generateRegexQuery(String.valueOf(searchValue), "i"))})));
            return;
        }
        searchMapResponse.put((Object)query.getField(), this.generateRegexQuery(String.valueOf(searchValue), "i"));
    }

    private void appendPhraseQueryToSearchMap(boolean negated, scala.collection.mutable.Map<String, Object> searchMapResponse, PhraseQuery query) {
        List listOfSearches = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])query.getTerms())).map((Function1 & Serializable & scala.Serializable)term -> (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)term.field()), MODULE$.generateRegexQuery(new StringBuilder(10).append("(.*?)").append(MODULE$.checkAndConvertValue(term.text())).append("(.*?)").toString(), "i"))})), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Map.class))))).toList();
        if (negated) {
            searchMapResponse.put((Object)"$nor", (Object)listOfSearches);
            return;
        }
        searchMapResponse.$plus$plus$eq((TraversableOnce)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"$and"), (Object)listOfSearches)})));
    }

    private Map<String, String> generateRegexQuery(String pattern, String options) {
        return (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"$regex"), (Object)pattern), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"$options"), (Object)options)}));
    }

    private Object checkAndConvertValue(String s) {
        Object object;
        try {
            Option convertedValue = ((TraversableLike)((List)((List)Nil$.MODULE$.$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(LuceneQueryConverter$.checkOrReturn$1((Function0)(JFunction0.mcD.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(s)).toDouble(), s)), List$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(LuceneQueryConverter$.checkOrReturn$1((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(s)).toLong(), s)), List$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(LuceneQueryConverter$.checkOrReturn$1((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(s)).toBoolean(), s)), List$.MODULE$.canBuildFrom())).headOption();
            object = convertedValue.getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                Option parsedOptions = ((LinearSeqOptimized)MODULE$.datePatters().map((Function1 & Serializable & scala.Serializable)pattern -> {
                    None$ none$;
                    try {
                        SimpleDateFormat formatter = new SimpleDateFormat((String)pattern);
                        none$ = Option$.MODULE$.apply((Object)formatter.parse(s));
                    }
                    catch (Exception exception) {
                        none$ = None$.MODULE$;
                    }
                    return none$;
                }, List$.MODULE$.canBuildFrom())).find((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.nonEmpty())).flatten(Predef$.MODULE$.$conforms());
                return parsedOptions.getOrElse((Function0 & Serializable & scala.Serializable)() -> s);
            });
        }
        catch (Exception exception) {
            object = s;
        }
        return object;
    }

    private List<String> datePatters$lzycompute() {
        LuceneQueryConverter$ luceneQueryConverter$ = this;
        synchronized (luceneQueryConverter$) {
            if (!this.bitmap$0) {
                this.datePatters = List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"yyyyMMdd'T'HHmmssSSSZZ", "yyyyMMdd'T'HHmmssZZ", "yyyyMMdd'T'HHmmZZ", "yyyyMMdd'T'HHmmssSSS", "yyyyMMdd'T'HHmmss", "yyyyMMdd'T'HHmm", "yyyy-MM-dd'T'HH:mm:ss.SSSZZ", "yyyy-MM-dd'T'HH:mm:ssZZ", "yyyy-MM-dd'T'HH:mmZZ", "yyyy-MM-dd'T'HH:mm:ss.SSS", "yyyy-MM-dd'T'HH:mm:ss", "yyyy-MM-dd'T'HH:mm"}));
                this.bitmap$0 = true;
            }
        }
        return this.datePatters;
    }

    private List<String> datePatters() {
        if (!this.bitmap$0) {
            return this.datePatters$lzycompute();
        }
        return this.datePatters;
    }

    public static final /* synthetic */ void $anonfun$appendBooleanQueryToSearchMap$1(BooleanRef nextTypeAnd$1, ArrayBuffer listOfAnd$1, ArrayBuffer listOfOr$1, BooleanClause c) {
        Map<String, Object> queryMap = MODULE$.getMongoDbSearchMap(c.getQuery(), c.isProhibited());
        boolean thisTypeAnd = true;
        BooleanClause.Occur occur = c.getOccur();
        BooleanClause.Occur occur2 = BooleanClause.Occur.MUST;
        if (!(occur != null ? !occur.equals(occur2) : occur2 != null)) {
            thisTypeAnd = true;
        } else {
            BooleanClause.Occur occur3 = c.getOccur();
            BooleanClause.Occur occur4 = BooleanClause.Occur.SHOULD;
            if (!(occur3 != null ? !occur3.equals(occur4) : occur4 != null)) {
                thisTypeAnd = false;
            } else {
                BooleanClause.Occur occur5 = c.getOccur();
                BooleanClause.Occur occur6 = BooleanClause.Occur.MUST_NOT;
                if (occur5 == null ? occur6 != null : !occur5.equals(occur6)) {
                    BoxedUnit boxedUnit;
                    if (MODULE$.logger().underlying().isErrorEnabled()) {
                        MODULE$.logger().underlying().error("Unexpected Occur <{}>", new Object[]{c.getOccur().name()});
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    throw new NotSupportedException(new StringBuilder(24).append(c.getOccur().name()).append(" currently not supported").toString());
                }
            }
        }
        ArrayBuffer arrayBuffer = nextTypeAnd$1.elem && thisTypeAnd ? listOfAnd$1.$plus$eq(queryMap) : listOfOr$1.$plus$eq(queryMap);
        nextTypeAnd$1.elem = thisTypeAnd;
    }

    private static final Option checkOrReturn$1(Function0 f, String s$1) {
        None$ none$;
        block3: {
            try {
                Object value = f.apply();
                if (value.toString().equals(s$1)) {
                    none$ = Option$.MODULE$.apply(value);
                    break block3;
                }
                none$ = None$.MODULE$;
            }
            catch (Exception e) {
                none$ = None$.MODULE$;
            }
        }
        return none$;
    }

    private LuceneQueryConverter$() {
        MODULE$ = this;
        LazyLogging.$init$((LazyLogging)this);
    }
}

