/*
 * Decompiled with CFR 0.152.
 */
package dev.monosoul.jooq.container;

import dev.monosoul.jooq.settings.Database;
import dev.monosoul.jooq.settings.Image;
import dev.monosoul.jooq.shadow.org.jetbrains.annotations.NotNull;
import dev.monosoul.jooq.shadow.org.jetbrains.annotations.Nullable;
import dev.monosoul.jooq.shadow.org.testcontainers.containers.JdbcDatabaseContainer;
import dev.monosoul.jooq.shadow.org.testcontainers.containers.output.Slf4jLogConsumer;
import dev.monosoul.jooq.shadow.org.testcontainers.containers.wait.strategy.HostPortWaitStrategy;
import dev.monosoul.jooq.shadow.org.testcontainers.utility.DockerImageName;
import java.sql.Driver;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u000eH\u0016J\b\u0010\u0010\u001a\u00020\nH\u0016J\b\u0010\u0011\u001a\u00020\u000eH\u0016J\b\u0010\u0012\u001a\u00020\nH\u0002J\b\u0010\u0013\u001a\u00020\u000eH\u0016J\b\u0010\u0014\u001a\u00020\u000eH\u0014J\b\u0010\u0015\u001a\u00020\u000eH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Ldev/monosoul/jooq/container/GenericDatabaseContainer;", "Ldev/monosoul/jooq/shadow/org/testcontainers/containers/JdbcDatabaseContainer;", "image", "Ldev/monosoul/jooq/settings/Image;", "database", "Ldev/monosoul/jooq/settings/Database$Internal;", "jdbcAwareClassLoader", "Ljava/lang/ClassLoader;", "(Ldev/monosoul/jooq/settings/Image;Ldev/monosoul/jooq/settings/Database$Internal;Ljava/lang/ClassLoader;)V", "driver", "Ljava/sql/Driver;", "driverLoadLock", "Ljava/util/concurrent/locks/ReentrantLock;", "getDatabaseName", "", "getDriverClassName", "getJdbcDriverInstance", "getJdbcUrl", "getNewJdbcDriverInstance", "getPassword", "getTestQueryString", "getUsername", "jooq-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nGenericDatabaseContainer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GenericDatabaseContainer.kt\ndev/monosoul/jooq/container/GenericDatabaseContainer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,71:1\n1#2:72\n*E\n"})
public final class GenericDatabaseContainer
extends JdbcDatabaseContainer<GenericDatabaseContainer> {
    @NotNull
    private final Image image;
    @NotNull
    private final Database.Internal database;
    @NotNull
    private final ClassLoader jdbcAwareClassLoader;
    @NotNull
    private final ReentrantLock driverLoadLock;
    @Nullable
    private Driver driver;

    public GenericDatabaseContainer(@NotNull Image image, @NotNull Database.Internal database, @NotNull ClassLoader jdbcAwareClassLoader) {
        block0: {
            String string;
            Intrinsics.checkNotNullParameter((Object)image, (String)"image");
            Intrinsics.checkNotNullParameter((Object)database, (String)"database");
            Intrinsics.checkNotNullParameter((Object)jdbcAwareClassLoader, (String)"jdbcAwareClassLoader");
            super(DockerImageName.parse(image.getName()));
            this.image = image;
            this.database = database;
            this.jdbcAwareClassLoader = jdbcAwareClassLoader;
            this.driverLoadLock = new ReentrantLock();
            this.withLogConsumer((Consumer)new Slf4jLogConsumer(LoggerFactory.getLogger((String)("JooqGenerationDb[" + this.getDockerImageName() + ']'))));
            this.withEnv((Map)this.image.getEnvVars());
            Integer[] integerArray = new Integer[]{this.database.getPort()};
            this.withExposedPorts(integerArray);
            this.setWaitStrategy(new HostPortWaitStrategy());
            String it = string = this.image.getCommand();
            boolean bl = false;
            CharSequence charSequence = it;
            String string2 = !(charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) ? string : null;
            if (string2 == null) break block0;
            String p0 = string2;
            boolean bl2 = false;
            GenericDatabaseContainer cfr_ignored_0 = (GenericDatabaseContainer)this.withCommand(p0);
        }
    }

    @Override
    @NotNull
    public String getDriverClassName() {
        return this.database.getJdbc$jooq_gradle_plugin().getDriverClassName();
    }

    @Override
    @NotNull
    public String getJdbcUrl() {
        String string = this.getHost();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"host");
        Integer n = this.getMappedPort(this.database.getPort());
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getMappedPort(database.port)");
        return this.database.getJdbcUrl$jooq_gradle_plugin(string, ((Number)n).intValue());
    }

    @Override
    @NotNull
    public String getUsername() {
        return this.database.getUsername();
    }

    @Override
    @NotNull
    public String getPassword() {
        return this.database.getPassword();
    }

    @Override
    @NotNull
    protected String getTestQueryString() {
        return this.image.getTestQuery();
    }

    @Override
    @NotNull
    public String getDatabaseName() {
        return this.database.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Driver getJdbcDriverInstance() {
        if (this.driver == null) {
            Lock lock = this.driverLoadLock;
            lock.lock();
            try {
                boolean bl = false;
                if (this.driver == null) {
                    this.driver = this.getNewJdbcDriverInstance();
                }
                Unit unit = Unit.INSTANCE;
            }
            finally {
                lock.unlock();
            }
        }
        Driver driver = this.driver;
        Intrinsics.checkNotNull((Object)driver);
        return driver;
    }

    private final Driver getNewJdbcDriverInstance() {
        Driver driver;
        try {
            Object obj = this.jdbcAwareClassLoader.loadClass(this.getDriverClassName()).newInstance();
            Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type java.sql.Driver");
            driver = (Driver)obj;
        }
        catch (Exception e) {
            Exception exception = e;
            if ((exception instanceof InstantiationException ? true : exception instanceof IllegalAccessException) ? true : exception instanceof ClassNotFoundException) {
                throw new JdbcDatabaseContainer.NoDriverFoundException("Could not get Driver", e);
            }
            throw e;
        }
        return driver;
    }
}

