/*
 * Decompiled with CFR 0.152.
 */
package dev.monosoul.jooq.shadow.com.github.dockerjava.api.model;

import dev.monosoul.jooq.shadow.com.github.dockerjava.api.model.AccessMode;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.model.DockerObject;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.model.PropagationMode;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.model.SELContext;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.model.Volume;
import java.io.Serializable;

public class Bind
extends DockerObject
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String path;
    private Volume volume;
    private AccessMode accessMode;
    private Boolean noCopy;
    private SELContext secMode;
    private PropagationMode propagationMode;

    public Bind(String path, Volume volume) {
        this(path, volume, AccessMode.DEFAULT, SELContext.DEFAULT);
    }

    public Bind(String path, Volume volume, Boolean noCopy) {
        this(path, volume, AccessMode.DEFAULT, SELContext.DEFAULT, noCopy);
    }

    public Bind(String path, Volume volume, AccessMode accessMode) {
        this(path, volume, accessMode, SELContext.DEFAULT);
    }

    public Bind(String path, Volume volume, AccessMode accessMode, SELContext secMode) {
        this(path, volume, accessMode, secMode, null);
    }

    public Bind(String path, Volume volume, AccessMode accessMode, SELContext secMode, Boolean noCopy) {
        this(path, volume, accessMode, secMode, noCopy, PropagationMode.DEFAULT_MODE);
    }

    public Bind(String path, Volume volume, AccessMode accessMode, SELContext secMode, Boolean noCopy, PropagationMode propagationMode) {
        this.path = path;
        this.volume = volume;
        this.accessMode = accessMode;
        this.secMode = secMode;
        this.noCopy = noCopy;
        this.propagationMode = propagationMode;
    }

    public String getPath() {
        return this.path;
    }

    public Volume getVolume() {
        return this.volume;
    }

    public AccessMode getAccessMode() {
        return this.accessMode;
    }

    public SELContext getSecMode() {
        return this.secMode;
    }

    public Boolean getNoCopy() {
        return this.noCopy;
    }

    public PropagationMode getPropagationMode() {
        return this.propagationMode;
    }

    public static Bind parse(String serialized) {
        try {
            String[] parts = serialized.split(":(?!\\\\)");
            switch (parts.length) {
                case 2: {
                    return new Bind(parts[0], new Volume(parts[1]));
                }
                case 3: {
                    String[] flags = parts[2].split(",");
                    AccessMode accessMode = AccessMode.DEFAULT;
                    SELContext seMode = SELContext.DEFAULT;
                    Boolean nocopy = null;
                    PropagationMode propagationMode = PropagationMode.DEFAULT_MODE;
                    for (String p : flags) {
                        if (p.length() == 2) {
                            accessMode = AccessMode.valueOf(p.toLowerCase());
                            continue;
                        }
                        if ("nocopy".equals(p)) {
                            nocopy = true;
                            continue;
                        }
                        if (PropagationMode.SHARED.toString().equals(p)) {
                            propagationMode = PropagationMode.SHARED;
                            continue;
                        }
                        if (PropagationMode.SLAVE.toString().equals(p)) {
                            propagationMode = PropagationMode.SLAVE;
                            continue;
                        }
                        if (PropagationMode.PRIVATE.toString().equals(p)) {
                            propagationMode = PropagationMode.PRIVATE;
                            continue;
                        }
                        seMode = SELContext.fromString(p);
                    }
                    return new Bind(parts[0], new Volume(parts[1]), accessMode, seMode, nocopy, propagationMode);
                }
            }
            throw new IllegalArgumentException();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error parsing Bind '" + serialized + "'", e);
        }
    }

    public String toString() {
        return String.format("%s:%s:%s%s%s%s", this.path, this.volume.getPath(), this.accessMode.toString(), this.secMode != SELContext.none ? "," + this.secMode.toString() : "", this.noCopy != null ? ",nocopy" : "", this.propagationMode != PropagationMode.DEFAULT_MODE ? "," + this.propagationMode.toString() : "");
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Bind)) {
            return false;
        }
        Bind other = (Bind)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$noCopy = this.getNoCopy();
        Boolean other$noCopy = other.getNoCopy();
        if (this$noCopy == null ? other$noCopy != null : !((Object)this$noCopy).equals(other$noCopy)) {
            return false;
        }
        String this$path = this.getPath();
        String other$path = other.getPath();
        if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
            return false;
        }
        Volume this$volume = this.getVolume();
        Volume other$volume = other.getVolume();
        if (this$volume == null ? other$volume != null : !((Object)this$volume).equals(other$volume)) {
            return false;
        }
        AccessMode this$accessMode = this.getAccessMode();
        AccessMode other$accessMode = other.getAccessMode();
        if (this$accessMode == null ? other$accessMode != null : !((Object)((Object)this$accessMode)).equals((Object)other$accessMode)) {
            return false;
        }
        SELContext this$secMode = this.getSecMode();
        SELContext other$secMode = other.getSecMode();
        if (this$secMode == null ? other$secMode != null : !((Object)((Object)this$secMode)).equals((Object)other$secMode)) {
            return false;
        }
        PropagationMode this$propagationMode = this.getPropagationMode();
        PropagationMode other$propagationMode = other.getPropagationMode();
        return !(this$propagationMode == null ? other$propagationMode != null : !((Object)((Object)this$propagationMode)).equals((Object)other$propagationMode));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Bind;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $noCopy = this.getNoCopy();
        result = result * 59 + ($noCopy == null ? 43 : ((Object)$noCopy).hashCode());
        String $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        Volume $volume = this.getVolume();
        result = result * 59 + ($volume == null ? 43 : ((Object)$volume).hashCode());
        AccessMode $accessMode = this.getAccessMode();
        result = result * 59 + ($accessMode == null ? 43 : ((Object)((Object)$accessMode)).hashCode());
        SELContext $secMode = this.getSecMode();
        result = result * 59 + ($secMode == null ? 43 : ((Object)((Object)$secMode)).hashCode());
        PropagationMode $propagationMode = this.getPropagationMode();
        result = result * 59 + ($propagationMode == null ? 43 : ((Object)((Object)$propagationMode)).hashCode());
        return result;
    }
}

