/*
 * Decompiled with CFR 0.152.
 */
package dev.monosoul.jooq.shadow.com.github.dockerjava.transport;

import dev.monosoul.jooq.shadow.com.github.dockerjava.transport.AbstractSocket;
import dev.monosoul.jooq.shadow.com.github.dockerjava.transport.DomainSocket;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.SocketChannel;
import java.nio.channels.WritableByteChannel;

public class UnixSocket
extends AbstractSocket {
    private final SocketAddress socketAddress;
    private final SocketChannel socketChannel;

    public static Socket get(String path) throws IOException {
        try {
            return new UnixSocket(path);
        }
        catch (Exception e) {
            return DomainSocket.get(path);
        }
    }

    private UnixSocket(String path) throws Exception {
        Class<?> unixDomainSocketAddress = Class.forName("java.net.UnixDomainSocketAddress");
        this.socketAddress = (SocketAddress)unixDomainSocketAddress.getMethod("of", String.class).invoke(null, path);
        this.socketChannel = SocketChannel.open(this.socketAddress);
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (!this.isConnected()) {
            throw new SocketException("Socket is not connected");
        }
        if (this.isInputShutdown()) {
            throw new SocketException("Socket input is shutdown");
        }
        return Channels.newInputStream(this.socketChannel);
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        if (this.isClosed()) {
            throw new SocketException("Socket is closed");
        }
        if (!this.isConnected()) {
            throw new SocketException("Socket is not connected");
        }
        if (this.isOutputShutdown()) {
            throw new SocketException("Socket output is shutdown");
        }
        return Channels.newOutputStream(new WrappedWritableByteChannel());
    }

    @Override
    public SocketAddress getLocalSocketAddress() {
        return this.socketAddress;
    }

    @Override
    public SocketAddress getRemoteSocketAddress() {
        return this.socketAddress;
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.socketChannel.close();
    }

    private class WrappedWritableByteChannel
    implements WritableByteChannel {
        private WrappedWritableByteChannel() {
        }

        @Override
        public int write(ByteBuffer src) throws IOException {
            return UnixSocket.this.socketChannel.write(src);
        }

        @Override
        public boolean isOpen() {
            return UnixSocket.this.socketChannel.isOpen();
        }

        @Override
        public void close() throws IOException {
            UnixSocket.this.socketChannel.close();
        }
    }
}

