/*
 * Decompiled with CFR 0.152.
 */
package dev.monosoul.jooq.shadow.com.github.dockerjava.zerodep.shaded.org.apache.hc.client5.http.protocol;

import dev.monosoul.jooq.shadow.com.github.dockerjava.zerodep.shaded.org.apache.hc.client5.http.RouteInfo;
import dev.monosoul.jooq.shadow.com.github.dockerjava.zerodep.shaded.org.apache.hc.client5.http.protocol.HttpClientContext;
import dev.monosoul.jooq.shadow.com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.annotation.Contract;
import dev.monosoul.jooq.shadow.com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.annotation.ThreadingBehavior;
import dev.monosoul.jooq.shadow.com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.http.EntityDetails;
import dev.monosoul.jooq.shadow.com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.http.HttpException;
import dev.monosoul.jooq.shadow.com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.http.HttpRequest;
import dev.monosoul.jooq.shadow.com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.http.HttpRequestInterceptor;
import dev.monosoul.jooq.shadow.com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.http.protocol.HttpContext;
import dev.monosoul.jooq.shadow.com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.util.Args;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Contract(threading=ThreadingBehavior.STATELESS)
public class RequestClientConnControl
implements HttpRequestInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(RequestClientConnControl.class);

    @Override
    public void process(HttpRequest request, EntityDetails entity, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        String method = request.getMethod();
        if (method.equalsIgnoreCase("CONNECT")) {
            return;
        }
        HttpClientContext clientContext = HttpClientContext.adapt(context);
        RouteInfo route = clientContext.getHttpRoute();
        if (route == null) {
            LOG.debug("Connection route not set in the context");
            return;
        }
        if ((route.getHopCount() == 1 || route.isTunnelled()) && !request.containsHeader("Connection")) {
            request.addHeader("Connection", "keep-alive");
        }
    }
}

