/*
 * Decompiled with CFR 0.152.
 */
package dev.monosoul.jooq.shadow.com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.http.io.entity;

import dev.monosoul.jooq.shadow.com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.annotation.Contract;
import dev.monosoul.jooq.shadow.com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.annotation.ThreadingBehavior;
import dev.monosoul.jooq.shadow.com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.http.ContentType;
import dev.monosoul.jooq.shadow.com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.http.impl.io.EmptyInputStream;
import dev.monosoul.jooq.shadow.com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.http.io.entity.AbstractHttpEntity;
import dev.monosoul.jooq.shadow.com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.io.Closer;
import dev.monosoul.jooq.shadow.com.github.dockerjava.zerodep.shaded.org.apache.hc.core5.util.Args;
import java.io.IOException;
import java.io.InputStream;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class BasicHttpEntity
extends AbstractHttpEntity {
    private final InputStream content;
    private final long length;

    public BasicHttpEntity(InputStream content, long length, ContentType contentType, String contentEncoding, boolean chunked) {
        super(contentType, contentEncoding, chunked);
        this.content = Args.notNull(content, "Content stream");
        this.length = length;
    }

    public BasicHttpEntity(InputStream content, long length, ContentType contentType, String contentEncoding) {
        this(content, length, contentType, contentEncoding, false);
    }

    public BasicHttpEntity(InputStream content, long length, ContentType contentType) {
        this(content, length, contentType, null);
    }

    public BasicHttpEntity(InputStream content, ContentType contentType, String contentEncoding) {
        this(content, -1L, contentType, contentEncoding);
    }

    public BasicHttpEntity(InputStream content, ContentType contentType) {
        this(content, -1L, contentType, null);
    }

    public BasicHttpEntity(InputStream content, ContentType contentType, boolean chunked) {
        this(content, -1L, contentType, null, chunked);
    }

    @Override
    public final long getContentLength() {
        return this.length;
    }

    @Override
    public final InputStream getContent() throws IllegalStateException {
        return this.content;
    }

    @Override
    public final boolean isRepeatable() {
        return false;
    }

    @Override
    public final boolean isStreaming() {
        return this.content != null && this.content != EmptyInputStream.INSTANCE;
    }

    @Override
    public final void close() throws IOException {
        Closer.close(this.content);
    }
}

