/*
 * Decompiled with CFR 0.152.
 */
package dev.monosoul.jooq.shadow.org.junit.runner.manipulation;

import dev.monosoul.jooq.shadow.org.junit.runner.Description;
import dev.monosoul.jooq.shadow.org.junit.runner.manipulation.InvalidOrderingException;
import dev.monosoul.jooq.shadow.org.junit.runner.manipulation.Orderable;
import dev.monosoul.jooq.shadow.org.junit.runner.manipulation.Ordering;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Orderer {
    private final Ordering ordering;

    Orderer(Ordering delegate) {
        this.ordering = delegate;
    }

    public List<Description> order(Collection<Description> descriptions) throws InvalidOrderingException {
        List<Description> inOrder = this.ordering.orderItems(Collections.unmodifiableCollection(descriptions));
        if (!this.ordering.validateOrderingIsCorrect()) {
            return inOrder;
        }
        HashSet<Description> uniqueDescriptions = new HashSet<Description>(descriptions);
        if (!uniqueDescriptions.containsAll(inOrder)) {
            throw new InvalidOrderingException("Ordering added items");
        }
        HashSet<Description> resultAsSet = new HashSet<Description>(inOrder);
        if (resultAsSet.size() != inOrder.size()) {
            throw new InvalidOrderingException("Ordering duplicated items");
        }
        if (!resultAsSet.containsAll(uniqueDescriptions)) {
            throw new InvalidOrderingException("Ordering removed items");
        }
        return inOrder;
    }

    public void apply(Object target) throws InvalidOrderingException {
        if (target instanceof Orderable) {
            Orderable orderable = (Orderable)target;
            orderable.order(this);
        }
    }
}

