/*
 * Decompiled with CFR 0.152.
 */
package dev.monosoul.jooq.shadow.org.testcontainers.containers;

import dev.monosoul.jooq.shadow.org.testcontainers.containers.ParsedDockerComposeFile;
import dev.monosoul.jooq.shadow.org.testcontainers.utility.DockerImageName;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class DockerComposeFiles {
    private final List<ParsedDockerComposeFile> parsedComposeFiles;

    public DockerComposeFiles(List<File> composeFiles) {
        this.parsedComposeFiles = composeFiles.stream().map(ParsedDockerComposeFile::new).collect(Collectors.toList());
    }

    public Set<String> getDependencyImages() {
        Map<String, Set<String>> mergedServiceNameToImageNames = this.mergeServiceDependencyImageNames();
        return this.getImageNames(mergedServiceNameToImageNames);
    }

    private Map<String, Set<String>> mergeServiceDependencyImageNames() {
        HashMap<String, Set<String>> mergedServiceNameToImageNames = new HashMap<String, Set<String>>();
        for (ParsedDockerComposeFile parsedComposeFile : this.parsedComposeFiles) {
            mergedServiceNameToImageNames.putAll(parsedComposeFile.getServiceNameToImageNames());
        }
        return mergedServiceNameToImageNames;
    }

    private Set<String> getImageNames(Map<String, Set<String>> serviceToImageNames) {
        return serviceToImageNames.values().stream().flatMap(Collection::stream).map(DockerImageName::parse).map(DockerImageName::asCanonicalNameString).collect(Collectors.toSet());
    }
}

