/*
 * Decompiled with CFR 0.152.
 */
package dev.monosoul.jooq.shadow.org.testcontainers.containers;

import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.InspectContainerResponse;
import dev.monosoul.jooq.shadow.org.jetbrains.annotations.NotNull;
import dev.monosoul.jooq.shadow.org.jetbrains.annotations.Nullable;
import dev.monosoul.jooq.shadow.org.testcontainers.containers.GenericContainer;
import dev.monosoul.jooq.shadow.org.testcontainers.containers.traits.LinkableContainer;
import dev.monosoul.jooq.shadow.org.testcontainers.delegate.DatabaseDelegate;
import dev.monosoul.jooq.shadow.org.testcontainers.ext.ScriptUtils;
import dev.monosoul.jooq.shadow.org.testcontainers.jdbc.JdbcDatabaseDelegate;
import dev.monosoul.jooq.shadow.org.testcontainers.utility.DockerImageName;
import dev.monosoul.jooq.shadow.org.testcontainers.utility.MountableFile;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import lombok.NonNull;

public abstract class JdbcDatabaseContainer<SELF extends JdbcDatabaseContainer<SELF>>
extends GenericContainer<SELF>
implements LinkableContainer {
    private static final Object DRIVER_LOAD_MUTEX = new Object();
    private Driver driver;
    private String initScriptPath;
    protected Map<String, String> parameters = new HashMap<String, String>();
    protected Map<String, String> urlParameters = new HashMap<String, String>();
    private int startupTimeoutSeconds = 120;
    private int connectTimeoutSeconds = 120;
    private static final String QUERY_PARAM_SEPARATOR = "&";

    public JdbcDatabaseContainer(@NonNull String dockerImageName) {
        this(DockerImageName.parse(dockerImageName));
        if (dockerImageName == null) {
            throw new NullPointerException("dockerImageName is marked non-null but is null");
        }
    }

    public JdbcDatabaseContainer(@NonNull Future<String> image) {
        super(image);
        if (image == null) {
            throw new NullPointerException("image is marked non-null but is null");
        }
    }

    public JdbcDatabaseContainer(DockerImageName dockerImageName) {
        super(dockerImageName);
    }

    public abstract String getDriverClassName();

    public abstract String getJdbcUrl();

    public String getDatabaseName() {
        throw new UnsupportedOperationException();
    }

    public abstract String getUsername();

    public abstract String getPassword();

    protected abstract String getTestQueryString();

    public SELF withUsername(String username) {
        throw new UnsupportedOperationException();
    }

    public SELF withPassword(String password) {
        throw new UnsupportedOperationException();
    }

    public SELF withDatabaseName(String dbName) {
        throw new UnsupportedOperationException();
    }

    public SELF withUrlParam(String paramName, String paramValue) {
        this.urlParameters.put(paramName, paramValue);
        return (SELF)((JdbcDatabaseContainer)this.self());
    }

    public SELF withStartupTimeoutSeconds(int startupTimeoutSeconds) {
        this.startupTimeoutSeconds = startupTimeoutSeconds;
        return (SELF)((JdbcDatabaseContainer)this.self());
    }

    public SELF withConnectTimeoutSeconds(int connectTimeoutSeconds) {
        this.connectTimeoutSeconds = connectTimeoutSeconds;
        return (SELF)((JdbcDatabaseContainer)this.self());
    }

    public SELF withInitScript(String initScriptPath) {
        this.initScriptPath = initScriptPath;
        return (SELF)((JdbcDatabaseContainer)this.self());
    }

    @Override
    protected void waitUntilContainerStarted() {
        this.logger().info("Waiting for database connection to become available at {} using query '{}'", (Object)this.getJdbcUrl(), (Object)this.getTestQueryString());
        long start = System.currentTimeMillis();
        Exception lastConnectionException = null;
        while (System.currentTimeMillis() < start + (long)(1000 * this.startupTimeoutSeconds)) {
            if (!this.isRunning()) {
                Thread.sleep(100L);
                continue;
            }
            try {
                Connection connection = this.createConnection("");
                Throwable throwable = null;
                try {
                    Statement statement = connection.createStatement();
                    Throwable throwable2 = null;
                    try {
                        boolean testQuerySucceeded = statement.execute(this.getTestQueryString());
                        if (!testQuerySucceeded) continue;
                        return;
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (statement == null) continue;
                        if (throwable2 != null) {
                            try {
                                statement.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        statement.close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (connection == null) continue;
                    if (throwable != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    connection.close();
                }
            }
            catch (NoDriverFoundException e) {
                throw e;
            }
            catch (Exception e) {
                lastConnectionException = e;
                this.logger().debug("Failure when trying test query", (Throwable)e);
                Thread.sleep(100L);
            }
        }
        throw new IllegalStateException(String.format("Container is started, but cannot be accessed by (JDBC URL: %s), please check container logs", this.getJdbcUrl()), lastConnectionException);
    }

    @Override
    protected void containerIsStarted(InspectContainerResponse containerInfo) {
        this.logger().info("Container is started (JDBC URL: {})", (Object)this.getJdbcUrl());
        this.runInitScriptIfRequired();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Driver getJdbcDriverInstance() throws NoDriverFoundException {
        Object object = DRIVER_LOAD_MUTEX;
        synchronized (object) {
            if (this.driver == null) {
                try {
                    this.driver = (Driver)Class.forName(this.getDriverClassName()).newInstance();
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                    throw new NoDriverFoundException("Could not get Driver", e);
                }
            }
        }
        return this.driver;
    }

    public Connection createConnection(String queryString) throws SQLException, NoDriverFoundException {
        return this.createConnection(queryString, new Properties());
    }

    public Connection createConnection(String queryString, Properties info) throws SQLException, NoDriverFoundException {
        Properties properties = new Properties(info);
        properties.put("user", this.getUsername());
        properties.put("password", this.getPassword());
        String url = this.constructUrlForConnection(queryString);
        Driver jdbcDriverInstance = this.getJdbcDriverInstance();
        SQLException lastException = null;
        try {
            long start = System.currentTimeMillis();
            while (System.currentTimeMillis() < start + (long)(1000 * this.connectTimeoutSeconds) && this.isRunning()) {
                try {
                    this.logger().debug("Trying to create JDBC connection using {} to {} with properties: {}", new Object[]{jdbcDriverInstance.getClass().getName(), url, properties});
                    return jdbcDriverInstance.connect(url, properties);
                }
                catch (SQLException e) {
                    lastException = e;
                    Thread.sleep(100L);
                }
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        throw new SQLException("Could not create new connection", lastException);
    }

    protected String constructUrlForConnection(String queryString) {
        String baseUrl = this.getJdbcUrl();
        if ("".equals(queryString)) {
            return baseUrl;
        }
        if (!queryString.startsWith("?")) {
            throw new IllegalArgumentException("The '?' character must be included");
        }
        return baseUrl.contains("?") ? baseUrl + QUERY_PARAM_SEPARATOR + queryString.substring(1) : baseUrl + queryString;
    }

    protected String constructUrlParameters(String startCharacter, String delimiter) {
        return this.constructUrlParameters(startCharacter, delimiter, "");
    }

    protected String constructUrlParameters(String startCharacter, String delimiter, String endCharacter) {
        String urlParameters = "";
        if (!this.urlParameters.isEmpty()) {
            String additionalParameters = this.urlParameters.entrySet().stream().map(Object::toString).collect(Collectors.joining(delimiter));
            urlParameters = startCharacter + additionalParameters + endCharacter;
        }
        return urlParameters;
    }

    @Deprecated
    protected void optionallyMapResourceParameterAsVolume(@NotNull String paramName, @NotNull String pathNameInContainer, @NotNull String defaultResource) {
        this.optionallyMapResourceParameterAsVolume(paramName, pathNameInContainer, defaultResource, null);
    }

    protected void optionallyMapResourceParameterAsVolume(@NotNull String paramName, @NotNull String pathNameInContainer, @NotNull String defaultResource, @Nullable Integer fileMode) {
        String resourceName = this.parameters.getOrDefault(paramName, defaultResource);
        if (resourceName != null) {
            MountableFile mountableFile = MountableFile.forClasspathResource(resourceName, fileMode);
            this.withCopyFileToContainer(mountableFile, pathNameInContainer);
        }
    }

    protected void runInitScriptIfRequired() {
        if (this.initScriptPath != null) {
            ScriptUtils.runInitScript(this.getDatabaseDelegate(), this.initScriptPath);
        }
    }

    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    public void addParameter(String paramName, String value) {
        this.parameters.put(paramName, value);
    }

    @Deprecated
    protected int getStartupTimeoutSeconds() {
        return this.startupTimeoutSeconds;
    }

    @Deprecated
    protected int getConnectTimeoutSeconds() {
        return this.connectTimeoutSeconds;
    }

    protected DatabaseDelegate getDatabaseDelegate() {
        return new JdbcDatabaseDelegate(this, "");
    }

    public static class NoDriverFoundException
    extends RuntimeException {
        public NoDriverFoundException(String message, Throwable e) {
            super(message, e);
        }
    }
}

