/*
 * Decompiled with CFR 0.152.
 */
package dev.monosoul.jooq.shadow.org.testcontainers.containers;

import dev.monosoul.jooq.shadow.com.github.dockerjava.transport.SSLConfig;
import dev.monosoul.jooq.shadow.org.testcontainers.DockerClientFactory;
import dev.monosoul.jooq.shadow.org.testcontainers.containers.ContainerLaunchException;
import dev.monosoul.jooq.shadow.org.testcontainers.containers.DockerCompose;
import dev.monosoul.jooq.shadow.org.testcontainers.dockerclient.TransportConfig;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.com.github.dockerjava.core.LocalDirectorySSLConfig;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.com.google.common.base.Splitter;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.com.google.common.collect.Maps;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.zeroturnaround.exec.InvalidExitValueException;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.zeroturnaround.exec.ProcessExecutor;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.zeroturnaround.exec.stream.slf4j.Slf4jStream;
import dev.monosoul.jooq.shadow.org.testcontainers.utility.CommandLine;
import dev.monosoul.jooq.shadow.org.testcontainers.utility.DockerLoggerFactory;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;

class LocalDockerCompose
implements DockerCompose {
    private final List<File> composeFiles;
    private final String identifier;
    private String cmd = "";
    private Map<String, String> env = new HashMap<String, String>();
    private final String composeExecutable;

    public LocalDockerCompose(String composeExecutable, List<File> composeFiles, String identifier) {
        this.composeExecutable = composeExecutable;
        this.composeFiles = composeFiles;
        this.identifier = identifier;
    }

    @Override
    public DockerCompose withCommand(String cmd) {
        this.cmd = cmd;
        return this;
    }

    @Override
    public DockerCompose withEnv(Map<String, String> env) {
        this.env = env;
        return this;
    }

    @Override
    public void invoke() {
        if (!CommandLine.executableExists(this.composeExecutable)) {
            throw new ContainerLaunchException("Local Docker Compose not found. Is " + this.composeExecutable + " on the PATH?");
        }
        HashMap<String, String> environment = Maps.newHashMap(this.env);
        environment.put("COMPOSE_PROJECT_NAME", this.identifier);
        TransportConfig transportConfig = DockerClientFactory.instance().getTransportConfig();
        SSLConfig sslConfig = transportConfig.getSslConfig();
        if (sslConfig != null) {
            if (sslConfig instanceof LocalDirectorySSLConfig) {
                environment.put("DOCKER_CERT_PATH", ((LocalDirectorySSLConfig)sslConfig).getDockerCertPath());
                environment.put("DOCKER_TLS_VERIFY", "true");
            } else {
                this.logger().warn("Couldn't set DOCKER_CERT_PATH. `sslConfig` is present but it's not LocalDirectorySSLConfig.");
            }
        }
        String dockerHost = transportConfig.getDockerHost().toString();
        environment.put("DOCKER_HOST", dockerHost);
        Stream<String> absoluteDockerComposeFilePaths = this.composeFiles.stream().map(File::getAbsolutePath).map(Objects::toString);
        String composeFileEnvVariableValue = absoluteDockerComposeFilePaths.collect(Collectors.joining(File.pathSeparator + ""));
        this.logger().debug("Set env COMPOSE_FILE={}", (Object)composeFileEnvVariableValue);
        File pwd = this.composeFiles.get(0).getAbsoluteFile().getParentFile().getAbsoluteFile();
        environment.put("COMPOSE_FILE", composeFileEnvVariableValue);
        this.logger().info("Local Docker Compose is running command: {}", (Object)this.cmd);
        List<String> command = Splitter.onPattern(" ").omitEmptyStrings().splitToList(this.composeExecutable + " " + this.cmd);
        try {
            new ProcessExecutor().command(command).redirectOutput(Slf4jStream.of(this.logger()).asInfo()).redirectError(Slf4jStream.of(this.logger()).asInfo()).environment(environment).directory(pwd).exitValueNormal().executeNoTimeout();
            this.logger().info("Docker Compose has finished running");
        }
        catch (InvalidExitValueException e) {
            throw new ContainerLaunchException("Local Docker Compose exited abnormally with code " + e.getExitValue() + " whilst running command: " + this.cmd);
        }
        catch (Exception e) {
            throw new ContainerLaunchException("Error running local Docker Compose command: " + this.cmd, e);
        }
    }

    private Logger logger() {
        return DockerLoggerFactory.getLogger(this.composeExecutable);
    }
}

