/*
 * Decompiled with CFR 0.152.
 */
package dev.monosoul.jooq.shadow.org.testcontainers.containers;

import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.CreateNetworkCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.CreateNetworkResponse;
import dev.monosoul.jooq.shadow.org.junit.rules.ExternalResource;
import dev.monosoul.jooq.shadow.org.junit.rules.TestRule;
import dev.monosoul.jooq.shadow.org.testcontainers.DockerClientFactory;
import dev.monosoul.jooq.shadow.org.testcontainers.utility.ResourceReaper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;

public interface Network
extends AutoCloseable,
TestRule {
    public static final Network SHARED = new NetworkImpl((Boolean)false, null, Collections.emptySet(), null){

        @Override
        public void close() {
        }
    };

    public String getId();

    @Override
    public void close();

    public static Network newNetwork() {
        return Network.builder().build();
    }

    public static NetworkImpl.NetworkImplBuilder builder() {
        return NetworkImpl.builder();
    }

    public static class NetworkImpl
    extends ExternalResource
    implements Network {
        private final String name = UUID.randomUUID().toString();
        private Boolean enableIpv6;
        private String driver;
        private Set<Consumer<CreateNetworkCmd>> createNetworkCmdModifiers;
        @Deprecated
        private String id;
        private final AtomicBoolean initialized = new AtomicBoolean();

        @Override
        public synchronized String getId() {
            if (this.initialized.compareAndSet(false, true)) {
                boolean success = false;
                try {
                    this.id = this.create();
                    success = true;
                }
                finally {
                    if (!success) {
                        this.initialized.set(false);
                    }
                }
            }
            return this.id;
        }

        private String create() {
            CreateNetworkCmd createNetworkCmd = DockerClientFactory.instance().client().createNetworkCmd();
            createNetworkCmd.withName(this.name);
            createNetworkCmd.withCheckDuplicate(true);
            if (this.enableIpv6 != null) {
                createNetworkCmd.withEnableIpv6(this.enableIpv6);
            }
            if (this.driver != null) {
                createNetworkCmd.withDriver(this.driver);
            }
            for (Consumer<CreateNetworkCmd> consumer : this.createNetworkCmdModifiers) {
                consumer.accept(createNetworkCmd);
            }
            Map<String, String> labels = createNetworkCmd.getLabels();
            labels = new HashMap<String, String>(labels != null ? labels : Collections.emptyMap());
            labels.putAll(DockerClientFactory.DEFAULT_LABELS);
            labels.putAll(ResourceReaper.instance().getLabels());
            createNetworkCmd.withLabels(labels);
            return ((CreateNetworkResponse)createNetworkCmd.exec()).getId();
        }

        @Override
        protected void after() {
            this.close();
        }

        @Override
        public synchronized void close() {
            if (this.initialized.getAndSet(false)) {
                ResourceReaper.instance().removeNetworkById(this.id);
            }
        }

        NetworkImpl(Boolean enableIpv6, String driver, Set<Consumer<CreateNetworkCmd>> createNetworkCmdModifiers, String id) {
            this.enableIpv6 = enableIpv6;
            this.driver = driver;
            this.createNetworkCmdModifiers = createNetworkCmdModifiers;
            this.id = id;
        }

        public static NetworkImplBuilder builder() {
            return new NetworkImplBuilder();
        }

        public String getName() {
            return this.name;
        }

        public Boolean getEnableIpv6() {
            return this.enableIpv6;
        }

        public String getDriver() {
            return this.driver;
        }

        public Set<Consumer<CreateNetworkCmd>> getCreateNetworkCmdModifiers() {
            return this.createNetworkCmdModifiers;
        }

        public AtomicBoolean getInitialized() {
            return this.initialized;
        }

        public static class NetworkImplBuilder {
            private Boolean enableIpv6;
            private String driver;
            private ArrayList<Consumer<CreateNetworkCmd>> createNetworkCmdModifiers;
            private String id;

            NetworkImplBuilder() {
            }

            public NetworkImplBuilder enableIpv6(Boolean enableIpv6) {
                this.enableIpv6 = enableIpv6;
                return this;
            }

            public NetworkImplBuilder driver(String driver) {
                this.driver = driver;
                return this;
            }

            public NetworkImplBuilder createNetworkCmdModifier(Consumer<CreateNetworkCmd> createNetworkCmdModifier) {
                if (this.createNetworkCmdModifiers == null) {
                    this.createNetworkCmdModifiers = new ArrayList();
                }
                this.createNetworkCmdModifiers.add(createNetworkCmdModifier);
                return this;
            }

            public NetworkImplBuilder createNetworkCmdModifiers(Collection<? extends Consumer<CreateNetworkCmd>> createNetworkCmdModifiers) {
                if (createNetworkCmdModifiers == null) {
                    throw new NullPointerException("createNetworkCmdModifiers cannot be null");
                }
                if (this.createNetworkCmdModifiers == null) {
                    this.createNetworkCmdModifiers = new ArrayList();
                }
                this.createNetworkCmdModifiers.addAll(createNetworkCmdModifiers);
                return this;
            }

            public NetworkImplBuilder clearCreateNetworkCmdModifiers() {
                if (this.createNetworkCmdModifiers != null) {
                    this.createNetworkCmdModifiers.clear();
                }
                return this;
            }

            @Deprecated
            public NetworkImplBuilder id(String id) {
                this.id = id;
                return this;
            }

            public NetworkImpl build() {
                Set<Consumer<CreateNetworkCmd>> createNetworkCmdModifiers;
                switch (this.createNetworkCmdModifiers == null ? 0 : this.createNetworkCmdModifiers.size()) {
                    case 0: {
                        createNetworkCmdModifiers = Collections.emptySet();
                        break;
                    }
                    case 1: {
                        createNetworkCmdModifiers = Collections.singleton(this.createNetworkCmdModifiers.get(0));
                        break;
                    }
                    default: {
                        createNetworkCmdModifiers = new LinkedHashSet(this.createNetworkCmdModifiers.size() < 0x40000000 ? 1 + this.createNetworkCmdModifiers.size() + (this.createNetworkCmdModifiers.size() - 3) / 3 : Integer.MAX_VALUE);
                        createNetworkCmdModifiers.addAll(this.createNetworkCmdModifiers);
                        createNetworkCmdModifiers = Collections.unmodifiableSet(createNetworkCmdModifiers);
                    }
                }
                return new NetworkImpl(this.enableIpv6, this.driver, createNetworkCmdModifiers, this.id);
            }

            public String toString() {
                return "Network.NetworkImpl.NetworkImplBuilder(enableIpv6=" + this.enableIpv6 + ", driver=" + this.driver + ", createNetworkCmdModifiers=" + this.createNetworkCmdModifiers + ", id=" + this.id + ")";
            }
        }
    }
}

