/*
 * Decompiled with CFR 0.152.
 */
package dev.monosoul.jooq.shadow.org.testcontainers.containers.output;

import dev.monosoul.jooq.shadow.com.github.dockerjava.api.async.ResultCallbackTemplate;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.model.Frame;
import dev.monosoul.jooq.shadow.org.testcontainers.containers.output.BaseConsumer;
import dev.monosoul.jooq.shadow.org.testcontainers.containers.output.OutputFrame;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FrameConsumerResultCallback
extends ResultCallbackTemplate<FrameConsumerResultCallback, Frame> {
    private static final Logger LOGGER = LoggerFactory.getLogger(FrameConsumerResultCallback.class);
    private final Map<OutputFrame.OutputType, LineConsumer> consumers = new HashMap<OutputFrame.OutputType, LineConsumer>();
    private final CountDownLatch completionLatch = new CountDownLatch(1);

    public void addConsumer(OutputFrame.OutputType outputType, Consumer<OutputFrame> consumer) {
        this.consumers.put(outputType, new LineConsumer(outputType, consumer));
    }

    @Override
    public void onNext(Frame frame) {
        OutputFrame.OutputType type;
        if (frame != null && (type = OutputFrame.OutputType.forStreamType(frame.getStreamType())) != null) {
            LineConsumer consumer = this.consumers.get((Object)type);
            if (consumer == null) {
                LOGGER.error("got frame with type {}, for which no handler is configured", (Object)frame.getStreamType());
            } else if (frame.getPayload() != null) {
                consumer.processFrame(frame.getPayload());
            }
        }
    }

    @Override
    public void onError(Throwable throwable) {
        try {
            this.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void close() throws IOException {
        if (this.completionLatch.getCount() == 0L) {
            return;
        }
        this.consumers.values().forEach(LineConsumer::processBuffer);
        this.consumers.values().forEach(LineConsumer::end);
        super.close();
        this.completionLatch.countDown();
    }

    public CountDownLatch getCompletionLatch() {
        return this.completionLatch;
    }

    private static class LineConsumer {
        private static final Pattern ANSI_COLOR_PATTERN = Pattern.compile("\u001b\\[[0-9;]+m");
        private final OutputFrame.OutputType type;
        private final Consumer<OutputFrame> consumer;
        private final ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        private boolean lastCR = false;

        LineConsumer(OutputFrame.OutputType type, Consumer<OutputFrame> consumer) {
            this.type = type;
            this.consumer = consumer;
        }

        void processFrame(byte[] b) {
            int start = 0;
            block4: for (int i = 0; i < b.length; ++i) {
                switch (b[i]) {
                    case 10: {
                        this.buffer.write(b, start, i + 1 - start);
                        start = i + 1;
                        this.consume();
                        this.lastCR = false;
                        continue block4;
                    }
                    case 13: {
                        if (this.lastCR) {
                            this.consume();
                        }
                        this.buffer.write(b, start, i + 1 - start);
                        start = i + 1;
                        this.lastCR = true;
                        continue block4;
                    }
                    default: {
                        if (this.lastCR) {
                            this.consume();
                        }
                        this.lastCR = false;
                    }
                }
            }
            this.buffer.write(b, start, b.length - start);
        }

        void processBuffer() {
            if (this.buffer.size() > 0) {
                this.consume();
            }
        }

        void end() {
            this.consumer.accept(OutputFrame.END);
        }

        private void consume() {
            String string = new String(this.buffer.toByteArray(), StandardCharsets.UTF_8);
            byte[] bytes = this.processAnsiColorCodes(string).getBytes(StandardCharsets.UTF_8);
            this.consumer.accept(new OutputFrame(this.type, bytes));
            this.buffer.reset();
        }

        private String processAnsiColorCodes(String utf8String) {
            if (!(this.consumer instanceof BaseConsumer) || ((BaseConsumer)this.consumer).isRemoveColorCodes()) {
                return ANSI_COLOR_PATTERN.matcher(utf8String).replaceAll("");
            }
            return utf8String;
        }
    }
}

