/*
 * Decompiled with CFR 0.152.
 */
package dev.monosoul.jooq.shadow.org.testcontainers.containers.startupcheck;

import dev.monosoul.jooq.shadow.com.github.dockerjava.api.DockerClient;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.InspectContainerResponse;
import dev.monosoul.jooq.shadow.org.jetbrains.annotations.NotNull;
import dev.monosoul.jooq.shadow.org.testcontainers.containers.startupcheck.StartupCheckStrategy;
import dev.monosoul.jooq.shadow.org.testcontainers.utility.DockerStatus;
import java.time.Duration;
import java.time.Instant;

public class MinimumDurationRunningStartupCheckStrategy
extends StartupCheckStrategy {
    @NotNull
    private final Duration minimumRunningDuration;

    public MinimumDurationRunningStartupCheckStrategy(@NotNull Duration minimumRunningDuration) {
        this.minimumRunningDuration = minimumRunningDuration;
    }

    @Override
    public StartupCheckStrategy.StartupStatus checkStartupState(DockerClient dockerClient, String containerId) {
        Instant now = Instant.now();
        InspectContainerResponse.ContainerState state = this.getCurrentState(dockerClient, containerId);
        if (DockerStatus.isContainerRunning(state, this.minimumRunningDuration, now)) {
            return StartupCheckStrategy.StartupStatus.SUCCESSFUL;
        }
        if (DockerStatus.isContainerStopped(state)) {
            return StartupCheckStrategy.StartupStatus.FAILED;
        }
        return StartupCheckStrategy.StartupStatus.NOT_YET_KNOWN;
    }
}

