/*
 * Decompiled with CFR 0.152.
 */
package dev.monosoul.jooq.shadow.org.testcontainers.containers.wait.strategy;

import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.LogContainerCmd;
import dev.monosoul.jooq.shadow.org.testcontainers.containers.ContainerLaunchException;
import dev.monosoul.jooq.shadow.org.testcontainers.containers.output.FrameConsumerResultCallback;
import dev.monosoul.jooq.shadow.org.testcontainers.containers.output.OutputFrame;
import dev.monosoul.jooq.shadow.org.testcontainers.containers.output.WaitingConsumer;
import dev.monosoul.jooq.shadow.org.testcontainers.containers.wait.strategy.AbstractWaitStrategy;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Predicate;

public class LogMessageWaitStrategy
extends AbstractWaitStrategy {
    private String regEx;
    private int times = 1;

    @Override
    protected void waitUntilReady() {
        WaitingConsumer waitingConsumer = new WaitingConsumer();
        LogContainerCmd cmd = this.waitStrategyTarget.getDockerClient().logContainerCmd(this.waitStrategyTarget.getContainerId()).withFollowStream(true).withSince(0).withStdOut(true).withStdErr(true);
        try (FrameConsumerResultCallback callback = new FrameConsumerResultCallback();){
            callback.addConsumer(OutputFrame.OutputType.STDOUT, waitingConsumer);
            callback.addConsumer(OutputFrame.OutputType.STDERR, waitingConsumer);
            cmd.exec(callback);
            Predicate<OutputFrame> waitPredicate = outputFrame -> outputFrame.getUtf8String().matches("(?s)" + this.regEx);
            try {
                waitingConsumer.waitUntil(waitPredicate, this.startupTimeout.getSeconds(), TimeUnit.SECONDS, this.times);
            }
            catch (TimeoutException e) {
                throw new ContainerLaunchException("Timed out waiting for log output matching '" + this.regEx + "'");
            }
        }
    }

    public LogMessageWaitStrategy withRegEx(String regEx) {
        this.regEx = regEx;
        return this;
    }

    public LogMessageWaitStrategy withTimes(int times) {
        this.times = times;
        return this;
    }
}

