/*
 * Decompiled with CFR 0.152.
 */
package dev.monosoul.jooq.shadow.org.testcontainers.dockerclient;

import dev.monosoul.jooq.shadow.com.github.dockerjava.api.DockerClient;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.AttachContainerCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.AuthCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.BuildImageCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.CommitCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.ConnectToNetworkCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.ContainerDiffCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.CopyArchiveFromContainerCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.CopyArchiveToContainerCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.CopyFileFromContainerCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.CreateConfigCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.CreateContainerCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.CreateImageCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.CreateNetworkCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.CreateSecretCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.CreateServiceCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.CreateVolumeCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.DisconnectFromNetworkCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.EventsCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.ExecCreateCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.ExecStartCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.InfoCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.InitializeSwarmCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.InspectConfigCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.InspectContainerCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.InspectExecCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.InspectImageCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.InspectNetworkCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.InspectServiceCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.InspectSwarmCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.InspectVolumeCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.JoinSwarmCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.KillContainerCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.LeaveSwarmCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.ListConfigsCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.ListContainersCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.ListImagesCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.ListNetworksCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.ListSecretsCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.ListServicesCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.ListSwarmNodesCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.ListTasksCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.ListVolumesCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.LoadImageAsyncCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.LoadImageCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.LogContainerCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.LogSwarmObjectCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.PauseContainerCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.PingCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.PruneCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.PullImageCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.PushImageCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.RemoveConfigCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.RemoveContainerCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.RemoveImageCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.RemoveNetworkCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.RemoveSecretCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.RemoveServiceCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.RemoveSwarmNodeCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.RemoveVolumeCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.RenameContainerCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.ResizeContainerCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.ResizeExecCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.RestartContainerCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.SaveImageCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.SaveImagesCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.SearchImagesCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.StartContainerCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.StatsCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.StopContainerCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.SyncDockerCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.TagImageCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.TopContainerCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.UnpauseContainerCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.UpdateContainerCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.UpdateServiceCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.UpdateSwarmCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.UpdateSwarmNodeCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.VersionCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.WaitContainerCmd;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.exception.DockerException;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.model.AuthConfig;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.model.Identifier;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.model.PruneType;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.model.SecretSpec;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.model.ServiceSpec;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.model.SwarmSpec;
import dev.monosoul.jooq.shadow.org.jetbrains.annotations.NotNull;
import dev.monosoul.jooq.shadow.org.testcontainers.utility.AuditLogger;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Proxy;
import java.util.function.BiConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class AuditLoggingDockerClient
implements DockerClient {
    private static final Logger log = LoggerFactory.getLogger(AuditLoggingDockerClient.class);
    private final DockerClient wrappedClient;

    public AuditLoggingDockerClient(DockerClient wrappedClient) {
        this.wrappedClient = wrappedClient;
    }

    @Override
    public CreateContainerCmd createContainerCmd(@NotNull String image) {
        return this.wrappedCommand(CreateContainerCmd.class, this.wrappedClient.createContainerCmd(image), (cmd, res) -> AuditLogger.doLog("CREATE", image, res.getId(), cmd), (cmd, e) -> AuditLogger.doLog("CREATE", image, null, cmd, e));
    }

    @Override
    public StartContainerCmd startContainerCmd(@NotNull String containerId) {
        return this.wrappedCommand(StartContainerCmd.class, this.wrappedClient.startContainerCmd(containerId), (cmd, res) -> AuditLogger.doLog("START", null, containerId, cmd), (cmd, e) -> AuditLogger.doLog("START", null, containerId, cmd, e));
    }

    @Override
    public RemoveContainerCmd removeContainerCmd(@NotNull String containerId) {
        return this.wrappedCommand(RemoveContainerCmd.class, this.wrappedClient.removeContainerCmd(containerId), (cmd, res) -> AuditLogger.doLog("REMOVE", null, containerId, cmd), (cmd, e) -> AuditLogger.doLog("REMOVE", null, containerId, cmd, e));
    }

    @Override
    public StopContainerCmd stopContainerCmd(@NotNull String containerId) {
        return this.wrappedCommand(StopContainerCmd.class, this.wrappedClient.stopContainerCmd(containerId), (cmd, res) -> AuditLogger.doLog("STOP", null, containerId, cmd), (cmd, e) -> AuditLogger.doLog("STOP", null, containerId, cmd, e));
    }

    @Override
    public KillContainerCmd killContainerCmd(@NotNull String containerId) {
        return this.wrappedCommand(KillContainerCmd.class, this.wrappedClient.killContainerCmd(containerId), (cmd, res) -> AuditLogger.doLog("KILL", null, containerId, cmd), (cmd, e) -> AuditLogger.doLog("KILL", null, containerId, cmd, e));
    }

    @Override
    public CreateNetworkCmd createNetworkCmd() {
        return this.wrappedCommand(CreateNetworkCmd.class, this.wrappedClient.createNetworkCmd(), (cmd, res) -> AuditLogger.doLog("CREATE_NETWORK", null, null, cmd), (cmd, e) -> AuditLogger.doLog("CREATE_NETWORK", null, null, cmd, e));
    }

    @Override
    public RemoveNetworkCmd removeNetworkCmd(@NotNull String networkId) {
        return this.wrappedCommand(RemoveNetworkCmd.class, this.wrappedClient.removeNetworkCmd(networkId), (cmd, res) -> AuditLogger.doLog("REMOVE_NETWORK", null, null, cmd), (cmd, e) -> AuditLogger.doLog("REMOVE_NETWORK", null, null, cmd, e));
    }

    private <T extends SyncDockerCmd<R>, R> T wrappedCommand(Class<T> clazz, T cmd, BiConsumer<T, R> successConsumer, BiConsumer<T, Exception> failureConsumer) {
        return (T)((SyncDockerCmd)Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, (proxy, method, args) -> {
            if (method.getName().equals("exec")) {
                try {
                    Object r = method.invoke((Object)cmd, args);
                    successConsumer.accept(cmd, r);
                    return r;
                }
                catch (Exception e) {
                    if (e instanceof InvocationTargetException && e.getCause() instanceof Exception) {
                        e = (Exception)e.getCause();
                    }
                    failureConsumer.accept(cmd, e);
                    throw e;
                }
            }
            return method.invoke((Object)cmd, args);
        }));
    }

    @Override
    public AuthConfig authConfig() throws DockerException {
        return this.wrappedClient.authConfig();
    }

    @Override
    public AuthCmd authCmd() {
        return this.wrappedClient.authCmd();
    }

    @Override
    public InfoCmd infoCmd() {
        return this.wrappedClient.infoCmd();
    }

    @Override
    public PingCmd pingCmd() {
        return this.wrappedClient.pingCmd();
    }

    @Override
    public VersionCmd versionCmd() {
        return this.wrappedClient.versionCmd();
    }

    @Override
    public PullImageCmd pullImageCmd(String arg0) {
        return this.wrappedClient.pullImageCmd(arg0);
    }

    @Override
    public PushImageCmd pushImageCmd(String arg0) {
        return this.wrappedClient.pushImageCmd(arg0);
    }

    @Override
    public PushImageCmd pushImageCmd(Identifier arg0) {
        return this.wrappedClient.pushImageCmd(arg0);
    }

    @Override
    public CreateImageCmd createImageCmd(String arg0, InputStream arg1) {
        return this.wrappedClient.createImageCmd(arg0, arg1);
    }

    @Override
    public LoadImageCmd loadImageCmd(InputStream arg0) {
        return this.wrappedClient.loadImageCmd(arg0);
    }

    @Override
    public LoadImageAsyncCmd loadImageAsyncCmd(InputStream arg0) {
        return this.wrappedClient.loadImageAsyncCmd(arg0);
    }

    @Override
    public SearchImagesCmd searchImagesCmd(String arg0) {
        return this.wrappedClient.searchImagesCmd(arg0);
    }

    @Override
    public RemoveImageCmd removeImageCmd(String arg0) {
        return this.wrappedClient.removeImageCmd(arg0);
    }

    @Override
    public ListImagesCmd listImagesCmd() {
        return this.wrappedClient.listImagesCmd();
    }

    @Override
    public InspectImageCmd inspectImageCmd(String arg0) {
        return this.wrappedClient.inspectImageCmd(arg0);
    }

    @Override
    public SaveImageCmd saveImageCmd(String arg0) {
        return this.wrappedClient.saveImageCmd(arg0);
    }

    @Override
    public SaveImagesCmd saveImagesCmd() {
        return this.wrappedClient.saveImagesCmd();
    }

    @Override
    public ListContainersCmd listContainersCmd() {
        return this.wrappedClient.listContainersCmd();
    }

    @Override
    public ExecCreateCmd execCreateCmd(String arg0) {
        return this.wrappedClient.execCreateCmd(arg0);
    }

    @Override
    public ResizeExecCmd resizeExecCmd(String arg0) {
        return this.wrappedClient.resizeExecCmd(arg0);
    }

    @Override
    public InspectContainerCmd inspectContainerCmd(String arg0) {
        return this.wrappedClient.inspectContainerCmd(arg0);
    }

    @Override
    public WaitContainerCmd waitContainerCmd(String arg0) {
        return this.wrappedClient.waitContainerCmd(arg0);
    }

    @Override
    public AttachContainerCmd attachContainerCmd(String arg0) {
        return this.wrappedClient.attachContainerCmd(arg0);
    }

    @Override
    public ExecStartCmd execStartCmd(String arg0) {
        return this.wrappedClient.execStartCmd(arg0);
    }

    @Override
    public InspectExecCmd inspectExecCmd(String arg0) {
        return this.wrappedClient.inspectExecCmd(arg0);
    }

    @Override
    public LogContainerCmd logContainerCmd(String arg0) {
        return this.wrappedClient.logContainerCmd(arg0);
    }

    @Override
    public CopyArchiveFromContainerCmd copyArchiveFromContainerCmd(String arg0, String arg1) {
        return this.wrappedClient.copyArchiveFromContainerCmd(arg0, arg1);
    }

    @Override
    @Deprecated
    public CopyFileFromContainerCmd copyFileFromContainerCmd(String arg0, String arg1) {
        return this.wrappedClient.copyFileFromContainerCmd(arg0, arg1);
    }

    @Override
    public CopyArchiveToContainerCmd copyArchiveToContainerCmd(String arg0) {
        return this.wrappedClient.copyArchiveToContainerCmd(arg0);
    }

    @Override
    public ContainerDiffCmd containerDiffCmd(String arg0) {
        return this.wrappedClient.containerDiffCmd(arg0);
    }

    @Override
    public UpdateContainerCmd updateContainerCmd(String arg0) {
        return this.wrappedClient.updateContainerCmd(arg0);
    }

    @Override
    public RenameContainerCmd renameContainerCmd(String arg0) {
        return this.wrappedClient.renameContainerCmd(arg0);
    }

    @Override
    public RestartContainerCmd restartContainerCmd(String arg0) {
        return this.wrappedClient.restartContainerCmd(arg0);
    }

    @Override
    public ResizeContainerCmd resizeContainerCmd(String arg0) {
        return this.wrappedClient.resizeContainerCmd(arg0);
    }

    @Override
    public CommitCmd commitCmd(String arg0) {
        return this.wrappedClient.commitCmd(arg0);
    }

    @Override
    public BuildImageCmd buildImageCmd() {
        return this.wrappedClient.buildImageCmd();
    }

    @Override
    public BuildImageCmd buildImageCmd(File arg0) {
        return this.wrappedClient.buildImageCmd(arg0);
    }

    @Override
    public BuildImageCmd buildImageCmd(InputStream arg0) {
        return this.wrappedClient.buildImageCmd(arg0);
    }

    @Override
    public TopContainerCmd topContainerCmd(String arg0) {
        return this.wrappedClient.topContainerCmd(arg0);
    }

    @Override
    public TagImageCmd tagImageCmd(String arg0, String arg1, String arg2) {
        return this.wrappedClient.tagImageCmd(arg0, arg1, arg2);
    }

    @Override
    public PauseContainerCmd pauseContainerCmd(String arg0) {
        return this.wrappedClient.pauseContainerCmd(arg0);
    }

    @Override
    public UnpauseContainerCmd unpauseContainerCmd(String arg0) {
        return this.wrappedClient.unpauseContainerCmd(arg0);
    }

    @Override
    public EventsCmd eventsCmd() {
        return this.wrappedClient.eventsCmd();
    }

    @Override
    public StatsCmd statsCmd(String arg0) {
        return this.wrappedClient.statsCmd(arg0);
    }

    @Override
    public CreateVolumeCmd createVolumeCmd() {
        return this.wrappedClient.createVolumeCmd();
    }

    @Override
    public InspectVolumeCmd inspectVolumeCmd(String arg0) {
        return this.wrappedClient.inspectVolumeCmd(arg0);
    }

    @Override
    public RemoveVolumeCmd removeVolumeCmd(String arg0) {
        return this.wrappedClient.removeVolumeCmd(arg0);
    }

    @Override
    public ListVolumesCmd listVolumesCmd() {
        return this.wrappedClient.listVolumesCmd();
    }

    @Override
    public ListNetworksCmd listNetworksCmd() {
        return this.wrappedClient.listNetworksCmd();
    }

    @Override
    public InspectNetworkCmd inspectNetworkCmd() {
        return this.wrappedClient.inspectNetworkCmd();
    }

    @Override
    public ConnectToNetworkCmd connectToNetworkCmd() {
        return this.wrappedClient.connectToNetworkCmd();
    }

    @Override
    public DisconnectFromNetworkCmd disconnectFromNetworkCmd() {
        return this.wrappedClient.disconnectFromNetworkCmd();
    }

    @Override
    public InitializeSwarmCmd initializeSwarmCmd(SwarmSpec arg0) {
        return this.wrappedClient.initializeSwarmCmd(arg0);
    }

    @Override
    public InspectSwarmCmd inspectSwarmCmd() {
        return this.wrappedClient.inspectSwarmCmd();
    }

    @Override
    public JoinSwarmCmd joinSwarmCmd() {
        return this.wrappedClient.joinSwarmCmd();
    }

    @Override
    public LeaveSwarmCmd leaveSwarmCmd() {
        return this.wrappedClient.leaveSwarmCmd();
    }

    @Override
    public UpdateSwarmCmd updateSwarmCmd(SwarmSpec arg0) {
        return this.wrappedClient.updateSwarmCmd(arg0);
    }

    @Override
    public UpdateSwarmNodeCmd updateSwarmNodeCmd() {
        return this.wrappedClient.updateSwarmNodeCmd();
    }

    @Override
    public RemoveSwarmNodeCmd removeSwarmNodeCmd(String arg0) {
        return this.wrappedClient.removeSwarmNodeCmd(arg0);
    }

    @Override
    public ListSwarmNodesCmd listSwarmNodesCmd() {
        return this.wrappedClient.listSwarmNodesCmd();
    }

    @Override
    public ListServicesCmd listServicesCmd() {
        return this.wrappedClient.listServicesCmd();
    }

    @Override
    public CreateServiceCmd createServiceCmd(ServiceSpec arg0) {
        return this.wrappedClient.createServiceCmd(arg0);
    }

    @Override
    public InspectServiceCmd inspectServiceCmd(String arg0) {
        return this.wrappedClient.inspectServiceCmd(arg0);
    }

    @Override
    public UpdateServiceCmd updateServiceCmd(String arg0, ServiceSpec arg1) {
        return this.wrappedClient.updateServiceCmd(arg0, arg1);
    }

    @Override
    public RemoveServiceCmd removeServiceCmd(String arg0) {
        return this.wrappedClient.removeServiceCmd(arg0);
    }

    @Override
    public ListTasksCmd listTasksCmd() {
        return this.wrappedClient.listTasksCmd();
    }

    @Override
    public LogSwarmObjectCmd logServiceCmd(String arg0) {
        return this.wrappedClient.logServiceCmd(arg0);
    }

    @Override
    public LogSwarmObjectCmd logTaskCmd(String arg0) {
        return this.wrappedClient.logTaskCmd(arg0);
    }

    @Override
    public PruneCmd pruneCmd(PruneType arg0) {
        return this.wrappedClient.pruneCmd(arg0);
    }

    @Override
    public ListSecretsCmd listSecretsCmd() {
        return this.wrappedClient.listSecretsCmd();
    }

    @Override
    public CreateSecretCmd createSecretCmd(SecretSpec arg0) {
        return this.wrappedClient.createSecretCmd(arg0);
    }

    @Override
    public RemoveSecretCmd removeSecretCmd(String arg0) {
        return this.wrappedClient.removeSecretCmd(arg0);
    }

    @Override
    public ListConfigsCmd listConfigsCmd() {
        return this.wrappedClient.listConfigsCmd();
    }

    @Override
    public CreateConfigCmd createConfigCmd() {
        return this.wrappedClient.createConfigCmd();
    }

    @Override
    public InspectConfigCmd inspectConfigCmd(String arg0) {
        return this.wrappedClient.inspectConfigCmd(arg0);
    }

    @Override
    public RemoveConfigCmd removeConfigCmd(String arg0) {
        return this.wrappedClient.removeConfigCmd(arg0);
    }

    @Override
    public void close() throws IOException {
        this.wrappedClient.close();
    }

    private static interface InterceptedMethods {
        public CreateContainerCmd createContainerCmd(String var1);

        public StartContainerCmd startContainerCmd(String var1);

        public RemoveContainerCmd removeContainerCmd(String var1);

        public StopContainerCmd stopContainerCmd(String var1);

        public KillContainerCmd killContainerCmd(String var1);

        public CreateNetworkCmd createNetworkCmd();

        public RemoveNetworkCmd removeNetworkCmd(String var1);
    }
}

