/*
 * Decompiled with CFR 0.152.
 */
package dev.monosoul.jooq.shadow.org.testcontainers.dockerclient;

import dev.monosoul.jooq.shadow.org.testcontainers.dockerclient.DockerClientProviderStrategy;
import dev.monosoul.jooq.shadow.org.testcontainers.dockerclient.InvalidConfigurationException;
import dev.monosoul.jooq.shadow.org.testcontainers.dockerclient.TransportConfig;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.com.github.dockerjava.core.DefaultDockerClientConfig;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.com.github.dockerjava.core.DockerClientConfig;
import dev.monosoul.jooq.shadow.org.testcontainers.utility.TestcontainersConfiguration;
import java.util.Optional;

@Deprecated
public final class EnvironmentAndSystemPropertyClientProviderStrategy
extends DockerClientProviderStrategy {
    public static final int PRIORITY = 100;
    private final DockerClientConfig dockerClientConfig;
    private final boolean applicable;

    public EnvironmentAndSystemPropertyClientProviderStrategy() {
        this(DefaultDockerClientConfig.createDefaultConfigBuilder());
    }

    EnvironmentAndSystemPropertyClientProviderStrategy(DefaultDockerClientConfig.Builder configBuilder) {
        String dockerConfigSource;
        switch (dockerConfigSource = TestcontainersConfiguration.getInstance().getEnvVarOrProperty("dockerconfig.source", "auto")) {
            case "auto": {
                Optional<String> dockerHost = this.getSetting("docker.host");
                dockerHost.ifPresent(configBuilder::withDockerHost);
                this.applicable = dockerHost.isPresent();
                this.getSetting("docker.tls.verify").ifPresent(configBuilder::withDockerTlsVerify);
                this.getSetting("docker.cert.path").ifPresent(configBuilder::withDockerCertPath);
                break;
            }
            case "autoIgnoringUserProperties": {
                this.applicable = configBuilder.isDockerHostSetExplicitly();
                break;
            }
            default: {
                throw new InvalidConfigurationException("Invalid value for dockerconfig.source: " + dockerConfigSource);
            }
        }
        this.dockerClientConfig = configBuilder.build();
    }

    private Optional<String> getSetting(String name) {
        return Optional.ofNullable(TestcontainersConfiguration.getInstance().getEnvVarOrUserProperty(name, null));
    }

    @Override
    public TransportConfig getTransportConfig() {
        return TransportConfig.builder().dockerHost(this.dockerClientConfig.getDockerHost()).sslConfig(this.dockerClientConfig.getSSLConfig()).build();
    }

    @Override
    protected int getPriority() {
        return 100;
    }

    @Override
    public String getDescription() {
        return "Environment variables, system properties and defaults. Resolved dockerHost=" + this.dockerClientConfig.getDockerHost();
    }

    @Override
    protected boolean isPersistable() {
        return false;
    }

    @Override
    public boolean isApplicable() {
        return this.applicable;
    }
}

