/*
 * Decompiled with CFR 0.152.
 */
package dev.monosoul.jooq.shadow.org.testcontainers.dockerclient;

import dev.monosoul.jooq.shadow.org.testcontainers.dockerclient.DockerClientProviderStrategy;
import dev.monosoul.jooq.shadow.org.testcontainers.dockerclient.InvalidConfigurationException;
import dev.monosoul.jooq.shadow.org.testcontainers.dockerclient.TransportConfig;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.apache.commons.lang3.SystemUtils;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;

@Deprecated
public final class UnixSocketClientProviderStrategy
extends DockerClientProviderStrategy {
    protected static final String DOCKER_SOCK_PATH = "/var/run/docker.sock";
    private static final String SOCKET_LOCATION = "unix:///var/run/docker.sock";
    private static final int SOCKET_FILE_MODE_MASK = 49152;
    public static final int PRIORITY = 80;

    @Override
    public TransportConfig getTransportConfig() throws InvalidConfigurationException {
        Integer mode;
        Path dockerSocketFile = Paths.get(DOCKER_SOCK_PATH, new String[0]);
        try {
            mode = (Integer)Files.getAttribute(dockerSocketFile, "unix:mode", new LinkOption[0]);
        }
        catch (IOException e) {
            throw new InvalidConfigurationException("Could not find unix domain socket", e);
        }
        if ((mode & 0xC000) != 49152) {
            throw new InvalidConfigurationException("Found docker unix domain socket but file mode was not as expected (expected: srwxr-xr-x). This problem is possibly due to occurrence of this issue in the past: https://github.com/docker/docker/issues/13121");
        }
        return TransportConfig.builder().dockerHost(URI.create(SOCKET_LOCATION)).build();
    }

    @Override
    protected boolean isApplicable() {
        return SystemUtils.IS_OS_LINUX || SystemUtils.IS_OS_MAC;
    }

    @Override
    public String getDescription() {
        return "local Unix socket (unix:///var/run/docker.sock)";
    }

    @Override
    protected int getPriority() {
        return 80;
    }
}

