/*
 * Decompiled with CFR 0.152.
 */
package dev.monosoul.jooq.shadow.org.testcontainers.ext;

import dev.monosoul.jooq.shadow.org.testcontainers.delegate.DatabaseDelegate;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.apache.commons.io.IOUtils;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.apache.commons.lang3.StringUtils;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.LinkedList;
import java.util.List;
import javax.script.ScriptException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ScriptUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ScriptUtils.class);
    public static final String DEFAULT_STATEMENT_SEPARATOR = ";";
    public static final String FALLBACK_STATEMENT_SEPARATOR = "\n";
    public static final String DEFAULT_COMMENT_PREFIX = "--";
    public static final String DEFAULT_BLOCK_COMMENT_START_DELIMITER = "/*";
    public static final String DEFAULT_BLOCK_COMMENT_END_DELIMITER = "*/";

    private ScriptUtils() {
    }

    public static void splitSqlScript(String resource, String script, String separator, String commentPrefix, String blockCommentStartDelimiter, String blockCommentEndDelimiter, List<String> statements) {
        ScriptUtils.checkArgument(StringUtils.isNotEmpty(script), "script must not be null or empty");
        ScriptUtils.checkArgument(separator != null, "separator must not be null");
        ScriptUtils.checkArgument(StringUtils.isNotEmpty(commentPrefix), "commentPrefix must not be null or empty");
        ScriptUtils.checkArgument(StringUtils.isNotEmpty(blockCommentStartDelimiter), "blockCommentStartDelimiter must not be null or empty");
        ScriptUtils.checkArgument(StringUtils.isNotEmpty(blockCommentEndDelimiter), "blockCommentEndDelimiter must not be null or empty");
        StringBuilder sb = new StringBuilder();
        boolean inEscape = false;
        boolean inLineComment = false;
        boolean inBlockComment = false;
        Character currentLiteralDelimiter = null;
        int compoundStatementDepth = 0;
        String lowerCaseScriptContent = script.toLowerCase();
        char[] content = script.toCharArray();
        for (int i = 0; i < script.length(); ++i) {
            boolean inCompoundStatement;
            boolean inComment;
            boolean inLiteral;
            char c = content[i];
            if (inEscape) {
                inEscape = false;
                sb.append(c);
                continue;
            }
            if (c == '\\') {
                inEscape = true;
                sb.append(c);
                continue;
            }
            if (!(inBlockComment || inLineComment || c != '\'' && c != '\"' && c != '`')) {
                if (currentLiteralDelimiter == null) {
                    currentLiteralDelimiter = Character.valueOf(c);
                } else if (currentLiteralDelimiter.charValue() == c) {
                    currentLiteralDelimiter = null;
                }
            }
            boolean bl = inLiteral = currentLiteralDelimiter != null;
            if (!inLiteral && ScriptUtils.containsSubstringAtOffset(lowerCaseScriptContent, commentPrefix, i)) {
                inLineComment = true;
            }
            if (inLineComment && c == '\n') {
                inLineComment = false;
            }
            if (!inLiteral && ScriptUtils.containsSubstringAtOffset(lowerCaseScriptContent, blockCommentStartDelimiter, i)) {
                inBlockComment = true;
            }
            if (!inLiteral && inBlockComment && ScriptUtils.containsSubstringAtOffset(lowerCaseScriptContent, blockCommentEndDelimiter, i)) {
                inBlockComment = false;
            }
            boolean bl2 = inComment = inLineComment || inBlockComment;
            if (!inLiteral && !inComment && ScriptUtils.containsKeywordsAtOffset(lowerCaseScriptContent, "BEGIN", i, separator, commentPrefix, blockCommentStartDelimiter)) {
                ++compoundStatementDepth;
            }
            if (!inLiteral && !inComment && ScriptUtils.containsKeywordsAtOffset(lowerCaseScriptContent, "END", i, separator, commentPrefix, blockCommentStartDelimiter)) {
                --compoundStatementDepth;
            }
            boolean bl3 = inCompoundStatement = compoundStatementDepth != 0;
            if (!inLiteral && !inCompoundStatement) {
                if (script.startsWith(separator, i)) {
                    sb = ScriptUtils.flushStringBuilder(sb, statements);
                    i += separator.length() - 1;
                    continue;
                }
                if (script.startsWith(commentPrefix, i)) {
                    int indexOfNextNewline = script.indexOf(FALLBACK_STATEMENT_SEPARATOR, i);
                    if (indexOfNextNewline <= i) break;
                    i = indexOfNextNewline;
                    continue;
                }
                if (script.startsWith(blockCommentStartDelimiter, i)) {
                    int indexOfCommentEnd = script.indexOf(blockCommentEndDelimiter, i);
                    if (indexOfCommentEnd > i) {
                        i = indexOfCommentEnd + blockCommentEndDelimiter.length() - 1;
                        inBlockComment = false;
                        continue;
                    }
                    throw new ScriptParseException(String.format("Missing block comment end delimiter [%s].", blockCommentEndDelimiter), resource);
                }
                if (c == ' ' || c == '\n' || c == '\t' || c == '\r') {
                    if (sb.length() <= 0 || sb.charAt(sb.length() - 1) == ' ') continue;
                    c = ' ';
                }
            }
            sb.append(c);
        }
        ScriptUtils.flushStringBuilder(sb, statements);
    }

    private static StringBuilder flushStringBuilder(StringBuilder sb, List<String> statements) {
        if (sb.length() == 0) {
            return sb;
        }
        String s = sb.toString().trim();
        if (StringUtils.isNotEmpty(s)) {
            statements.add(s);
        }
        return new StringBuilder();
    }

    private static boolean isSeperator(char c, String separator, String commentPrefix, String blockCommentStartDelimiter) {
        return c == ' ' || c == '\r' || c == '\n' || c == '\t' || c == separator.charAt(0) || c == separator.charAt(separator.length() - 1) || c == commentPrefix.charAt(0) || c == blockCommentStartDelimiter.charAt(0) || c == blockCommentStartDelimiter.charAt(blockCommentStartDelimiter.length() - 1);
    }

    private static boolean containsSubstringAtOffset(String lowercaseString, String substring, int offset) {
        String lowercaseSubstring = substring.toLowerCase();
        return lowercaseString.startsWith(lowercaseSubstring, offset);
    }

    private static boolean containsKeywordsAtOffset(String lowercaseString, String keywords, int offset, String separator, String commentPrefix, String blockCommentStartDelimiter) {
        String lowercaseKeywords = keywords.toLowerCase();
        boolean backSeperated = offset == 0 || ScriptUtils.isSeperator(lowercaseString.charAt(offset - 1), separator, commentPrefix, blockCommentStartDelimiter);
        boolean frontSeperated = offset >= lowercaseString.length() - keywords.length() || ScriptUtils.isSeperator(lowercaseString.charAt(offset + keywords.length()), separator, commentPrefix, blockCommentStartDelimiter);
        return backSeperated && frontSeperated && lowercaseString.startsWith(lowercaseKeywords, offset);
    }

    private static void checkArgument(boolean expression, String errorMessage) {
        if (!expression) {
            throw new IllegalArgumentException(errorMessage);
        }
    }

    public static boolean containsSqlScriptDelimiters(String script, String delim) {
        boolean inLiteral = false;
        char[] content = script.toCharArray();
        for (int i = 0; i < script.length(); ++i) {
            if (content[i] == '\'') {
                boolean bl = inLiteral = !inLiteral;
            }
            if (inLiteral || !script.startsWith(delim, i)) continue;
            return true;
        }
        return false;
    }

    public static void runInitScript(DatabaseDelegate databaseDelegate, String initScriptPath) {
        try {
            URL resource = Thread.currentThread().getContextClassLoader().getResource(initScriptPath);
            if (resource == null && (resource = ScriptUtils.class.getClassLoader().getResource(initScriptPath)) == null) {
                LOGGER.warn("Could not load classpath init script: {}", (Object)initScriptPath);
                throw new ScriptLoadException("Could not load classpath init script: " + initScriptPath + ". Resource not found.");
            }
            String scripts = IOUtils.toString(resource, StandardCharsets.UTF_8);
            ScriptUtils.executeDatabaseScript(databaseDelegate, initScriptPath, scripts);
        }
        catch (IOException e) {
            LOGGER.warn("Could not load classpath init script: {}", (Object)initScriptPath);
            throw new ScriptLoadException("Could not load classpath init script: " + initScriptPath, e);
        }
        catch (ScriptException e) {
            LOGGER.error("Error while executing init script: {}", (Object)initScriptPath, (Object)e);
            throw new UncategorizedScriptException("Error while executing init script: " + initScriptPath, e);
        }
    }

    public static void executeDatabaseScript(DatabaseDelegate databaseDelegate, String scriptPath, String script) throws ScriptException {
        ScriptUtils.executeDatabaseScript(databaseDelegate, scriptPath, script, false, false, DEFAULT_COMMENT_PREFIX, DEFAULT_STATEMENT_SEPARATOR, DEFAULT_BLOCK_COMMENT_START_DELIMITER, DEFAULT_BLOCK_COMMENT_END_DELIMITER);
    }

    public static void executeDatabaseScript(DatabaseDelegate databaseDelegate, String scriptPath, String script, boolean continueOnError, boolean ignoreFailedDrops, String commentPrefix, String separator, String blockCommentStartDelimiter, String blockCommentEndDelimiter) throws ScriptException {
        try {
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Executing database script from " + scriptPath);
            }
            long startTime = System.currentTimeMillis();
            LinkedList<String> statements = new LinkedList<String>();
            if (separator == null) {
                separator = DEFAULT_STATEMENT_SEPARATOR;
            }
            if (!ScriptUtils.containsSqlScriptDelimiters(script, separator)) {
                separator = FALLBACK_STATEMENT_SEPARATOR;
            }
            ScriptUtils.splitSqlScript(scriptPath, script, separator, commentPrefix, blockCommentStartDelimiter, blockCommentEndDelimiter, statements);
            try (DatabaseDelegate closeableDelegate = databaseDelegate;){
                closeableDelegate.execute(statements, scriptPath, continueOnError, ignoreFailedDrops);
            }
            long elapsedTime = System.currentTimeMillis() - startTime;
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("Executed database script from " + scriptPath + " in " + elapsedTime + " ms.");
            }
        }
        catch (Exception ex) {
            if (ex instanceof ScriptException) {
                throw (ScriptException)ex;
            }
            throw new UncategorizedScriptException("Failed to execute database script from resource [" + script + "]", ex);
        }
    }

    public static class UncategorizedScriptException
    extends RuntimeException {
        public UncategorizedScriptException(String s, Exception ex) {
            super(s, ex);
        }
    }

    public static class ScriptStatementFailedException
    extends RuntimeException {
        public ScriptStatementFailedException(String statement, int lineNumber, String scriptPath) {
            this(statement, lineNumber, scriptPath, null);
        }

        public ScriptStatementFailedException(String statement, int lineNumber, String scriptPath, Exception ex) {
            super(String.format("Script execution failed (%s:%d): %s", scriptPath, lineNumber, statement), ex);
        }
    }

    public static class ScriptParseException
    extends RuntimeException {
        public ScriptParseException(String format, String scriptPath) {
            super(String.format(format, scriptPath));
        }
    }

    public static class ScriptLoadException
    extends RuntimeException {
        public ScriptLoadException(String message) {
            super(message);
        }

        public ScriptLoadException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

