/*
 * Decompiled with CFR 0.152.
 */
package dev.monosoul.jooq.shadow.org.testcontainers.images;

import dev.monosoul.jooq.shadow.org.testcontainers.images.AbstractImagePullPolicy;
import dev.monosoul.jooq.shadow.org.testcontainers.images.ImageData;
import dev.monosoul.jooq.shadow.org.testcontainers.utility.DockerImageName;
import java.time.Duration;
import java.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class AgeBasedPullPolicy
extends AbstractImagePullPolicy {
    private static final Logger log = LoggerFactory.getLogger(AgeBasedPullPolicy.class);
    private final Duration maxAge;

    @Override
    protected boolean shouldPullCached(DockerImageName imageName, ImageData localImageData) {
        boolean result;
        Duration imageAge = Duration.between(localImageData.getCreatedAt(), Instant.now());
        boolean bl = result = imageAge.compareTo(this.maxAge) > 0;
        if (result) {
            log.trace("Should pull image: {}", (Object)imageName);
        }
        return result;
    }

    public AgeBasedPullPolicy(Duration maxAge) {
        this.maxAge = maxAge;
    }

    public Duration getMaxAge() {
        return this.maxAge;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AgeBasedPullPolicy)) {
            return false;
        }
        AgeBasedPullPolicy other = (AgeBasedPullPolicy)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Duration this$maxAge = this.getMaxAge();
        Duration other$maxAge = other.getMaxAge();
        return !(this$maxAge == null ? other$maxAge != null : !((Object)this$maxAge).equals(other$maxAge));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AgeBasedPullPolicy;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Duration $maxAge = this.getMaxAge();
        result = result * 59 + ($maxAge == null ? 43 : ((Object)$maxAge).hashCode());
        return result;
    }

    public String toString() {
        return "AgeBasedPullPolicy(maxAge=" + this.getMaxAge() + ")";
    }
}

