/*
 * Decompiled with CFR 0.152.
 */
package dev.monosoul.jooq.shadow.org.testcontainers.jib;

import com.google.cloud.tools.jib.api.DockerClient;
import com.google.cloud.tools.jib.api.ImageDetails;
import com.google.cloud.tools.jib.api.ImageReference;
import com.google.cloud.tools.jib.http.NotifyingOutputStream;
import com.google.cloud.tools.jib.image.ImageTarball;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.InspectImageResponse;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.LoadImageCallback;
import dev.monosoul.jooq.shadow.org.testcontainers.DockerClientFactory;
import dev.monosoul.jooq.shadow.org.testcontainers.images.RemoteDockerImage;
import dev.monosoul.jooq.shadow.org.testcontainers.jib.JibImageDetails;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.com.google.common.io.ByteStreams;
import dev.monosoul.jooq.shadow.org.testcontainers.utility.DockerImageName;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Map;
import java.util.function.Consumer;

class JibDockerClient
implements DockerClient {
    private static JibDockerClient instance;
    private final dev.monosoul.jooq.shadow.com.github.dockerjava.api.DockerClient dockerClient = DockerClientFactory.lazyClient();

    JibDockerClient() {
    }

    public static JibDockerClient instance() {
        if (instance == null) {
            instance = new JibDockerClient();
        }
        return instance;
    }

    public boolean supported(Map<String, String> map) {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String load(ImageTarball imageTarball, Consumer<Long> writtenByteCountListener) throws IOException {
        PipedInputStream in = new PipedInputStream();
        try {
            String string;
            block21: {
                PipedOutputStream out = new PipedOutputStream(in);
                try {
                    LoadImageCallback loadImage = this.dockerClient.loadImageAsyncCmd(in).exec(new LoadImageCallback());
                    try (NotifyingOutputStream stdin = new NotifyingOutputStream((OutputStream)out, writtenByteCountListener);){
                        imageTarball.writeTo((OutputStream)stdin);
                    }
                    string = loadImage.awaitMessage();
                    if (Collections.singletonList(out).get(0) == null) break block21;
                }
                catch (Throwable throwable) {
                    if (Collections.singletonList(out).get(0) != null) {
                        out.close();
                    }
                    throw throwable;
                }
                out.close();
            }
            return string;
        }
        finally {
            if (Collections.singletonList(in).get(0) != null) {
                in.close();
            }
        }
    }

    public void save(ImageReference imageReference, Path outputPath, Consumer<Long> writtenByteCountListener) throws IOException {
        try (InputStream inputStream = this.dockerClient.saveImageCmd(imageReference.toString()).exec();
             BufferedInputStream stdout = new BufferedInputStream(inputStream);
             BufferedOutputStream fileStream = new BufferedOutputStream(Files.newOutputStream(outputPath, new OpenOption[0]));
             NotifyingOutputStream notifyingFileStream = new NotifyingOutputStream((OutputStream)fileStream, writtenByteCountListener);){
            ByteStreams.copy(stdout, (OutputStream)notifyingFileStream);
        }
    }

    public ImageDetails inspect(ImageReference imageReference) {
        new RemoteDockerImage(DockerImageName.parse(imageReference.toString())).get();
        InspectImageResponse response = this.dockerClient.inspectImageCmd(imageReference.toString()).exec();
        return new JibImageDetails(response.getSize(), response.getId(), response.getRootFS().getLayers());
    }
}

