/*
 * Decompiled with CFR 0.152.
 */
package dev.monosoul.jooq.shadow.org.testcontainers.lifecycle;

import dev.monosoul.jooq.shadow.org.testcontainers.lifecycle.Startable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

public final class Startables {
    private static final Executor EXECUTOR = Executors.newCachedThreadPool(new ThreadFactory(){
        private final AtomicLong COUNTER = new AtomicLong(0L);

        @Override
        public Thread newThread(Runnable r) {
            Thread thread = new Thread(r, "testcontainers-lifecycle-" + this.COUNTER.getAndIncrement());
            thread.setDaemon(true);
            return thread;
        }
    });

    public static CompletableFuture<Void> deepStart(Collection<? extends Startable> startables) {
        return Startables.deepStart(startables);
    }

    public static CompletableFuture<Void> deepStart(Iterable<? extends Startable> startables) {
        return Startables.deepStart(StreamSupport.stream(startables.spliterator(), false));
    }

    public static CompletableFuture<Void> deepStart(Startable ... startables) {
        return Startables.deepStart(Arrays.stream(startables));
    }

    public static CompletableFuture<Void> deepStart(Stream<? extends Startable> startables) {
        return Startables.deepStart(new HashMap<Startable, CompletableFuture<Void>>(), startables);
    }

    private static CompletableFuture<Void> deepStart(Map<Startable, CompletableFuture<Void>> started, Stream<? extends Startable> startables) {
        CompletableFuture[] futures = (CompletableFuture[])((Stream)startables.sequential()).map(it -> {
            HashMap subStarted = new HashMap(started);
            CompletableFuture future = started.computeIfAbsent((Startable)it, startable -> Startables.deepStart(subStarted, startable.getDependencies().stream()).thenRunAsync(startable::start, EXECUTOR));
            started.putAll(subStarted);
            return future;
        }).toArray(CompletableFuture[]::new);
        return Startables.allOfFailfast(futures);
    }

    private static <T> CompletableFuture<Void> allOfFailfast(CompletableFuture<?>[] futures) {
        CompletableFuture<Void> result = CompletableFuture.allOf(futures);
        for (CompletableFuture<?> future : futures) {
            future.whenComplete((t, ex) -> {
                if (ex != null) {
                    result.completeExceptionally((Throwable)ex);
                }
            });
        }
        return result;
    }

    private Startables() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

