/*
 * Decompiled with CFR 0.152.
 */
package dev.monosoul.jooq.shadow.org.testcontainers.shaded.com.github.dockerjava.core;

import dev.monosoul.jooq.shadow.com.github.dockerjava.api.exception.DockerClientException;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.model.AuthConfig;
import dev.monosoul.jooq.shadow.com.github.dockerjava.api.model.AuthConfigurations;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.com.github.dockerjava.core.DockerClientConfig;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.com.github.dockerjava.core.DockerConfigFile;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.com.github.dockerjava.core.DockerContextMetaFile;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.com.github.dockerjava.core.LocalDirectorySSLConfig;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.com.github.dockerjava.core.NameParser;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.com.github.dockerjava.core.RemoteApiVersion;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.com.github.dockerjava.core.SSLConfig;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.apache.commons.lang3.BooleanUtils;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.apache.commons.lang3.StringUtils;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.apache.commons.lang3.SystemUtils;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.apache.commons.lang3.builder.EqualsBuilder;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.apache.commons.lang3.builder.HashCodeBuilder;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.apache.commons.lang3.builder.ToStringBuilder;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.apache.commons.lang3.builder.ToStringStyle;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;

public class DefaultDockerClientConfig
implements Serializable,
DockerClientConfig {
    private static final long serialVersionUID = 1L;
    public static final String DOCKER_HOST = "DOCKER_HOST";
    public static final String DOCKER_CONTEXT = "DOCKER_CONTEXT";
    public static final String DOCKER_TLS_VERIFY = "DOCKER_TLS_VERIFY";
    public static final String DOCKER_CONFIG = "DOCKER_CONFIG";
    public static final String DOCKER_CERT_PATH = "DOCKER_CERT_PATH";
    public static final String API_VERSION = "api.version";
    public static final String REGISTRY_USERNAME = "registry.username";
    public static final String REGISTRY_PASSWORD = "registry.password";
    public static final String REGISTRY_EMAIL = "registry.email";
    public static final String REGISTRY_URL = "registry.url";
    private static final String DOCKER_JAVA_PROPERTIES = "docker-java.properties";
    private static final Set<String> CONFIG_KEYS = new HashSet<String>();
    static final Properties DEFAULT_PROPERTIES = new Properties();
    static final String DEFAULT_DOCKER_HOST = "unix:///var/run/docker.sock";
    static final String WINDOWS_DEFAULT_DOCKER_HOST = "npipe:////./pipe/docker_engine";
    private final URI dockerHost;
    private final String registryUsername;
    private final String registryPassword;
    private final String registryEmail;
    private final String registryUrl;
    private final String dockerConfigPath;
    private final SSLConfig sslConfig;
    private final RemoteApiVersion apiVersion;
    private final DockerConfigFile dockerConfig;

    DefaultDockerClientConfig(URI dockerHost, DockerConfigFile dockerConfigFile, String dockerConfigPath, String apiVersion, String registryUrl, String registryUsername, String registryPassword, String registryEmail, SSLConfig sslConfig) {
        this.dockerHost = this.checkDockerHostScheme(dockerHost);
        this.dockerConfig = dockerConfigFile;
        this.dockerConfigPath = dockerConfigPath;
        this.apiVersion = RemoteApiVersion.parseConfigWithDefault(apiVersion);
        this.sslConfig = sslConfig;
        this.registryUsername = registryUsername;
        this.registryPassword = registryPassword;
        this.registryEmail = registryEmail;
        this.registryUrl = registryUrl;
    }

    private URI checkDockerHostScheme(URI dockerHost) {
        if (dockerHost == null) {
            throw new DockerClientException("'dockerHost' is null");
        }
        return dockerHost;
    }

    private static Properties loadIncludedDockerProperties(Properties systemProperties) {
        Properties p = new Properties();
        p.putAll((Map<?, ?>)DEFAULT_PROPERTIES);
        try (InputStream is = DefaultDockerClientConfig.class.getResourceAsStream("/docker-java.properties");){
            if (is != null) {
                p.load(is);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        DefaultDockerClientConfig.replaceProperties(p, systemProperties);
        return p;
    }

    private static void replaceProperties(Properties properties, Properties replacements) {
        for (Object objectKey : properties.keySet()) {
            String key = objectKey.toString();
            properties.setProperty(key, DefaultDockerClientConfig.replaceProperties(properties.getProperty(key), replacements));
        }
    }

    private static String replaceProperties(String s, Properties replacements) {
        for (Map.Entry<Object, Object> entry : replacements.entrySet()) {
            String key = "${" + entry.getKey() + "}";
            while (s.contains(key)) {
                s = s.replace(key, String.valueOf(entry.getValue()));
            }
        }
        return s;
    }

    private static Properties overrideDockerPropertiesWithSettingsFromUserHome(Properties p, Properties systemProperties) {
        Properties overriddenProperties = new Properties();
        overriddenProperties.putAll((Map<?, ?>)p);
        File usersDockerPropertiesFile = new File(systemProperties.getProperty("user.home"), ".docker-java.properties");
        if (usersDockerPropertiesFile.isFile()) {
            try (FileInputStream in = new FileInputStream(usersDockerPropertiesFile);){
                overriddenProperties.load(in);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return overriddenProperties;
    }

    private static Properties overrideDockerPropertiesWithEnv(Properties properties, Map<String, String> env) {
        String value;
        Properties overriddenProperties = new Properties();
        overriddenProperties.putAll((Map<?, ?>)properties);
        if (env.containsKey(DOCKER_HOST) && (value = env.get(DOCKER_HOST)) != null && value.trim().length() != 0) {
            overriddenProperties.setProperty(DOCKER_HOST, value);
        }
        if (env.containsKey(DOCKER_CONTEXT) && (value = env.get(DOCKER_CONTEXT)) != null && value.trim().length() != 0) {
            overriddenProperties.setProperty(DOCKER_CONTEXT, value);
        }
        for (Map.Entry<String, String> envEntry : env.entrySet()) {
            String value2;
            String envKey = envEntry.getKey();
            if (!CONFIG_KEYS.contains(envKey) || (value2 = envEntry.getValue()) == null || value2.trim().length() == 0) continue;
            overriddenProperties.setProperty(envKey, value2);
        }
        return overriddenProperties;
    }

    private static Properties overrideDockerPropertiesWithSystemProperties(Properties p, Properties systemProperties) {
        Properties overriddenProperties = new Properties();
        overriddenProperties.putAll((Map<?, ?>)p);
        for (String key : CONFIG_KEYS) {
            if (!systemProperties.containsKey(key)) continue;
            overriddenProperties.setProperty(key, systemProperties.getProperty(key));
        }
        return overriddenProperties;
    }

    public static Builder createDefaultConfigBuilder() {
        return DefaultDockerClientConfig.createDefaultConfigBuilder(System.getenv(), (Properties)System.getProperties().clone());
    }

    static Builder createDefaultConfigBuilder(Map<String, String> env, Properties systemProperties) {
        Properties properties = DefaultDockerClientConfig.loadIncludedDockerProperties(systemProperties);
        properties = DefaultDockerClientConfig.overrideDockerPropertiesWithSettingsFromUserHome(properties, systemProperties);
        properties = DefaultDockerClientConfig.overrideDockerPropertiesWithEnv(properties, env);
        properties = DefaultDockerClientConfig.overrideDockerPropertiesWithSystemProperties(properties, systemProperties);
        return new Builder().withProperties(properties);
    }

    @Override
    public URI getDockerHost() {
        return this.dockerHost;
    }

    @Override
    public RemoteApiVersion getApiVersion() {
        return this.apiVersion;
    }

    @Override
    public String getRegistryUsername() {
        return this.registryUsername;
    }

    @Override
    public String getRegistryPassword() {
        return this.registryPassword;
    }

    @Override
    public String getRegistryEmail() {
        return this.registryEmail;
    }

    @Override
    public String getRegistryUrl() {
        return this.registryUrl;
    }

    @CheckForNull
    public String getDockerConfigPath() {
        return this.dockerConfigPath;
    }

    @Nonnull
    public DockerConfigFile getDockerConfig() {
        return this.dockerConfig;
    }

    private AuthConfig getAuthConfig() {
        AuthConfig authConfig = null;
        if (this.getRegistryUsername() != null && this.getRegistryPassword() != null && this.getRegistryUrl() != null) {
            authConfig = new AuthConfig().withUsername(this.getRegistryUsername()).withPassword(this.getRegistryPassword()).withEmail(this.getRegistryEmail()).withRegistryAddress(this.getRegistryUrl());
        }
        return authConfig;
    }

    @Override
    public AuthConfig effectiveAuthConfig(String imageName) {
        AuthConfig authConfig = this.getAuthConfig();
        if (authConfig != null) {
            return authConfig;
        }
        DockerConfigFile dockerCfg = this.getDockerConfig();
        NameParser.ReposTag reposTag = NameParser.parseRepositoryTag(imageName);
        NameParser.HostnameReposName hostnameReposName = NameParser.resolveRepositoryName(reposTag.repos);
        return dockerCfg.resolveAuthConfig(hostnameReposName.hostname);
    }

    @Override
    public AuthConfigurations getAuthConfigurations() {
        return this.getDockerConfig().getAuthConfigurations();
    }

    @Override
    public SSLConfig getSSLConfig() {
        return this.sslConfig;
    }

    public boolean equals(Object o) {
        return EqualsBuilder.reflectionEquals((Object)this, o, new String[0]);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this, new String[0]);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this, ToStringStyle.SHORT_PREFIX_STYLE);
    }

    static {
        CONFIG_KEYS.add(DOCKER_HOST);
        CONFIG_KEYS.add(DOCKER_TLS_VERIFY);
        CONFIG_KEYS.add(DOCKER_CONFIG);
        CONFIG_KEYS.add(DOCKER_CERT_PATH);
        CONFIG_KEYS.add(API_VERSION);
        CONFIG_KEYS.add(REGISTRY_USERNAME);
        CONFIG_KEYS.add(REGISTRY_PASSWORD);
        CONFIG_KEYS.add(REGISTRY_EMAIL);
        CONFIG_KEYS.add(REGISTRY_URL);
        DEFAULT_PROPERTIES.put(DOCKER_CONFIG, "${user.home}/.docker");
        DEFAULT_PROPERTIES.put(REGISTRY_URL, "https://index.docker.io/v1/");
        DEFAULT_PROPERTIES.put(REGISTRY_USERNAME, "${user.name}");
    }

    public static class Builder {
        private URI dockerHost;
        private String apiVersion;
        private String registryUsername;
        private String registryPassword;
        private String registryEmail;
        private String registryUrl;
        private String dockerConfig;
        private String dockerCertPath;
        private String dockerContext;
        private Boolean dockerTlsVerify;
        private SSLConfig customSslConfig = null;

        public Builder withProperties(Properties p) {
            if (p.getProperty(DefaultDockerClientConfig.DOCKER_HOST) != null) {
                this.withDockerHost(p.getProperty(DefaultDockerClientConfig.DOCKER_HOST));
            }
            return this.withDockerTlsVerify(p.getProperty(DefaultDockerClientConfig.DOCKER_TLS_VERIFY)).withDockerContext(p.getProperty(DefaultDockerClientConfig.DOCKER_CONTEXT)).withDockerConfig(p.getProperty(DefaultDockerClientConfig.DOCKER_CONFIG)).withDockerCertPath(p.getProperty(DefaultDockerClientConfig.DOCKER_CERT_PATH)).withApiVersion(p.getProperty(DefaultDockerClientConfig.API_VERSION)).withRegistryUsername(p.getProperty(DefaultDockerClientConfig.REGISTRY_USERNAME)).withRegistryPassword(p.getProperty(DefaultDockerClientConfig.REGISTRY_PASSWORD)).withRegistryEmail(p.getProperty(DefaultDockerClientConfig.REGISTRY_EMAIL)).withRegistryUrl(p.getProperty(DefaultDockerClientConfig.REGISTRY_URL));
        }

        public final Builder withDockerHost(String dockerHost) {
            Objects.requireNonNull(dockerHost, "uri was not specified");
            this.dockerHost = URI.create(dockerHost);
            return this;
        }

        public final Builder withApiVersion(RemoteApiVersion apiVersion) {
            this.apiVersion = apiVersion.getVersion();
            return this;
        }

        public final Builder withApiVersion(String apiVersion) {
            this.apiVersion = apiVersion;
            return this;
        }

        public final Builder withRegistryUsername(String registryUsername) {
            this.registryUsername = registryUsername;
            return this;
        }

        public final Builder withRegistryPassword(String registryPassword) {
            this.registryPassword = registryPassword;
            return this;
        }

        public final Builder withRegistryEmail(String registryEmail) {
            this.registryEmail = registryEmail;
            return this;
        }

        public Builder withRegistryUrl(String registryUrl) {
            this.registryUrl = registryUrl;
            return this;
        }

        public final Builder withDockerCertPath(String dockerCertPath) {
            this.dockerCertPath = dockerCertPath;
            return this;
        }

        public final Builder withDockerConfig(String dockerConfig) {
            this.dockerConfig = dockerConfig;
            return this;
        }

        public final Builder withDockerContext(String dockerContext) {
            this.dockerContext = dockerContext;
            return this;
        }

        public final Builder withDockerTlsVerify(String dockerTlsVerify) {
            String trimmed;
            this.dockerTlsVerify = dockerTlsVerify != null ? Boolean.valueOf("true".equalsIgnoreCase(trimmed = dockerTlsVerify.trim()) || "1".equals(trimmed)) : Boolean.valueOf(false);
            return this;
        }

        public final Builder withDockerTlsVerify(Boolean dockerTlsVerify) {
            this.dockerTlsVerify = dockerTlsVerify;
            return this;
        }

        public final boolean isDockerHostSetExplicitly() {
            return this.dockerHost != null;
        }

        public final Builder withCustomSslConfig(SSLConfig customSslConfig) {
            this.customSslConfig = customSslConfig;
            return this;
        }

        private void applyContextConfiguration(String context) {
            Optional<DockerContextMetaFile.Endpoints> dockerContextMetaFile = Optional.ofNullable(context).flatMap(ctx -> DockerContextMetaFile.resolveContextMetaFile(DockerClientConfig.getDefaultObjectMapper(), new File(this.dockerConfig), ctx));
            Optional dockerContextTLSFile = Optional.ofNullable(context).flatMap(ctx -> DockerContextMetaFile.resolveContextTLSFile(new File(this.dockerConfig), ctx));
            if (dockerContextMetaFile.isPresent()) {
                Optional<DockerContextMetaFile.Endpoints.Docker> dockerEndpoint = dockerContextMetaFile.map(metaFile -> metaFile.endpoints).map(endpoint -> endpoint.docker);
                if (this.dockerHost == null) {
                    this.dockerHost = dockerEndpoint.map(endpoint -> endpoint.host).map(URI::create).orElse(null);
                }
            }
            if (dockerContextTLSFile.isPresent() && this.dockerCertPath == null) {
                this.dockerCertPath = ((File)dockerContextTLSFile.get()).getAbsolutePath();
                this.dockerTlsVerify = true;
            }
        }

        public DefaultDockerClientConfig build() {
            DockerConfigFile dockerConfigFile = this.readDockerConfig();
            String context = this.dockerContext != null ? this.dockerContext : dockerConfigFile.getCurrentContext();
            this.applyContextConfiguration(context);
            SSLConfig sslConfig = null;
            if (this.customSslConfig == null) {
                if (BooleanUtils.isTrue(this.dockerTlsVerify)) {
                    this.dockerCertPath = this.checkDockerCertPath(this.dockerCertPath);
                    sslConfig = new LocalDirectorySSLConfig(this.dockerCertPath);
                }
            } else {
                sslConfig = this.customSslConfig;
            }
            URI dockerHostUri = this.dockerHost != null ? this.dockerHost : URI.create(SystemUtils.IS_OS_WINDOWS ? DefaultDockerClientConfig.WINDOWS_DEFAULT_DOCKER_HOST : DefaultDockerClientConfig.DEFAULT_DOCKER_HOST);
            return new DefaultDockerClientConfig(dockerHostUri, dockerConfigFile, this.dockerConfig, this.apiVersion, this.registryUrl, this.registryUsername, this.registryPassword, this.registryEmail, sslConfig);
        }

        private DockerConfigFile readDockerConfig() {
            try {
                return DockerConfigFile.loadConfig(DockerClientConfig.getDefaultObjectMapper(), this.dockerConfig);
            }
            catch (IOException e) {
                throw new DockerClientException("Failed to parse docker configuration file", e);
            }
        }

        private String checkDockerCertPath(String dockerCertPath) {
            if (StringUtils.isEmpty(dockerCertPath)) {
                throw new DockerClientException("Enabled TLS verification (DOCKER_TLS_VERIFY=1) but certificate path (DOCKER_CERT_PATH) is not defined.");
            }
            File certPath = new File(dockerCertPath);
            if (!certPath.exists()) {
                throw new DockerClientException("Enabled TLS verification (DOCKER_TLS_VERIFY=1) but certificate path (DOCKER_CERT_PATH) '" + dockerCertPath + "' doesn't exist.");
            }
            if (!certPath.isDirectory()) {
                throw new DockerClientException("Enabled TLS verification (DOCKER_TLS_VERIFY=1) but certificate path (DOCKER_CERT_PATH) '" + dockerCertPath + "' doesn't point to a directory.");
            }
            return dockerCertPath;
        }
    }
}

