/*
 * Decompiled with CFR 0.152.
 */
package dev.monosoul.jooq.shadow.org.testcontainers.shaded.com.google.common.collect;

import dev.monosoul.jooq.shadow.org.testcontainers.shaded.com.google.common.annotations.GwtCompatible;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.com.google.common.annotations.VisibleForTesting;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.com.google.common.collect.Hashing;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.com.google.common.collect.ImmutableList;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.com.google.common.collect.ImmutableSet;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.com.google.common.collect.Iterators;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.com.google.common.collect.ObjectArrays;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.com.google.common.collect.RegularImmutableAsList;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.com.google.common.collect.UnmodifiableIterator;
import javax.annotation.Nullable;

@GwtCompatible(serializable=true, emulated=true)
final class RegularImmutableSet<E>
extends ImmutableSet<E> {
    static final RegularImmutableSet<Object> EMPTY = new RegularImmutableSet(ObjectArrays.EMPTY_ARRAY, 0, null, 0);
    private final transient Object[] elements;
    @VisibleForTesting
    final transient Object[] table;
    private final transient int mask;
    private final transient int hashCode;

    RegularImmutableSet(Object[] elements, int hashCode, Object[] table2, int mask) {
        this.elements = elements;
        this.table = table2;
        this.mask = mask;
        this.hashCode = hashCode;
    }

    @Override
    public boolean contains(@Nullable Object target) {
        Object[] table2 = this.table;
        if (target == null || table2 == null) {
            return false;
        }
        int i = Hashing.smearedHash(target);
        Object candidate;
        while ((candidate = table2[i &= this.mask]) != null) {
            if (candidate.equals(target)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public int size() {
        return this.elements.length;
    }

    @Override
    public UnmodifiableIterator<E> iterator() {
        return Iterators.forArray(this.elements);
    }

    @Override
    int copyIntoArray(Object[] dst, int offset) {
        System.arraycopy(this.elements, 0, dst, offset, this.elements.length);
        return offset + this.elements.length;
    }

    @Override
    ImmutableList<E> createAsList() {
        return this.table == null ? ImmutableList.of() : new RegularImmutableAsList(this, this.elements);
    }

    @Override
    boolean isPartialView() {
        return false;
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    @Override
    boolean isHashCodeFast() {
        return true;
    }
}

