/*
 * Decompiled with CFR 0.152.
 */
package dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.awaitility.core;

import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.awaitility.core.CheckedExceptionRethrower;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.awaitility.core.Condition;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.awaitility.core.ConditionAwaiter;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.awaitility.core.ConditionEvaluationHandler;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.awaitility.core.ConditionEvaluationResult;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.awaitility.core.ConditionEvaluator;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.awaitility.core.ConditionSettings;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.awaitility.core.LambdaErrorMessageGenerator;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.awaitility.core.ThrowingRunnable;
import java.lang.reflect.Method;

public class AssertionCondition
implements Condition<Void> {
    private final ConditionAwaiter conditionAwaiter;
    private String lastExceptionMessage;
    private final ConditionEvaluationHandler<Object> conditionEvaluationHandler;

    public AssertionCondition(final ThrowingRunnable supplier, final ConditionSettings settings) {
        if (supplier == null) {
            throw new IllegalArgumentException("You must specify a supplier (was null).");
        }
        this.conditionEvaluationHandler = new ConditionEvaluationHandler(null, settings);
        ConditionEvaluator callable = pollInterval -> {
            try {
                supplier.run();
                this.conditionEvaluationHandler.handleConditionResultMatch(this.getMatchMessage(supplier, settings.getAlias()), null, pollInterval);
                return new ConditionEvaluationResult(true);
            }
            catch (AssertionError e) {
                this.lastExceptionMessage = ((Throwable)((Object)e)).getMessage();
                this.conditionEvaluationHandler.handleConditionResultMismatch(this.getMismatchMessage(supplier, this.lastExceptionMessage, settings.getAlias(), true), null, pollInterval);
                return new ConditionEvaluationResult(false, null, (Throwable)((Object)e));
            }
            catch (Throwable throwable) {
                return (ConditionEvaluationResult)CheckedExceptionRethrower.safeRethrow(throwable);
            }
        };
        this.conditionAwaiter = new ConditionAwaiter(callable, settings){

            @Override
            protected String getTimeoutMessage() {
                return AssertionCondition.this.getMismatchMessage(supplier, AssertionCondition.this.lastExceptionMessage, settings.getAlias(), false);
            }
        };
    }

    private String getMatchMessage(ThrowingRunnable supplier, String conditionAlias) {
        return this.generateDescriptionPrefix(supplier, conditionAlias, true) + " reached its end value";
    }

    private String getMismatchMessage(ThrowingRunnable supplier, String exceptionMessage, String conditionAlias, boolean includeAliasIfDefined) {
        if (exceptionMessage != null && exceptionMessage.endsWith(".")) {
            exceptionMessage = exceptionMessage.substring(0, exceptionMessage.length() - 1);
        }
        return this.generateDescriptionPrefix(supplier, conditionAlias, includeAliasIfDefined) + " " + exceptionMessage;
    }

    private String generateDescriptionPrefix(ThrowingRunnable supplier, String conditionAlias, boolean includeAliasIfDefined) {
        boolean hasAlias;
        String methodDescription = this.generateMethodDescription(supplier);
        boolean bl = hasAlias = conditionAlias != null;
        if (LambdaErrorMessageGenerator.isLambdaClass(supplier.getClass())) {
            String prefix = hasAlias && includeAliasIfDefined ? "Assertion condition with alias " + conditionAlias + " defined as a " : "Assertion condition defined as a ";
            return prefix + LambdaErrorMessageGenerator.generateLambdaErrorMessagePrefix(supplier.getClass(), false) + methodDescription;
        }
        return "Assertion condition" + (hasAlias ? " with alias " + conditionAlias : "") + methodDescription;
    }

    private String generateMethodDescription(ThrowingRunnable supplier) {
        String methodDescription = "";
        Method enclosingMethod = null;
        try {
            enclosingMethod = supplier.getClass().getEnclosingMethod();
        }
        catch (Error error) {
            // empty catch block
        }
        if (enclosingMethod != null) {
            methodDescription = " defined in " + enclosingMethod.toString();
        }
        return methodDescription;
    }

    @Override
    public Void await() {
        this.conditionAwaiter.await(this.conditionEvaluationHandler);
        return null;
    }
}

