/*
 * Decompiled with CFR 0.152.
 */
package dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.bouncycastle.cms.bc;

import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.bouncycastle.cert.X509CertificateHolder;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.bouncycastle.cms.CMSSignatureAlgorithmNameGenerator;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.bouncycastle.cms.SignerInformationVerifier;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.bouncycastle.operator.DigestAlgorithmIdentifierFinder;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.bouncycastle.operator.DigestCalculatorProvider;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.bouncycastle.operator.OperatorCreationException;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.bouncycastle.operator.SignatureAlgorithmIdentifierFinder;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.bouncycastle.operator.bc.BcRSAContentVerifierProviderBuilder;

public class BcRSASignerInfoVerifierBuilder {
    private BcRSAContentVerifierProviderBuilder contentVerifierProviderBuilder;
    private DigestCalculatorProvider digestCalculatorProvider;
    private CMSSignatureAlgorithmNameGenerator sigAlgNameGen;
    private SignatureAlgorithmIdentifierFinder sigAlgIdFinder;

    public BcRSASignerInfoVerifierBuilder(CMSSignatureAlgorithmNameGenerator cMSSignatureAlgorithmNameGenerator, SignatureAlgorithmIdentifierFinder signatureAlgorithmIdentifierFinder, DigestAlgorithmIdentifierFinder digestAlgorithmIdentifierFinder, DigestCalculatorProvider digestCalculatorProvider) {
        this.sigAlgNameGen = cMSSignatureAlgorithmNameGenerator;
        this.sigAlgIdFinder = signatureAlgorithmIdentifierFinder;
        this.contentVerifierProviderBuilder = new BcRSAContentVerifierProviderBuilder(digestAlgorithmIdentifierFinder);
        this.digestCalculatorProvider = digestCalculatorProvider;
    }

    public SignerInformationVerifier build(X509CertificateHolder x509CertificateHolder) throws OperatorCreationException {
        return new SignerInformationVerifier(this.sigAlgNameGen, this.sigAlgIdFinder, this.contentVerifierProviderBuilder.build(x509CertificateHolder), this.digestCalculatorProvider);
    }

    public SignerInformationVerifier build(AsymmetricKeyParameter asymmetricKeyParameter) throws OperatorCreationException {
        return new SignerInformationVerifier(this.sigAlgNameGen, this.sigAlgIdFinder, this.contentVerifierProviderBuilder.build(asymmetricKeyParameter), this.digestCalculatorProvider);
    }
}

