/*
 * Decompiled with CFR 0.152.
 */
package dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.bouncycastle.crypto.agreement;

import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.bouncycastle.crypto.BasicAgreement;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.bouncycastle.crypto.CipherParameters;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.bouncycastle.crypto.RawAgreement;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.bouncycastle.crypto.agreement.X25519Agreement;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.bouncycastle.crypto.agreement.X448Agreement;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.bouncycastle.crypto.params.X25519PrivateKeyParameters;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.bouncycastle.crypto.params.X448PrivateKeyParameters;
import java.math.BigInteger;

public class XDHBasicAgreement
implements BasicAgreement {
    private AsymmetricKeyParameter key;
    private RawAgreement agreement;
    private int fieldSize = 0;

    @Override
    public void init(CipherParameters cipherParameters) {
        if (cipherParameters instanceof X25519PrivateKeyParameters) {
            this.fieldSize = 32;
            this.agreement = new X25519Agreement();
        } else if (cipherParameters instanceof X448PrivateKeyParameters) {
            this.fieldSize = 56;
            this.agreement = new X448Agreement();
        } else {
            throw new IllegalArgumentException("key is neither X25519 nor X448");
        }
        this.key = (AsymmetricKeyParameter)cipherParameters;
        this.agreement.init(cipherParameters);
    }

    @Override
    public int getFieldSize() {
        return this.fieldSize;
    }

    @Override
    public BigInteger calculateAgreement(CipherParameters cipherParameters) {
        byte[] byArray = new byte[this.fieldSize];
        this.agreement.calculateAgreement(cipherParameters, byArray, 0);
        return new BigInteger(1, byArray);
    }
}

