/*
 * Decompiled with CFR 0.152.
 */
package dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.bouncycastle.dvcs;

import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.bouncycastle.asn1.dvcs.CertEtcToken;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.bouncycastle.asn1.dvcs.DVCSRequestInformationBuilder;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.bouncycastle.asn1.dvcs.DVCSTime;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.bouncycastle.asn1.dvcs.Data;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.bouncycastle.asn1.dvcs.ServiceType;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.bouncycastle.asn1.dvcs.TargetEtcChain;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.bouncycastle.asn1.x509.Extension;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.bouncycastle.cert.X509CertificateHolder;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.bouncycastle.dvcs.DVCSException;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.bouncycastle.dvcs.DVCSRequest;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.bouncycastle.dvcs.DVCSRequestBuilder;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.bouncycastle.dvcs.TargetChain;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class VPKCRequestBuilder
extends DVCSRequestBuilder {
    private List chains = new ArrayList();

    public VPKCRequestBuilder() {
        super(new DVCSRequestInformationBuilder(ServiceType.VPKC));
    }

    public void addTargetChain(X509CertificateHolder x509CertificateHolder) {
        this.chains.add(new TargetEtcChain(new CertEtcToken(0, x509CertificateHolder.toASN1Structure())));
    }

    public void addTargetChain(Extension extension) {
        this.chains.add(new TargetEtcChain(new CertEtcToken(extension)));
    }

    public void addTargetChain(TargetChain targetChain) {
        this.chains.add(targetChain.toASN1Structure());
    }

    public void setRequestTime(Date date) {
        this.requestInformationBuilder.setRequestTime(new DVCSTime(date));
    }

    public DVCSRequest build() throws DVCSException {
        Data data = new Data(this.chains.toArray(new TargetEtcChain[this.chains.size()]));
        return this.createDVCRequest(data);
    }
}

