/*
 * Decompiled with CFR 0.152.
 */
package dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.bouncycastle.pqc.crypto.cmce;

import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.bouncycastle.crypto.EncapsulatedSecretGenerator;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.bouncycastle.crypto.SecretWithEncapsulation;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.bouncycastle.pqc.crypto.cmce.CMCEEngine;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.bouncycastle.pqc.crypto.cmce.CMCEPublicKeyParameters;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.bouncycastle.pqc.crypto.util.SecretWithEncapsulationImpl;
import java.security.SecureRandom;

public class CMCEKEMGenerator
implements EncapsulatedSecretGenerator {
    private final SecureRandom sr;

    public CMCEKEMGenerator(SecureRandom secureRandom) {
        this.sr = secureRandom;
    }

    @Override
    public SecretWithEncapsulation generateEncapsulated(AsymmetricKeyParameter asymmetricKeyParameter) {
        CMCEPublicKeyParameters cMCEPublicKeyParameters = (CMCEPublicKeyParameters)asymmetricKeyParameter;
        CMCEEngine cMCEEngine = cMCEPublicKeyParameters.getParameters().getEngine();
        return this.generateEncapsulated(asymmetricKeyParameter, cMCEEngine.getDefaultSessionKeySize());
    }

    public SecretWithEncapsulation generateEncapsulated(AsymmetricKeyParameter asymmetricKeyParameter, int n) {
        CMCEPublicKeyParameters cMCEPublicKeyParameters = (CMCEPublicKeyParameters)asymmetricKeyParameter;
        CMCEEngine cMCEEngine = cMCEPublicKeyParameters.getParameters().getEngine();
        byte[] byArray = new byte[cMCEEngine.getCipherTextSize()];
        byte[] byArray2 = new byte[n / 8];
        cMCEEngine.kem_enc(byArray, byArray2, cMCEPublicKeyParameters.getPublicKey(), this.sr);
        return new SecretWithEncapsulationImpl(byArray2, byArray);
    }
}

