/*
 * Decompiled with CFR 0.152.
 */
package dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.bouncycastle.pqc.crypto.crystals.kyber;

import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.bouncycastle.crypto.EncapsulatedSecretGenerator;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.bouncycastle.crypto.SecretWithEncapsulation;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.bouncycastle.pqc.crypto.crystals.kyber.KyberEngine;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.bouncycastle.pqc.crypto.crystals.kyber.KyberPublicKeyParameters;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.bouncycastle.pqc.crypto.util.SecretWithEncapsulationImpl;
import java.security.SecureRandom;

public class KyberKEMGenerator
implements EncapsulatedSecretGenerator {
    private final SecureRandom sr;

    public KyberKEMGenerator(SecureRandom secureRandom) {
        this.sr = secureRandom;
    }

    @Override
    public SecretWithEncapsulation generateEncapsulated(AsymmetricKeyParameter asymmetricKeyParameter) {
        KyberPublicKeyParameters kyberPublicKeyParameters = (KyberPublicKeyParameters)asymmetricKeyParameter;
        KyberEngine kyberEngine = kyberPublicKeyParameters.getParameters().getEngine();
        kyberEngine.init(this.sr);
        byte[][] byArray = kyberEngine.kemEncrypt(kyberPublicKeyParameters.getEncoded());
        return new SecretWithEncapsulationImpl(byArray[0], byArray[1]);
    }
}

