/*
 * Decompiled with CFR 0.152.
 */
package dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.bouncycastle.tsp.cms;

import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.bouncycastle.asn1.BEROctetString;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.bouncycastle.asn1.DERIA5String;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.bouncycastle.asn1.cms.ContentInfo;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.bouncycastle.asn1.cms.Evidence;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.bouncycastle.asn1.cms.TimeStampAndCRL;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.bouncycastle.asn1.cms.TimeStampTokenEvidence;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.bouncycastle.asn1.cms.TimeStampedData;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.bouncycastle.cms.CMSException;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.bouncycastle.tsp.TimeStampToken;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.bouncycastle.tsp.cms.CMSTimeStampedData;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.bouncycastle.tsp.cms.CMSTimeStampedGenerator;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.bouncycastle.util.io.Streams;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class CMSTimeStampedDataGenerator
extends CMSTimeStampedGenerator {
    public CMSTimeStampedData generate(TimeStampToken timeStampToken) throws CMSException {
        return this.generate(timeStampToken, (InputStream)null);
    }

    public CMSTimeStampedData generate(TimeStampToken timeStampToken, byte[] byArray) throws CMSException {
        return this.generate(timeStampToken, new ByteArrayInputStream(byArray));
    }

    public CMSTimeStampedData generate(TimeStampToken timeStampToken, InputStream inputStream) throws CMSException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        if (inputStream != null) {
            try {
                Streams.pipeAll(inputStream, byteArrayOutputStream);
            }
            catch (IOException iOException) {
                throw new CMSException("exception encapsulating content: " + iOException.getMessage(), iOException);
            }
        }
        BEROctetString bEROctetString = null;
        if (byteArrayOutputStream.size() != 0) {
            bEROctetString = new BEROctetString(byteArrayOutputStream.toByteArray());
        }
        TimeStampAndCRL timeStampAndCRL = new TimeStampAndCRL(timeStampToken.toCMSSignedData().toASN1Structure());
        DERIA5String dERIA5String = null;
        if (this.dataUri != null) {
            dERIA5String = new DERIA5String(this.dataUri.toString());
        }
        return new CMSTimeStampedData(new ContentInfo(CMSObjectIdentifiers.timestampedData, new TimeStampedData(dERIA5String, this.metaData, bEROctetString, new Evidence(new TimeStampTokenEvidence(timeStampAndCRL)))));
    }
}

