/*
 * Decompiled with CFR 0.152.
 */
package dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.zeroturnaround.exec;

import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.zeroturnaround.exec.InvalidExitUtil;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.zeroturnaround.exec.InvalidExitValueException;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.zeroturnaround.exec.InvalidOutputException;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.zeroturnaround.exec.InvalidResultException;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.zeroturnaround.exec.MDCCallableAdapter;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.zeroturnaround.exec.MessageLogger;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.zeroturnaround.exec.MessageLoggers;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.zeroturnaround.exec.ProcessAttributes;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.zeroturnaround.exec.ProcessInitException;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.zeroturnaround.exec.ProcessResult;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.zeroturnaround.exec.StartedProcess;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.zeroturnaround.exec.WaitForProcess;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.zeroturnaround.exec.close.ProcessCloser;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.zeroturnaround.exec.close.StandardProcessCloser;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.zeroturnaround.exec.close.TimeoutProcessCloser;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.zeroturnaround.exec.listener.CompositeProcessListener;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.zeroturnaround.exec.listener.DestroyerListenerAdapter;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.zeroturnaround.exec.listener.ProcessDestroyer;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.zeroturnaround.exec.listener.ProcessListener;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.zeroturnaround.exec.listener.ShutdownHookProcessDestroyer;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.zeroturnaround.exec.stop.DestroyProcessStopper;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.zeroturnaround.exec.stop.NopProcessStopper;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.zeroturnaround.exec.stop.ProcessStopper;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.zeroturnaround.exec.stream.CallerLoggerUtil;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.zeroturnaround.exec.stream.ExecuteStreamHandler;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.zeroturnaround.exec.stream.NullOutputStream;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.zeroturnaround.exec.stream.PumpStreamHandler;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.zeroturnaround.exec.stream.TeeOutputStream;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.zeroturnaround.exec.stream.slf4j.Slf4jDebugOutputStream;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.zeroturnaround.exec.stream.slf4j.Slf4jInfoOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class ProcessExecutor {
    private static final Logger log = LoggerFactory.getLogger(ProcessExecutor.class);
    private static final boolean IS_OS_WINDOWS = System.getProperty("os.name").startsWith("Windows");
    public static final Integer[] DEFAULT_EXIT_VALUES = null;
    private static final Integer NORMAL_EXIT_VALUE = 0;
    public static final boolean DEFAULT_REDIRECT_ERROR_STREAM = true;
    private final ProcessBuilder builder = new ProcessBuilder(new String[0]);
    private final Map<String, String> environment = new LinkedHashMap<String, String>();
    private Set<Integer> allowedExitValues;
    private Long timeout;
    private TimeUnit timeoutUnit;
    private ProcessStopper stopper;
    private ExecuteStreamHandler streams;
    private Long closeTimeout;
    private TimeUnit closeTimeoutUnit;
    private boolean readOutput;
    private final CompositeProcessListener listeners = new CompositeProcessListener();
    private MessageLogger messageLogger = MessageLoggers.DEBUG;

    public ProcessExecutor() {
        this.exitValues(DEFAULT_EXIT_VALUES);
        this.stopper(DestroyProcessStopper.INSTANCE);
        this.redirectOutput(null);
        this.redirectError(null);
        this.destroyer(null);
        this.redirectErrorStream(true);
    }

    public ProcessExecutor(List<String> command) {
        this.exitValues(DEFAULT_EXIT_VALUES);
        this.stopper(DestroyProcessStopper.INSTANCE);
        this.redirectOutput(null);
        this.redirectError(null);
        this.destroyer(null);
        this.redirectErrorStream(true);
        this.command(command);
    }

    public ProcessExecutor(String ... command) {
        this.exitValues(DEFAULT_EXIT_VALUES);
        this.stopper(DestroyProcessStopper.INSTANCE);
        this.redirectOutput(null);
        this.redirectError(null);
        this.destroyer(null);
        this.redirectErrorStream(true);
        this.command(command);
    }

    public ProcessExecutor(Iterable<String> command) {
        this.exitValues(DEFAULT_EXIT_VALUES);
        this.stopper(DestroyProcessStopper.INSTANCE);
        this.redirectOutput(null);
        this.redirectError(null);
        this.destroyer(null);
        this.redirectErrorStream(true);
        this.command(command);
    }

    public List<String> getCommand() {
        return new ArrayList<String>(this.builder.command());
    }

    public ProcessExecutor command(List<String> command) {
        this.builder.command(ProcessExecutor.fixArguments(command));
        return this;
    }

    public ProcessExecutor command(String ... command) {
        this.builder.command(ProcessExecutor.fixArguments(Arrays.asList(command)));
        return this;
    }

    public ProcessExecutor command(Iterable<String> command) {
        ArrayList<String> list = new ArrayList<String>();
        Iterator<String> it = command.iterator();
        while (it.hasNext()) {
            list.add(it.next());
        }
        return this.command((List<String>)list);
    }

    public ProcessExecutor commandSplit(String commandWithArgs) {
        this.builder.command(commandWithArgs.split("\\s+"));
        return this;
    }

    public File getDirectory() {
        return this.builder.directory();
    }

    public ProcessExecutor directory(File directory) {
        this.builder.directory(directory);
        return this;
    }

    public Map<String, String> getEnvironment() {
        return this.environment;
    }

    public ProcessExecutor environment(Map<String, String> env) {
        this.environment.putAll(env);
        return this;
    }

    public ProcessExecutor environment(String name, String value) {
        this.environment.put(name, value);
        return this;
    }

    public ProcessExecutor redirectErrorStream(boolean redirectErrorStream) {
        this.builder.redirectErrorStream(redirectErrorStream);
        return this;
    }

    public ProcessExecutor exitValueAny() {
        return this.exitValues((Integer[])null);
    }

    public ProcessExecutor exitValueNormal() {
        return this.exitValues(NORMAL_EXIT_VALUE);
    }

    public ProcessExecutor exitValue(Integer exitValue) {
        Integer[] integerArray;
        if (exitValue == null) {
            integerArray = null;
        } else {
            Integer[] integerArray2 = new Integer[1];
            integerArray = integerArray2;
            integerArray2[0] = exitValue;
        }
        return this.exitValues(integerArray);
    }

    public ProcessExecutor exitValues(Integer ... exitValues) {
        this.allowedExitValues = exitValues == null ? null : new HashSet<Integer>(Arrays.asList(exitValues));
        return this;
    }

    public ProcessExecutor exitValues(int[] exitValues) {
        if (exitValues == null) {
            return this.exitValueAny();
        }
        Integer[] array = new Integer[exitValues.length];
        for (int i = 0; i < array.length; ++i) {
            array[i] = exitValues[i];
        }
        return this.exitValues(array);
    }

    public ProcessExecutor timeout(long timeout, TimeUnit unit) {
        this.timeout = timeout;
        this.timeoutUnit = unit;
        return this;
    }

    public ProcessExecutor stopper(ProcessStopper stopper) {
        if (stopper == null) {
            stopper = NopProcessStopper.INSTANCE;
        }
        this.stopper = stopper;
        return this;
    }

    public ExecuteStreamHandler streams() {
        return this.streams;
    }

    public ProcessExecutor streams(ExecuteStreamHandler streams) {
        this.validateStreams(streams, this.readOutput);
        this.streams = streams;
        return this;
    }

    public ProcessExecutor closeTimeout(long timeout, TimeUnit unit) {
        this.closeTimeout = timeout;
        this.closeTimeoutUnit = unit;
        return this;
    }

    public ProcessExecutor redirectInput(InputStream input) {
        PumpStreamHandler pumps = this.pumps();
        return this.streams(new PumpStreamHandler(pumps == null ? null : pumps.getOut(), pumps == null ? null : pumps.getErr(), input));
    }

    public ProcessExecutor redirectOutput(OutputStream output) {
        PumpStreamHandler pumps;
        if (output == null) {
            output = NullOutputStream.NULL_OUTPUT_STREAM;
        }
        return this.streams(new PumpStreamHandler(output, (pumps = this.pumps()) == null ? null : pumps.getErr(), pumps == null ? null : pumps.getInput()));
    }

    public ProcessExecutor redirectError(OutputStream output) {
        PumpStreamHandler pumps;
        if (output == null) {
            output = NullOutputStream.NULL_OUTPUT_STREAM;
        }
        this.streams(new PumpStreamHandler((pumps = this.pumps()) == null ? null : pumps.getOut(), output, pumps == null ? null : pumps.getInput()));
        this.redirectErrorStream(false);
        return this;
    }

    public ProcessExecutor redirectOutputAlsoTo(OutputStream output) {
        return this.streams(ProcessExecutor.redirectOutputAlsoTo(this.pumps(), output));
    }

    public ProcessExecutor redirectErrorAlsoTo(OutputStream output) {
        this.streams(ProcessExecutor.redirectErrorAlsoTo(this.pumps(), output));
        this.redirectErrorStream(false);
        return this;
    }

    public PumpStreamHandler pumps() {
        if (this.streams == null) {
            return null;
        }
        if (!(this.streams instanceof PumpStreamHandler)) {
            throw new IllegalStateException("Only PumpStreamHandler is supported.");
        }
        return (PumpStreamHandler)this.streams;
    }

    private static PumpStreamHandler redirectOutputAlsoTo(PumpStreamHandler pumps, OutputStream output) {
        if (output == null) {
            throw new IllegalArgumentException("OutputStream must be provided.");
        }
        OutputStream current = pumps.getOut();
        if (current != null && !(current instanceof NullOutputStream)) {
            output = new TeeOutputStream(current, output);
        }
        return new PumpStreamHandler(output, pumps.getErr(), pumps.getInput());
    }

    private static PumpStreamHandler redirectErrorAlsoTo(PumpStreamHandler pumps, OutputStream output) {
        if (output == null) {
            throw new IllegalArgumentException("OutputStream must be provided.");
        }
        OutputStream current = pumps.getErr();
        if (current != null && !(current instanceof NullOutputStream)) {
            output = new TeeOutputStream(current, output);
        }
        return new PumpStreamHandler(pumps.getOut(), output, pumps.getInput());
    }

    public ProcessExecutor readOutput(boolean readOutput) {
        this.validateStreams(this.streams, readOutput);
        this.readOutput = readOutput;
        return this;
    }

    private void validateStreams(ExecuteStreamHandler streams, boolean readOutput) {
        if (readOutput && !(streams instanceof PumpStreamHandler)) {
            throw new IllegalStateException("Only PumpStreamHandler is supported if readOutput is true.");
        }
    }

    public ProcessExecutor info(Logger log) {
        return this.redirectOutput(new Slf4jInfoOutputStream(log));
    }

    public ProcessExecutor debug(Logger log) {
        return this.redirectOutput(new Slf4jDebugOutputStream(log));
    }

    public ProcessExecutor info(String name) {
        return this.info(this.getCallerLogger(name));
    }

    public ProcessExecutor debug(String name) {
        return this.debug(this.getCallerLogger(name));
    }

    public ProcessExecutor info() {
        return this.info(this.getCallerLogger(null));
    }

    public ProcessExecutor debug() {
        return this.debug(this.getCallerLogger(null));
    }

    public ProcessExecutor redirectOutputAsInfo(Logger log) {
        return this.redirectOutput(new Slf4jInfoOutputStream(log));
    }

    public ProcessExecutor redirectOutputAsDebug(Logger log) {
        return this.redirectOutput(new Slf4jDebugOutputStream(log));
    }

    public ProcessExecutor redirectOutputAsInfo(String name) {
        return this.redirectOutputAsInfo(this.getCallerLogger(name));
    }

    public ProcessExecutor redirectOutputAsDebug(String name) {
        return this.redirectOutputAsDebug(this.getCallerLogger(name));
    }

    public ProcessExecutor redirectOutputAsInfo() {
        return this.redirectOutputAsInfo(this.getCallerLogger(null));
    }

    public ProcessExecutor redirectOutputAsDebug() {
        return this.redirectOutputAsDebug(this.getCallerLogger(null));
    }

    public ProcessExecutor redirectErrorAsInfo(Logger log) {
        return this.redirectError(new Slf4jInfoOutputStream(log));
    }

    public ProcessExecutor redirectErrorAsDebug(Logger log) {
        return this.redirectError(new Slf4jDebugOutputStream(log));
    }

    public ProcessExecutor redirectErrorAsInfo(String name) {
        return this.redirectErrorAsInfo(this.getCallerLogger(name));
    }

    public ProcessExecutor redirectErrorAsDebug(String name) {
        return this.redirectErrorAsDebug(this.getCallerLogger(name));
    }

    public ProcessExecutor redirectErrorAsInfo() {
        return this.redirectErrorAsInfo(this.getCallerLogger(null));
    }

    public ProcessExecutor redirectErrorAsDebug() {
        return this.redirectErrorAsDebug(this.getCallerLogger(null));
    }

    private Logger getCallerLogger(String name) {
        return LoggerFactory.getLogger((String)CallerLoggerUtil.getName(name, 2));
    }

    public ProcessExecutor addDestroyer(ProcessDestroyer destroyer) {
        return this.addListener(new DestroyerListenerAdapter(destroyer));
    }

    public ProcessExecutor destroyer(ProcessDestroyer destroyer) {
        this.removeListeners(DestroyerListenerAdapter.class);
        if (destroyer != null) {
            this.addListener(new DestroyerListenerAdapter(destroyer));
        }
        return this;
    }

    public ProcessExecutor destroyOnExit() {
        return this.destroyer(ShutdownHookProcessDestroyer.INSTANCE);
    }

    public ProcessExecutor listener(ProcessListener listener) {
        this.clearListeners();
        if (listener != null) {
            this.addListener(listener);
        }
        return this;
    }

    public ProcessExecutor addListener(ProcessListener listener) {
        this.listeners.add(listener);
        return this;
    }

    public ProcessExecutor removeListener(ProcessListener listener) {
        this.listeners.remove(listener);
        return this;
    }

    public ProcessExecutor removeListeners(Class<? extends ProcessListener> listenerType) {
        this.listeners.removeAll(listenerType);
        return this;
    }

    public ProcessExecutor clearListeners() {
        this.listeners.clear();
        return this;
    }

    public ProcessExecutor setMessageLogger(MessageLogger messageLogger) {
        this.messageLogger = messageLogger;
        return this;
    }

    public ProcessResult execute() throws IOException, InterruptedException, TimeoutException, InvalidExitValueException {
        return this.waitFor(this.startInternal());
    }

    public ProcessResult executeNoTimeout() throws IOException, InterruptedException, InvalidExitValueException {
        return this.startInternal().call();
    }

    public void checkExitValue(ProcessResult result) throws InvalidExitValueException {
        InvalidExitUtil.checkExit(this.getAttributes(), result);
    }

    public StartedProcess start() throws IOException {
        WaitForProcess task = this.startInternal();
        ExecutorService service = this.newExecutor(task);
        Future<ProcessResult> future = this.invokeSubmit(service, task);
        if (service != null) {
            service.shutdown();
        }
        return new StartedProcess(task.getProcess(), future);
    }

    protected final WaitForProcess startInternal() throws IOException {
        this.listeners.beforeStart(this);
        if (this.builder.command().isEmpty()) {
            throw new IllegalStateException("Command has not been set.");
        }
        this.validateStreams(this.streams, this.readOutput);
        this.applyEnvironment();
        this.messageLogger.message(log, this.getExecutingLogMessage(), new Object[0]);
        Process process = this.invokeStart();
        this.messageLogger.message(log, "Started {}", process);
        ProcessAttributes attributes = this.getAttributes();
        ExecuteStreamHandler newStreams = this.streams;
        ByteArrayOutputStream out = null;
        if (this.readOutput) {
            PumpStreamHandler pumps = (PumpStreamHandler)this.streams;
            out = new ByteArrayOutputStream();
            newStreams = ProcessExecutor.redirectOutputAlsoTo(pumps, out);
        }
        return this.startInternal(process, attributes, newStreams, out);
    }

    private ProcessAttributes getAttributes() {
        return new ProcessAttributes(this.getCommand(), this.getDirectory(), new LinkedHashMap<String, String>(this.environment), (Set<Integer>)(this.allowedExitValues == null ? null : new HashSet<Integer>(this.allowedExitValues)));
    }

    private Process invokeStart() throws IOException {
        try {
            return this.builder.start();
        }
        catch (IOException e) {
            if (e.getClass().equals(IOException.class)) {
                String message = this.getExecutingErrorMessage();
                ProcessInitException p = ProcessInitException.newInstance(message, e);
                if (p != null) {
                    throw p;
                }
                throw new IOException(message, e);
            }
            throw e;
        }
        catch (RuntimeException e) {
            if (e.getClass().equals(IllegalArgumentException.class)) {
                throw new IllegalArgumentException(this.getExecutingErrorMessage(), e);
            }
            throw e;
        }
    }

    private String getExecutingLogMessage() {
        return "Executing " + this.getExecutingMessageParams();
    }

    private String getExecutingErrorMessage() {
        return "Could not execute " + this.getExecutingMessageParams();
    }

    private String getExecutingMessageParams() {
        String result = "" + this.builder.command();
        if (this.builder.directory() != null) {
            result = result + " in " + this.builder.directory();
        }
        if (!this.environment.isEmpty()) {
            result = result + " with environment " + this.environment;
        }
        result = result + ".";
        return result;
    }

    private WaitForProcess startInternal(Process process, ProcessAttributes attributes, ExecuteStreamHandler streams, ByteArrayOutputStream out) throws IOException {
        if (streams != null) {
            try {
                streams.setProcessInputStream(process.getOutputStream());
                streams.setProcessOutputStream(process.getInputStream());
                if (!this.builder.redirectErrorStream()) {
                    streams.setProcessErrorStream(process.getErrorStream());
                }
            }
            catch (IOException e) {
                process.destroy();
                throw e;
            }
            streams.start();
        }
        ProcessCloser closer = this.newProcessCloser(streams);
        WaitForProcess result = new WaitForProcess(process, attributes, this.stopper, closer, out, this.listeners.clone(), this.messageLogger);
        this.listeners.afterStart(process, this);
        return result;
    }

    private ProcessCloser newProcessCloser(ExecuteStreamHandler streams) {
        if (this.closeTimeout == null) {
            return new StandardProcessCloser(streams);
        }
        return new TimeoutProcessCloser(streams, this.closeTimeout, this.closeTimeoutUnit);
    }

    private ProcessResult waitFor(WaitForProcess task) throws IOException, InterruptedException, TimeoutException {
        ProcessResult result;
        if (this.timeout == null) {
            result = task.call();
        } else {
            ExecutorService service = this.newExecutor(task);
            long _timeout = this.timeout;
            TimeUnit unit = this.timeoutUnit;
            try {
                result = this.invokeSubmit(service, task).get(_timeout, unit);
            }
            catch (ExecutionException e) {
                Throwable c = e.getCause();
                if (c instanceof IOException) {
                    throw (IOException)c;
                }
                if (c instanceof InterruptedException) {
                    throw (InterruptedException)c;
                }
                if (c instanceof InvalidExitValueException) {
                    InvalidExitValueException i = (InvalidExitValueException)c;
                    throw new InvalidExitValueException(i.getMessage(), i.getResult());
                }
                if (c instanceof InvalidOutputException) {
                    InvalidOutputException i = (InvalidOutputException)c;
                    throw new InvalidOutputException(i.getMessage(), i.getResult());
                }
                if (c.getClass().equals(InvalidResultException.class)) {
                    InvalidResultException p = (InvalidResultException)c;
                    throw new InvalidResultException(p.getMessage(), p.getResult());
                }
                throw new IllegalStateException("Error occured while waiting for process to finish:", c);
            }
            catch (TimeoutException e) {
                this.messageLogger.message(log, "{} is running too long", task);
                throw this.newTimeoutException(_timeout, unit, task);
            }
            finally {
                service.shutdownNow();
            }
        }
        return result;
    }

    private ExecutorService newExecutor(WaitForProcess task) {
        return this.newExecutor(task.getProcess().toString());
    }

    protected ExecutorService newExecutor(String processName) {
        final String name = "WaitForProcess-" + processName;
        ScheduledExecutorService service = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r, name);
                t.setDaemon(true);
                return t;
            }
        });
        return service;
    }

    protected <T> Future<T> invokeSubmit(ExecutorService executor, Callable<T> task) {
        return executor.submit(this.wrapTask(task));
    }

    protected <T> Callable<T> wrapTask(Callable<T> task) {
        Map contextMap = MDC.getCopyOfContextMap();
        if (contextMap != null) {
            return new MDCCallableAdapter<T>(task, contextMap);
        }
        return task;
    }

    private TimeoutException newTimeoutException(long timeout, TimeUnit unit, WaitForProcess task) {
        StackTraceElement[] stackTrace;
        StringBuilder sb = new StringBuilder();
        Process process = task.getProcess();
        Integer exitValue = ProcessExecutor.getExitCodeOrNull(process);
        if (exitValue == null) {
            sb.append("Timed out waiting for ").append(process).append(" to finish");
        } else {
            sb.append("Timed out finishing ").append(process);
            sb.append(", exit value: ").append(exitValue);
        }
        sb.append(", timeout: ").append(timeout).append(" ").append(ProcessExecutor.getUnitsAsString(timeout, unit));
        task.addExceptionMessageSuffix(sb);
        TimeoutException result = new TimeoutException(sb.toString());
        if (exitValue != null && (stackTrace = task.getStackTrace()) != null) {
            Exception cause = new Exception("Stack dump of worker thread.");
            cause.setStackTrace(stackTrace);
            result.initCause(cause);
        }
        return result;
    }

    private static String getUnitsAsString(long d, TimeUnit unit) {
        String result = unit.toString().toLowerCase();
        if (d == 1L) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }

    private static Integer getExitCodeOrNull(Process process) {
        try {
            return process.exitValue();
        }
        catch (IllegalThreadStateException e) {
            return null;
        }
    }

    private void applyEnvironment() {
        if (this.environment.isEmpty()) {
            return;
        }
        Map<String, String> env = this.builder.environment();
        for (Map.Entry<String, String> e : this.environment.entrySet()) {
            String key = e.getKey();
            String value = e.getValue();
            if (value == null) {
                env.remove(key);
                continue;
            }
            env.put(key, value);
        }
    }

    private static List<String> fixArguments(List<String> command) {
        if (!IS_OS_WINDOWS) {
            return command;
        }
        ArrayList<String> result = new ArrayList<String>(command);
        ListIterator<String> it = result.listIterator();
        while (it.hasNext()) {
            if (!"".equals(it.next())) continue;
            it.set("\"\"");
        }
        return result;
    }
}

