/*
 * Decompiled with CFR 0.152.
 */
package dev.monosoul.jooq.shadow.org.testcontainers.utility;

import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.DockerCmd;
import dev.monosoul.jooq.shadow.org.jetbrains.annotations.NotNull;
import dev.monosoul.jooq.shadow.org.jetbrains.annotations.Nullable;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.com.fasterxml.jackson.core.JsonProcessingException;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.com.google.common.base.Strings;
import dev.monosoul.jooq.shadow.org.testcontainers.shaded.org.apache.commons.lang3.StringUtils;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public final class AuditLogger {
    private static final Logger log = LoggerFactory.getLogger(AuditLogger.class);
    private static final ObjectMapper objectMapper = new ObjectMapper();
    public static final String MDC_PREFIX = AuditLogger.class.getCanonicalName();

    public static void doLog(@NotNull String action, @Nullable String image, @Nullable String containerId, @NotNull DockerCmd<?> cmd) {
        AuditLogger.doLog(action, image, containerId, cmd, null);
    }

    public static void doLog(@NotNull String action, @Nullable String image, @Nullable String containerId, @NotNull DockerCmd<?> cmd, @Nullable Exception e) {
        if (!log.isTraceEnabled()) {
            return;
        }
        MDC.put((String)(MDC_PREFIX + ".Action"), (String)Strings.nullToEmpty(action));
        MDC.put((String)(MDC_PREFIX + ".Image"), (String)Strings.nullToEmpty(image));
        MDC.put((String)(MDC_PREFIX + ".ContainerId"), (String)Strings.nullToEmpty(containerId));
        try {
            MDC.put((String)(MDC_PREFIX + ".Command"), (String)objectMapper.writeValueAsString(cmd));
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
        if (e != null) {
            MDC.put((String)(MDC_PREFIX + ".Exception"), (String)e.getLocalizedMessage());
            log.trace("{} action with image: {}, containerId: {}", new Object[]{action, image, containerId, e});
        } else {
            log.trace("{} action with image: {}, containerId: {}", new Object[]{action, image, containerId});
        }
        MDC.remove((String)(MDC_PREFIX + ".Action"));
        MDC.remove((String)(MDC_PREFIX + ".Image"));
        MDC.remove((String)(MDC_PREFIX + ".ContainerId"));
        MDC.remove((String)(MDC_PREFIX + ".Command"));
        MDC.remove((String)(MDC_PREFIX + ".Exception"));
    }

    public static void doComposeLog(@NotNull String[] commandParts, @Nullable List<String> env) {
        if (!log.isTraceEnabled()) {
            return;
        }
        MDC.put((String)(MDC_PREFIX + ".Action"), (String)"COMPOSE");
        if (env != null) {
            MDC.put((String)(MDC_PREFIX + ".Compose.Env"), (String)env.toString());
        }
        String command = StringUtils.join((Object[])commandParts, ' ');
        MDC.put((String)(MDC_PREFIX + ".Compose.Command"), (String)command);
        log.trace("COMPOSE action with command: {}, env: {}", (Object)command, env);
        MDC.remove((String)(MDC_PREFIX + ".Action"));
        MDC.remove((String)(MDC_PREFIX + ".Compose.Command"));
        MDC.remove((String)(MDC_PREFIX + ".Compose.Env"));
    }

    private AuditLogger() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

