/*
 * Decompiled with CFR 0.152.
 */
package dev.monosoul.jooq.shadow.org.testcontainers.utility;

import dev.monosoul.jooq.shadow.org.testcontainers.shaded.com.google.common.annotations.VisibleForTesting;
import dev.monosoul.jooq.shadow.org.testcontainers.utility.ConfigurationFileImageNameSubstitutor;
import dev.monosoul.jooq.shadow.org.testcontainers.utility.DockerImageName;
import dev.monosoul.jooq.shadow.org.testcontainers.utility.ImageNameSubstitutor;
import dev.monosoul.jooq.shadow.org.testcontainers.utility.PrefixingImageNameSubstitutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DefaultImageNameSubstitutor
extends ImageNameSubstitutor {
    private static final Logger log = LoggerFactory.getLogger(DefaultImageNameSubstitutor.class);
    private final ConfigurationFileImageNameSubstitutor configurationFileImageNameSubstitutor;
    private final PrefixingImageNameSubstitutor prefixingImageNameSubstitutor;

    public DefaultImageNameSubstitutor() {
        this.configurationFileImageNameSubstitutor = new ConfigurationFileImageNameSubstitutor();
        this.prefixingImageNameSubstitutor = new PrefixingImageNameSubstitutor();
    }

    @VisibleForTesting
    DefaultImageNameSubstitutor(ConfigurationFileImageNameSubstitutor configurationFileImageNameSubstitutor, PrefixingImageNameSubstitutor prefixingImageNameSubstitutor) {
        this.configurationFileImageNameSubstitutor = configurationFileImageNameSubstitutor;
        this.prefixingImageNameSubstitutor = prefixingImageNameSubstitutor;
    }

    @Override
    public DockerImageName apply(DockerImageName original) {
        return this.configurationFileImageNameSubstitutor.andThen(this.prefixingImageNameSubstitutor).apply(original);
    }

    @Override
    protected String getDescription() {
        return "DefaultImageNameSubstitutor (composite of '" + this.configurationFileImageNameSubstitutor.getDescription() + "' and '" + this.prefixingImageNameSubstitutor.getDescription() + "')";
    }
}

