/*
 * Decompiled with CFR 0.152.
 */
package dev.monosoul.jooq.shadow.org.testcontainers.utility;

import dev.monosoul.jooq.shadow.org.rnorth.ducttape.timeouts.Timeouts;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;

public abstract class LazyFuture<T>
implements Future<T> {
    private final AtomicReference<Object> resolvedValue = new AtomicReference();

    protected abstract T resolve();

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return false;
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    @Override
    public boolean isDone() {
        return this.resolvedValue.get() != null;
    }

    @Override
    public T get() {
        return this.getResolvedValue();
    }

    @Override
    public T get(long timeout, TimeUnit unit) throws TimeoutException {
        try {
            return (T)Timeouts.getWithTimeout((int)timeout, unit, this::get);
        }
        catch (dev.monosoul.jooq.shadow.org.rnorth.ducttape.TimeoutException e) {
            throw new TimeoutException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    T getResolvedValue() {
        Object value = this.resolvedValue.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.resolvedValue;
            synchronized (atomicReference) {
                value = this.resolvedValue.get();
                if (value == null) {
                    T actualValue = this.resolve();
                    value = actualValue == null ? this.resolvedValue : actualValue;
                    this.resolvedValue.set(value);
                }
            }
        }
        return (T)(value == this.resolvedValue ? null : value);
    }
}

