/*
 * Decompiled with CFR 0.152.
 */
package dev.monosoul.jooq.shadow.org.testcontainers.utility;

import dev.monosoul.jooq.shadow.org.testcontainers.shaded.com.google.common.annotations.VisibleForTesting;
import dev.monosoul.jooq.shadow.org.testcontainers.utility.DockerImageName;
import dev.monosoul.jooq.shadow.org.testcontainers.utility.ImageNameSubstitutor;
import dev.monosoul.jooq.shadow.org.testcontainers.utility.TestcontainersConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class PrefixingImageNameSubstitutor
extends ImageNameSubstitutor {
    private static final Logger log = LoggerFactory.getLogger(PrefixingImageNameSubstitutor.class);
    @VisibleForTesting
    static final String PREFIX_PROPERTY_KEY = "hub.image.name.prefix";
    private TestcontainersConfiguration configuration = TestcontainersConfiguration.getInstance();

    @VisibleForTesting
    PrefixingImageNameSubstitutor(TestcontainersConfiguration configuration2) {
        this.configuration = configuration2;
    }

    @Override
    public DockerImageName apply(DockerImageName original) {
        String configuredPrefix = this.configuration.getEnvVarOrProperty(PREFIX_PROPERTY_KEY, "");
        if (configuredPrefix.isEmpty()) {
            log.debug("No prefix is configured");
            return original;
        }
        boolean isAHubImage = original.getRegistry().isEmpty();
        if (!isAHubImage) {
            log.debug("Image {} is not a Docker Hub image - not applying registry/repository change", (Object)original);
            return original;
        }
        log.debug("Applying changes to image name {}: applying prefix '{}'", (Object)original, (Object)configuredPrefix);
        DockerImageName prefixAsImage = DockerImageName.parse(configuredPrefix);
        return original.withRegistry(prefixAsImage.getRegistry()).withRepository(prefixAsImage.getRepository() + original.getRepository());
    }

    @Override
    protected String getDescription() {
        return this.getClass().getSimpleName();
    }

    public PrefixingImageNameSubstitutor() {
    }
}

