/*
 * Decompiled with CFR 0.152.
 */
package dev.monosoul.jooq.shadow.org.testcontainers.utility;

import dev.monosoul.jooq.shadow.com.github.dockerjava.api.command.CreateContainerCmd;
import dev.monosoul.jooq.shadow.org.rnorth.ducttape.ratelimits.RateLimiter;
import dev.monosoul.jooq.shadow.org.rnorth.ducttape.ratelimits.RateLimiterBuilder;
import dev.monosoul.jooq.shadow.org.testcontainers.DockerClientFactory;
import dev.monosoul.jooq.shadow.org.testcontainers.containers.GenericContainer;
import dev.monosoul.jooq.shadow.org.testcontainers.utility.ResourceReaper;
import dev.monosoul.jooq.shadow.org.testcontainers.utility.RyukContainer;
import dev.monosoul.jooq.shadow.org.testcontainers.utility.TestcontainersConfiguration;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RyukResourceReaper
extends ResourceReaper {
    private static final Logger log = LoggerFactory.getLogger(RyukResourceReaper.class);
    private static final RateLimiter RYUK_ACK_RATE_LIMITER = RateLimiterBuilder.newBuilder().withRate(4, TimeUnit.SECONDS).withConstantThroughput().build();
    private final AtomicBoolean started = new AtomicBoolean(false);
    private final RyukContainer ryukContainer = new RyukContainer();

    RyukResourceReaper() {
    }

    @Override
    public void init() {
        if (!TestcontainersConfiguration.getInstance().environmentSupportsReuse()) {
            log.debug("Ryuk is enabled");
            this.maybeStart();
            log.info("Ryuk started - will monitor and terminate Testcontainers containers on JVM exit");
        } else {
            log.debug("Ryuk is enabled but will be started on demand");
        }
    }

    @Override
    public void registerLabelsFilterForCleanup(Map<String, String> labels) {
        this.maybeStart();
        super.registerLabelsFilterForCleanup(labels);
    }

    @Override
    public Map<String, String> getLabels() {
        this.maybeStart();
        return super.getLabels();
    }

    @Override
    public CreateContainerCmd register(GenericContainer<?> container, CreateContainerCmd cmd) {
        if (container == this.ryukContainer) {
            return cmd;
        }
        this.maybeStart();
        return super.register(container, cmd);
    }

    private synchronized void maybeStart() {
        if (!this.started.compareAndSet(false, true)) {
            return;
        }
        this.ryukContainer.start();
        CountDownLatch ryukScheduledLatch = new CountDownLatch(1);
        String host = this.ryukContainer.getHost();
        Integer ryukPort = this.ryukContainer.getFirstMappedPort();
        Thread kiraThread = new Thread(DockerClientFactory.TESTCONTAINERS_THREAD_GROUP, () -> {
            while (true) {
                RYUK_ACK_RATE_LIMITER.doWhenReady(() -> {
                    int index = 0;
                    try {
                        Socket clientSocket = new Socket();
                        Throwable throwable = null;
                        try {
                            try {
                                clientSocket.connect(new InetSocketAddress(host, (int)ryukPort), 5000);
                                ResourceReaper.FilterRegistry registry = new ResourceReaper.FilterRegistry(clientSocket.getInputStream(), clientSocket.getOutputStream());
                                List<List<Map.Entry<String, String>>> list = ResourceReaper.DEATH_NOTE;
                                synchronized (list) {
                                    while (true) {
                                        if (ResourceReaper.DEATH_NOTE.size() <= index) {
                                            try {
                                                ResourceReaper.DEATH_NOTE.wait(1000L);
                                            }
                                            catch (InterruptedException e) {
                                                throw new RuntimeException(e);
                                            }
                                        }
                                        List<Map.Entry<String, String>> filters = ResourceReaper.DEATH_NOTE.get(index);
                                        boolean isAcknowledged = registry.register(filters);
                                        if (isAcknowledged) {
                                            log.debug("Received 'ACK' from Ryuk");
                                            ryukScheduledLatch.countDown();
                                            ++index;
                                            continue;
                                        }
                                        log.debug("Didn't receive 'ACK' from Ryuk. Will retry to send filters.");
                                    }
                                }
                            }
                            catch (Throwable throwable2) {
                                throwable = throwable2;
                                throw throwable2;
                            }
                        }
                        catch (Throwable throwable3) {
                            if (clientSocket != null) {
                                if (throwable != null) {
                                    try {
                                        clientSocket.close();
                                    }
                                    catch (Throwable throwable4) {
                                        throwable.addSuppressed(throwable4);
                                    }
                                } else {
                                    clientSocket.close();
                                }
                            }
                            throw throwable3;
                        }
                    }
                    catch (IOException e) {
                        log.warn("Can not connect to Ryuk at {}:{}", new Object[]{host, ryukPort, e});
                        return;
                    }
                });
            }
        }, "testcontainers-ryuk");
        kiraThread.setDaemon(true);
        kiraThread.start();
        if (!ryukScheduledLatch.await(TestcontainersConfiguration.getInstance().getRyukTimeout().intValue(), TimeUnit.SECONDS)) {
            log.error("Timed out waiting for Ryuk container to start. Ryuk's logs:\n{}", (Object)this.ryukContainer.getLogs());
            throw new IllegalStateException(String.format("Could not connect to Ryuk at %s:%s", host, ryukPort));
        }
    }
}

