/*
 * Decompiled with CFR 0.152.
 */
package dev.monosoul.jooq.container;

import dev.monosoul.jooq.settings.Database;
import dev.monosoul.jooq.settings.Image;
import dev.monosoul.jooq.shadow.org.jetbrains.annotations.NotNull;
import dev.monosoul.jooq.shadow.org.jetbrains.annotations.Nullable;
import dev.monosoul.jooq.shadow.org.testcontainers.containers.JdbcDatabaseContainer;
import dev.monosoul.jooq.shadow.org.testcontainers.containers.output.Slf4jLogConsumer;
import dev.monosoul.jooq.shadow.org.testcontainers.containers.wait.strategy.HostPortWaitStrategy;
import dev.monosoul.jooq.shadow.org.testcontainers.dockerclient.DockerClientProviderStrategy;
import dev.monosoul.jooq.shadow.org.testcontainers.utility.DockerImageName;
import java.sql.Driver;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KCallable;
import kotlin.reflect.KClass;
import kotlin.reflect.full.KClasses;
import kotlin.reflect.jvm.KCallablesJvm;
import kotlin.text.StringsKt;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\u0018\u0000 \u00162\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0016B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\r\u001a\u00020\u000eH\u0016J\b\u0010\u000f\u001a\u00020\u000eH\u0016J\b\u0010\u0010\u001a\u00020\nH\u0016J\b\u0010\u0011\u001a\u00020\u000eH\u0016J\b\u0010\u0012\u001a\u00020\nH\u0002J\b\u0010\u0013\u001a\u00020\u000eH\u0016J\b\u0010\u0014\u001a\u00020\u000eH\u0014J\b\u0010\u0015\u001a\u00020\u000eH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Ldev/monosoul/jooq/container/GenericDatabaseContainer;", "Ldev/monosoul/jooq/shadow/org/testcontainers/containers/JdbcDatabaseContainer;", "image", "Ldev/monosoul/jooq/settings/Image;", "database", "Ldev/monosoul/jooq/settings/Database$Internal;", "jdbcAwareClassLoader", "Ljava/lang/ClassLoader;", "(Ldev/monosoul/jooq/settings/Image;Ldev/monosoul/jooq/settings/Database$Internal;Ljava/lang/ClassLoader;)V", "driver", "Ljava/sql/Driver;", "driverLoadLock", "Ljava/util/concurrent/locks/ReentrantLock;", "getDatabaseName", "", "getDriverClassName", "getJdbcDriverInstance", "getJdbcUrl", "getNewJdbcDriverInstance", "getPassword", "getTestQueryString", "getUsername", "Companion", "jooq-gradle-plugin"})
@SourceDebugExtension(value={"SMAP\nGenericDatabaseContainer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GenericDatabaseContainer.kt\ndev/monosoul/jooq/container/GenericDatabaseContainer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,96:1\n1#2:97\n626#3,12:98\n*S KotlinDebug\n*F\n+ 1 GenericDatabaseContainer.kt\ndev/monosoul/jooq/container/GenericDatabaseContainer\n*L\n88#1:98,12\n*E\n"})
public final class GenericDatabaseContainer
extends JdbcDatabaseContainer<GenericDatabaseContainer> {
    @NotNull
    private static final Companion Companion;
    @NotNull
    private final Image image;
    @NotNull
    private final Database.Internal database;
    @NotNull
    private final ClassLoader jdbcAwareClassLoader;
    @NotNull
    private final ReentrantLock driverLoadLock;
    @Nullable
    private Driver driver;
    @NotNull
    private static final AtomicBoolean failFastAlways;

    /*
     * WARNING - void declaration
     */
    public GenericDatabaseContainer(@NotNull Image image, @NotNull Database.Internal database, @NotNull ClassLoader jdbcAwareClassLoader) {
        block0: {
            void it;
            Intrinsics.checkNotNullParameter((Object)image, (String)"image");
            Intrinsics.checkNotNullParameter((Object)database, (String)"database");
            Intrinsics.checkNotNullParameter((Object)jdbcAwareClassLoader, (String)"jdbcAwareClassLoader");
            Object object = image;
            GenericDatabaseContainer genericDatabaseContainer = this;
            boolean bl = false;
            failFastAlways.set(false);
            super(DockerImageName.parse(it.getName()));
            this.image = image;
            this.database = database;
            this.jdbcAwareClassLoader = jdbcAwareClassLoader;
            this.driverLoadLock = new ReentrantLock();
            this.withLogConsumer((Consumer)new Slf4jLogConsumer(LoggerFactory.getLogger((String)("JooqGenerationDb[" + this.getDockerImageName() + ']'))));
            this.withEnv((Map)this.image.getEnvVars());
            Integer[] integerArray = new Integer[]{this.database.getPort()};
            this.withExposedPorts(integerArray);
            this.setWaitStrategy(new HostPortWaitStrategy());
            Object it2 = object = this.image.getCommand();
            boolean bl2 = false;
            CharSequence charSequence = (CharSequence)it2;
            Object object2 = !(charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) ? object : null;
            if (object2 == null) break block0;
            Object p0 = object2;
            boolean $i$f$_init_$stub_for_inlining = false;
            boolean bl3 = false;
            GenericDatabaseContainer cfr_ignored_0 = (GenericDatabaseContainer)this.withCommand((String)p0);
        }
    }

    @Override
    @NotNull
    public String getDriverClassName() {
        return this.database.getJdbc$jooq_gradle_plugin().getDriverClassName();
    }

    @Override
    @NotNull
    public String getJdbcUrl() {
        String string = this.getHost();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"host");
        Integer n = this.getMappedPort(this.database.getPort());
        Intrinsics.checkNotNullExpressionValue((Object)n, (String)"getMappedPort(database.port)");
        return this.database.getJdbcUrl$jooq_gradle_plugin(string, ((Number)n).intValue());
    }

    @Override
    @NotNull
    public String getUsername() {
        return this.database.getUsername();
    }

    @Override
    @NotNull
    public String getPassword() {
        return this.database.getPassword();
    }

    @Override
    @NotNull
    protected String getTestQueryString() {
        return this.image.getTestQuery();
    }

    @Override
    @NotNull
    public String getDatabaseName() {
        return this.database.getName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Driver getJdbcDriverInstance() {
        if (this.driver == null) {
            Lock lock = this.driverLoadLock;
            lock.lock();
            try {
                boolean bl = false;
                if (this.driver == null) {
                    this.driver = this.getNewJdbcDriverInstance();
                }
                Unit unit = Unit.INSTANCE;
            }
            finally {
                lock.unlock();
            }
        }
        Driver driver = this.driver;
        Intrinsics.checkNotNull((Object)driver);
        return driver;
    }

    private final Driver getNewJdbcDriverInstance() {
        Driver driver;
        try {
            Object obj = this.jdbcAwareClassLoader.loadClass(this.getDriverClassName()).newInstance();
            Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type java.sql.Driver");
            driver = (Driver)obj;
        }
        catch (Exception e) {
            Exception exception = e;
            if ((exception instanceof InstantiationException ? true : exception instanceof IllegalAccessException) ? true : exception instanceof ClassNotFoundException) {
                throw new JdbcDatabaseContainer.NoDriverFoundException("Could not get Driver", e);
            }
            throw e;
        }
        return driver;
    }

    /*
     * WARNING - void declaration
     */
    static {
        void var1_2;
        Companion = new Companion(null);
        Iterable $this$single$iv = KClasses.getDeclaredMembers((KClass)Reflection.getOrCreateKotlinClass(DockerClientProviderStrategy.class));
        boolean $i$f$single = false;
        Object single$iv = null;
        boolean found$iv = false;
        for (Object element$iv : $this$single$iv) {
            KCallable it = (KCallable)element$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getName(), (Object)"FAIL_FAST_ALWAYS")) continue;
            if (found$iv) {
                throw new IllegalArgumentException("Collection contains more than one matching element.");
            }
            single$iv = element$iv;
            found$iv = true;
        }
        if (!found$iv) {
            throw new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        Object var0 = single$iv;
        KCallable $this$failFastAlways_u24lambda_u244 = var0;
        boolean bl = false;
        KCallablesJvm.setAccessible((KCallable)$this$failFastAlways_u24lambda_u244, (boolean)true);
        KCallable it = var0;
        boolean bl2 = false;
        Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type kotlin.reflect.KCallable<java.util.concurrent.atomic.AtomicBoolean>");
        failFastAlways = (AtomicBoolean)var1_2.call(new Object[0]);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Ldev/monosoul/jooq/container/GenericDatabaseContainer$Companion;", "", "()V", "failFastAlways", "Ljava/util/concurrent/atomic/AtomicBoolean;", "getFailFastAlways", "()Ljava/util/concurrent/atomic/AtomicBoolean;", "jooq-gradle-plugin"})
    private static final class Companion {
        private Companion() {
        }

        @NotNull
        public final AtomicBoolean getFailFastAlways() {
            return failFastAlways;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

