/*
 * Decompiled with CFR 0.152.
 */
package dev.monosoul.jooq.shadow.com.github.dockerjava.api.async;

import dev.monosoul.jooq.shadow.com.github.dockerjava.api.async.ResultCallback;
import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ResultCallbackTemplate<RC_T extends ResultCallback<A_RES_T>, A_RES_T>
implements ResultCallback<A_RES_T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResultCallbackTemplate.class);
    private final CountDownLatch started = new CountDownLatch(1);
    private final CountDownLatch completed = new CountDownLatch(1);
    private Closeable stream;
    private boolean closed = false;
    private Throwable firstError = null;

    @Override
    public void onStart(Closeable stream) {
        this.stream = stream;
        this.closed = false;
        this.started.countDown();
    }

    @Override
    public void onError(Throwable throwable) {
        if (this.closed) {
            return;
        }
        if (this.firstError == null) {
            this.firstError = throwable;
        }
        try {
            LOGGER.error("Error during callback", throwable);
        }
        finally {
            try {
                this.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void onComplete() {
        try {
            this.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            try {
                if (this.stream != null) {
                    this.stream.close();
                }
            }
            finally {
                this.completed.countDown();
            }
        }
    }

    public RC_T awaitCompletion() throws InterruptedException {
        try {
            this.completed.await();
            this.throwFirstError();
            ResultCallbackTemplate resultCallbackTemplate = this;
            return (RC_T)resultCallbackTemplate;
        }
        finally {
            try {
                this.close();
            }
            catch (IOException e) {
                LOGGER.debug("Failed to close", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean awaitCompletion(long timeout, TimeUnit timeUnit) throws InterruptedException {
        try {
            boolean result = this.completed.await(timeout, timeUnit);
            this.throwFirstError();
            boolean bl = result;
            return bl;
        }
        finally {
            try {
                this.close();
            }
            catch (IOException e) {
                LOGGER.debug("Failed to close", (Throwable)e);
            }
        }
    }

    public RC_T awaitStarted() throws InterruptedException {
        this.started.await();
        return (RC_T)this;
    }

    public boolean awaitStarted(long timeout, TimeUnit timeUnit) throws InterruptedException {
        return this.started.await(timeout, timeUnit);
    }

    protected void throwFirstError() {
        if (this.firstError != null) {
            if (this.firstError instanceof Error) {
                throw (Error)this.firstError;
            }
            if (this.firstError instanceof RuntimeException) {
                throw (RuntimeException)this.firstError;
            }
            throw new RuntimeException(this.firstError);
        }
    }
}

